/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Quaternion;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Transform;

public abstract class Transformable
extends Object3D {
    float[] scale = new float[3];
    float[] translation = new float[3];
    Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    Transform transform = new Transform();

    Transformable() {
        this.scale[2] = 1.0f;
        this.scale[1] = 1.0f;
        this.scale[0] = 1.0f;
    }

    public void setOrientation(float f2, float f3, float f4, float f5) {
        if (f2 != 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) {
            throw new IllegalArgumentException();
        }
        this.rotation.setAngleAxis(f2, f3, f4, f5);
    }

    public void getOrientation(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 4) {
            throw new IllegalArgumentException();
        }
        this.rotation.getAngleAxis(fArray);
    }

    public void preRotate(float f2, float f3, float f4, float f5) {
        if (f2 != 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) {
            throw new IllegalArgumentException();
        }
        Quaternion quaternion = new Quaternion();
        quaternion.setAngleAxis(f2, f3, f4, f5);
        quaternion.mul(this.rotation);
        this.rotation.set(quaternion);
    }

    public void postRotate(float f2, float f3, float f4, float f5) {
        if (f2 != 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 0.0f) {
            throw new IllegalArgumentException();
        }
        Quaternion quaternion = new Quaternion();
        quaternion.setAngleAxis(f2, f3, f4, f5);
        this.rotation.mul(quaternion);
    }

    public void setScale(float f2, float f3, float f4) {
        this.scale[0] = f2;
        this.scale[1] = f3;
        this.scale[2] = f4;
    }

    public void scale(float f2, float f3, float f4) {
        this.scale[0] = this.scale[0] * f2;
        this.scale[1] = this.scale[1] * f3;
        this.scale[2] = this.scale[2] * f4;
    }

    public void getScale(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.scale, 0, fArray, 0, 3);
    }

    public void setTranslation(float f2, float f3, float f4) {
        this.translation[0] = f2;
        this.translation[1] = f3;
        this.translation[2] = f4;
    }

    public void translate(float f2, float f3, float f4) {
        this.translation[0] = this.translation[0] + f2;
        this.translation[1] = this.translation[1] + f3;
        this.translation[2] = this.translation[2] + f4;
    }

    public void getTranslation(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (fArray.length < 3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.translation, 0, fArray, 0, 3);
    }

    public void setTransform(Transform transform) {
        if (transform == null) {
            this.transform.setIdentity();
        } else {
            this.transform.set(transform);
        }
    }

    public void getTransform(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        transform.set(this.transform);
    }

    public void getCompositeTransform(Transform transform) {
        if (transform == null) {
            throw new NullPointerException();
        }
        transform.setIdentity();
        transform.postTranslate(this.translation[0], this.translation[1], this.translation[2]);
        transform.postRotateQuat(this.rotation.x, this.rotation.y, this.rotation.z, this.rotation.w);
        transform.postScale(this.scale[0], this.scale[1], this.scale[2]);
        transform.postMultiply(this.transform);
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 268: {
                this.rotation.set(fArray);
                this.rotation.normalize();
                return;
            }
            case 270: {
                if (fArray.length == 1) {
                    this.scale[1] = this.scale[2] = fArray[0];
                    this.scale[0] = this.scale[2];
                } else {
                    this.scale[0] = fArray[0];
                    this.scale[1] = fArray[1];
                    this.scale[2] = fArray[2];
                }
                return;
            }
            case 275: {
                this.translation[0] = fArray[0];
                this.translation[1] = fArray[1];
                this.translation[2] = fArray[2];
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }

    @Override
    protected Object3D duplicateObject() {
        Transformable transformable = (Transformable)super.duplicateObject();
        ((Transformable)super.duplicateObject()).rotation = new Quaternion(this.rotation);
        transformable.transform = new Transform(this.transform);
        transformable.translation = (float[])this.translation.clone();
        transformable.scale = (float[])this.scale.clone();
        return transformable;
    }
}

