/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import kemnn.eA;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.RawDevice;
import net.java.games.input.RawDeviceInfo;
import net.java.games.input.RawInputEnvironmentPlugin$1;
import net.java.games.input.RawInputEnvironmentPlugin$2;
import net.java.games.input.RawInputEnvironmentPlugin$3;
import net.java.games.input.RawInputEventQueue;
import net.java.games.input.SetupAPIDevice;

public final class RawInputEnvironmentPlugin
extends ControllerEnvironment
implements eA {
    private static boolean supported = false;
    private final Controller[] controllers;

    static void loadLibrary(String string) {
        AccessController.doPrivileged(new RawInputEnvironmentPlugin$1(string));
    }

    static String getPrivilegedProperty(String string) {
        return (String)AccessController.doPrivileged(new RawInputEnvironmentPlugin$2(string));
    }

    static String getPrivilegedProperty(String string, String string2) {
        return (String)AccessController.doPrivileged(new RawInputEnvironmentPlugin$3(string, string2));
    }

    public RawInputEnvironmentPlugin() {
        Controller[] controllerArray = new Controller[]{};
        if (this.isSupported()) {
            try {
                RawInputEventQueue rawInputEventQueue = new RawInputEventQueue();
                controllerArray = this.enumControllers(rawInputEventQueue);
            }
            catch (IOException iOException) {
                RawInputEnvironmentPlugin.logln(new StringBuffer().append("Failed to enumerate devices: ").append(iOException.getMessage()).toString());
            }
        }
        this.controllers = controllerArray;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private static final SetupAPIDevice lookupSetupAPIDevice(String string, List list2) {
        string = string.replaceAll("#", "\\\\").toUpperCase();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            SetupAPIDevice setupAPIDevice = (SetupAPIDevice)list2.get(i2);
            if (string.indexOf(setupAPIDevice.getInstanceId().toUpperCase()) == -1) continue;
            return setupAPIDevice;
        }
        return null;
    }

    private static final void createControllersFromDevices(RawInputEventQueue rawInputEventQueue, List list2, List list3, List list4) {
        ArrayList<RawDevice> arrayList = new ArrayList<RawDevice>();
        for (int i2 = 0; i2 < list3.size(); ++i2) {
            RawDeviceInfo rawDeviceInfo;
            Controller controller;
            RawDevice rawDevice = (RawDevice)list3.get(i2);
            SetupAPIDevice setupAPIDevice = RawInputEnvironmentPlugin.lookupSetupAPIDevice(rawDevice.getName(), list4);
            if (setupAPIDevice == null || (controller = (rawDeviceInfo = rawDevice.getInfo()).createControllerFromDevice(rawDevice, setupAPIDevice)) == null) continue;
            list2.add(controller);
            arrayList.add(rawDevice);
        }
        rawInputEventQueue.start(arrayList);
    }

    private static final native void enumerateDevices(RawInputEventQueue var0, List var1);

    private final Controller[] enumControllers(RawInputEventQueue rawInputEventQueue) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        RawInputEnvironmentPlugin.enumerateDevices(rawInputEventQueue, arrayList2);
        List list2 = RawInputEnvironmentPlugin.enumSetupAPIDevices();
        RawInputEnvironmentPlugin.createControllersFromDevices(rawInputEventQueue, arrayList, arrayList2, list2);
        Controller[] controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    private static final List enumSetupAPIDevices() {
        ArrayList arrayList = new ArrayList();
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getKeyboardClassGUID(), arrayList);
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getMouseClassGUID(), arrayList);
        return arrayList;
    }

    private static final native void nEnumSetupAPIDevices(byte[] var0, List var1);

    private static final native byte[] getKeyboardClassGUID();

    private static final native byte[] getMouseClassGUID();

    static boolean access$002(boolean bl2) {
        supported = bl2;
        return supported;
    }

    static {
        String string = RawInputEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.startsWith("Windows")) {
            supported = true;
            if ("x86".equals(RawInputEnvironmentPlugin.getPrivilegedProperty("os.arch"))) {
                RawInputEnvironmentPlugin.loadLibrary("jinput-raw");
            } else {
                RawInputEnvironmentPlugin.loadLibrary("jinput-raw_64");
            }
        }
    }
}

