/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.bridj.CLong;
import org.bridj.NativeLibrary;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.TimeT;
import org.bridj.ValuedEnum;
import org.bridj.ann.Name;
import org.bridj.ann.Namespace;
import org.bridj.ann.Ptr;
import org.bridj.demangling.Demangler$1;
import org.bridj.demangling.Demangler$2;
import org.bridj.demangling.Demangler$Annotations;
import org.bridj.demangling.Demangler$ClassRef;
import org.bridj.demangling.Demangler$DemanglingException;
import org.bridj.demangling.Demangler$Ident;
import org.bridj.demangling.Demangler$JavaTypeRef;
import org.bridj.demangling.Demangler$MemberRef;
import org.bridj.demangling.Demangler$PointerTypeRef;
import org.bridj.demangling.Demangler$TemplateArg;
import org.bridj.demangling.Demangler$TypeRef;
import org.bridj.demangling.GCC4Demangler;
import org.bridj.demangling.VC9Demangler;
import org.bridj.util.DefaultParameterizedType;
import org.bridj.util.Utils;

public abstract class Demangler {
    protected final String str;
    protected final int length;
    protected int position = 0;
    protected final NativeLibrary library;

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            try {
                System.out.println("VC9: " + new VC9Demangler(null, string).parseSymbol());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                System.out.println("GCC4: " + new GCC4Demangler(null, string).parseSymbol());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Demangler$Annotations annotations(Annotation[] annotationArray) {
        return new Demangler$1(annotationArray);
    }

    public static Demangler$Annotations annotations(Type type) {
        return Demangler.annotations(Utils.getClass(type));
    }

    public static Demangler$Annotations annotations(AnnotatedElement annotatedElement) {
        return new Demangler$2(annotatedElement);
    }

    public abstract Demangler$MemberRef parseSymbol();

    public Demangler(NativeLibrary nativeLibrary, String string) {
        this.str = string;
        this.length = string.length();
        this.library = nativeLibrary;
    }

    public String getString() {
        return this.str;
    }

    protected void expectChars(char ... cArray) {
        for (char c2 : cArray) {
            char c3 = this.consumeChar();
            if (c3 == c2) continue;
            throw this.error("Expected char '" + c2 + "', found '" + c3 + "'");
        }
    }

    protected void expectAnyChar(char ... cArray) {
        char c2 = this.consumeChar();
        for (char c3 : cArray) {
            if (c2 != c3) continue;
            return;
        }
        throw this.error("Expected any of " + Arrays.toString(cArray) + ", found '" + c2 + "'");
    }

    public static StringBuilder implode(StringBuilder stringBuilder, Object[] objectArray, String string) {
        return Demangler.implode(stringBuilder, Arrays.asList(objectArray), string);
    }

    public static StringBuilder implode(StringBuilder stringBuilder, Iterable iterable, String string) {
        boolean bl2 = true;
        for (Object t2 : iterable) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(t2);
        }
        return stringBuilder;
    }

    protected char peekChar() {
        return this.peekChar(1);
    }

    protected char peekChar(int n2) {
        int n3 = this.position + n2 - 1;
        return n3 >= this.length ? (char)'\u0000' : this.str.charAt(n3);
    }

    protected char lastChar() {
        return this.position == 0 ? (char)'\u0000' : this.str.charAt(this.position - 1);
    }

    protected char consumeChar() {
        char c2 = this.peekChar();
        if (c2 != '\u0000') {
            ++this.position;
        } else {
            throw new Demangler$DemanglingException(this, "Reached end of string '" + this.str + "'");
        }
        return c2;
    }

    protected boolean consumeCharsIf(char ... cArray) {
        int n2 = this.position;
        try {
            for (char c2 : cArray) {
                char c3 = this.consumeChar();
                if (c3 == c2) continue;
                this.position = n2;
                return false;
            }
            return true;
        }
        catch (Demangler$DemanglingException demangler$DemanglingException) {
            this.position = n2;
            return false;
        }
    }

    protected boolean consumeCharIf(char ... cArray) {
        char c2 = this.peekChar();
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            ++this.position;
            return true;
        }
        return false;
    }

    protected Demangler$DemanglingException error(int n2) {
        return this.error(null, n2);
    }

    protected Demangler$DemanglingException error(String string) {
        return this.error(string, -1);
    }

    protected Demangler$DemanglingException error(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(this.position + 1);
        int n3 = this.position + n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('^');
        return new Demangler$DemanglingException(this, "Parsing error at position " + n3 + (string == null ? "" : ": " + string) + " \n\t" + this.str + "\n\t" + stringBuilder);
    }

    public static String getMethodName(Method method) {
        Name name = method.getAnnotation(Name.class);
        return name == null ? method.getName() : name.value();
    }

    public static String getClassName(Type type) {
        assert (type != null);
        Class clazz = Utils.getClass(type);
        Name name = clazz.getAnnotation(Name.class);
        return name == null ? clazz.getSimpleName() : name.value();
    }

    public static String getFullClassName(Type type) {
        Class clazz = Utils.getClass(type);
        String string = Demangler.getClassName(clazz);
        Namespace namespace = clazz.getAnnotation(Namespace.class);
        return namespace != null ? namespace.value().replaceAll("::", ".") + "." + string : string;
    }

    protected static Demangler$TypeRef pointerType(Demangler$TypeRef demangler$TypeRef, boolean bl2, boolean bl3) {
        return new Demangler$PointerTypeRef(demangler$TypeRef, bl2, bl3);
    }

    protected static Demangler$TypeRef classType(Class clazz, Class ... classArray) {
        return Demangler.classType(clazz, null, classArray);
    }

    protected static Demangler$TypeRef classType(Class clazz, Type[] typeArray, Class ... classArray) {
        Demangler$JavaTypeRef demangler$JavaTypeRef = new Demangler$JavaTypeRef();
        demangler$JavaTypeRef.type = typeArray == null ? clazz : new DefaultParameterizedType((Type)clazz, typeArray);
        demangler$JavaTypeRef.annotations = classArray;
        return demangler$JavaTypeRef;
    }

    protected static Demangler$TypeRef simpleType(String string, Demangler$TemplateArg ... demangler$TemplateArgArray) {
        return new Demangler$ClassRef(new Demangler$Ident(string, demangler$TemplateArgArray));
    }

    protected static Demangler$TypeRef simpleType(Demangler$Ident demangler$Ident) {
        return new Demangler$ClassRef(demangler$Ident);
    }

    static Class getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            if (ValuedEnum.class.isAssignableFrom(clazz)) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                clazz = typeArray == null || typeArray.length != 1 ? Integer.TYPE : Demangler.getTypeClass(parameterizedType.getActualTypeArguments()[0]);
            }
            return clazz;
        }
        if (type instanceof GenericArrayType && Object.class.isAssignableFrom(Demangler.getTypeClass(((GenericArrayType)type).getGenericComponentType()))) {
            return Object[].class;
        }
        return null;
    }

    private static Type normalize(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length == 1) {
                return Demangler.normalize(wildcardType.getLowerBounds()[0]);
            }
            return null;
        }
        Class clazz = Utils.getClass(type);
        if (clazz != null && clazz.isPrimitive()) {
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Void.TYPE) {
                return Void.class;
            }
        }
        return type;
    }

    static boolean equivalentTypes(Type type, Class clazz, Demangler$Annotations demangler$Annotations, Type type2, Class clazz2, Demangler$Annotations demangler$Annotations2) {
        if (Demangler.normalize(type).equals(Demangler.normalize(type2))) {
            return true;
        }
        if (demangler$Annotations != null && demangler$Annotations2 != null) {
            if (Demangler.xor(Demangler.isPointerLike(type, clazz, demangler$Annotations), Demangler.isPointerLike(type2, clazz2, demangler$Annotations2))) {
                return false;
            }
            if (Demangler.xor(Demangler.isCLong(type, clazz, demangler$Annotations), Demangler.isCLong(type2, clazz2, demangler$Annotations2))) {
                return false;
            }
        }
        int n2 = Demangler.getIntegralSize(type, clazz, demangler$Annotations);
        int n3 = Demangler.getIntegralSize(type2, clazz2, demangler$Annotations2);
        return n2 != -1 && n2 == n3;
    }

    static boolean xor(boolean bl2, boolean bl3) {
        return bl2 && !bl3 || !bl2 && bl3;
    }

    static boolean isPointerLike(Type type, Class clazz, Demangler$Annotations demangler$Annotations) {
        if (type == Long.TYPE || type == Long.class) {
            return demangler$Annotations == null && Pointer.SIZE == 8 || demangler$Annotations != null && demangler$Annotations.isAnnotationPresent(Ptr.class) && !demangler$Annotations.isAnnotationPresent(org.bridj.ann.CLong.class);
        }
        return type == SizeT.class || Pointer.class.isAssignableFrom(clazz);
    }

    static boolean isCLong(Type type, Class clazz, Demangler$Annotations demangler$Annotations) {
        if (type == Long.TYPE || type == Long.class) {
            return demangler$Annotations == null && CLong.SIZE == 8 || demangler$Annotations != null && demangler$Annotations.isAnnotationPresent(org.bridj.ann.CLong.class);
        }
        return type == CLong.class;
    }

    static int getIntegralSize(Type type, Class clazz, Demangler$Annotations demangler$Annotations) {
        if (type == Integer.TYPE || type == Integer.class) {
            return 4;
        }
        if (type == Long.TYPE || type == Long.class) {
            if (demangler$Annotations != null) {
                if (demangler$Annotations.isAnnotationPresent(Ptr.class)) {
                    return Pointer.SIZE;
                }
                if (demangler$Annotations.isAnnotationPresent(org.bridj.ann.CLong.class)) {
                    return CLong.SIZE;
                }
            }
            return 8;
        }
        if (type == CLong.class) {
            return CLong.SIZE;
        }
        if (type == SizeT.class) {
            return SizeT.SIZE;
        }
        if (type == TimeT.class) {
            return TimeT.SIZE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return 1;
        }
        if (type == Character.TYPE || type == Character.class || type == Short.TYPE || type == Short.class) {
            return 2;
        }
        if (ValuedEnum.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return SizeT.SIZE;
        }
        return -1;
    }

    public static boolean equivalentTypes(Type type, Demangler$Annotations demangler$Annotations, Type type2, Demangler$Annotations demangler$Annotations2) {
        return Demangler.equivalentTypes(type, Demangler.getTypeClass(type), demangler$Annotations, type2, Demangler.getTypeClass(type2), demangler$Annotations2);
    }

    static void appendTemplateArgs(StringBuilder stringBuilder, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        Demangler.appendArgs(stringBuilder, '<', '>', objectArray);
    }

    static void appendArgs(StringBuilder stringBuilder, char c2, char c3, Object[] objectArray) {
        stringBuilder.append(c2);
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(objectArray[i2]);
            }
        }
        stringBuilder.append(c3);
    }

    static /* synthetic */ Type access$000(Type type) {
        return Demangler.normalize(type);
    }
}

