/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.bridj.Platform;
import org.bridj.relocated.org.objectweb.asm.ClassReader;
import org.bridj.util.BytecodeAnalyzer$1;
import org.bridj.util.BytecodeAnalyzer$2;
import org.bridj.util.BytecodeAnalyzer$3;

public final class BytecodeAnalyzer {
    private BytecodeAnalyzer() {
    }

    public static List getNativeMethodSignatures(Class clazz) {
        return BytecodeAnalyzer.getNativeMethodSignatures(BytecodeAnalyzer.getInternalName(clazz), Platform.getClassLoader(clazz));
    }

    public static List getNativeMethodSignatures(String string, ClassLoader classLoader) {
        return BytecodeAnalyzer.getNativeMethodSignatures(string, classLoader, new ArrayList());
    }

    private static List getNativeMethodSignatures(String string, ClassLoader classLoader, List list2) {
        ClassReader classReader = new ClassReader(BytecodeAnalyzer.readByteCode(string, classLoader));
        String string2 = classReader.getSuperName();
        if (string2 != null && !string2.equals("java/lang/Object")) {
            BytecodeAnalyzer.getNativeMethodSignatures(string2, classLoader, list2);
        }
        classReader.accept(new BytecodeAnalyzer$1(list2, string), 7);
        return list2;
    }

    private static List getFieldNames(String string, String string2, ClassLoader classLoader, List list2) {
        ClassReader classReader = new ClassReader(BytecodeAnalyzer.readByteCode(string, classLoader));
        String string3 = classReader.getSuperName();
        if (string3 != null && !string3.equals("java/lang/Object") && !string2.equals(string)) {
            BytecodeAnalyzer.getFieldNames(string3, string2, classLoader, list2);
        }
        classReader.accept(new BytecodeAnalyzer$2(list2), 7);
        return list2;
    }

    private static List getMethodNames(String string, String string2, ClassLoader classLoader, List list2) {
        ClassReader classReader = new ClassReader(BytecodeAnalyzer.readByteCode(string, classLoader));
        String string3 = classReader.getSuperName();
        if (string3 != null && !string3.equals("java/lang/Object") && !string2.equals(string)) {
            BytecodeAnalyzer.getMethodNames(string3, string2, classLoader, list2);
        }
        classReader.accept(new BytecodeAnalyzer$3(list2), 7);
        return list2;
    }

    static String getInternalName(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    static URL getClassResource(Class clazz) {
        return BytecodeAnalyzer.getClassResource(BytecodeAnalyzer.getInternalName(clazz), Platform.getClassLoader(clazz));
    }

    static URL getClassResource(String string, ClassLoader classLoader) {
        String string2 = string + ".class";
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            throw new FileNotFoundException("Resource '" + string2 + "'");
        }
        return uRL;
    }

    static byte[] readByteCode(String string, ClassLoader classLoader) {
        return BytecodeAnalyzer.readBytes(BytecodeAnalyzer.getClassResource(string, classLoader).openStream(), true);
    }

    static byte[] readBytes(InputStream inputStream, boolean bl2) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        if (bl2) {
            inputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static List getFieldNames(Class clazz, Class clazz2) {
        return BytecodeAnalyzer.getFieldNames(BytecodeAnalyzer.getInternalName(clazz), BytecodeAnalyzer.getInternalName(clazz2), Platform.getClassLoader(clazz), new ArrayList());
    }

    public static List getMethodNames(Class clazz, Class clazz2) {
        return BytecodeAnalyzer.getMethodNames(BytecodeAnalyzer.getInternalName(clazz), BytecodeAnalyzer.getInternalName(clazz2), Platform.getClassLoader(clazz), new ArrayList());
    }
}

