/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import org.eclipse.swt.widgets.Composite;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.opengl.swt.GLData$API;
import org.lwjgl.opengl.swt.PlatformGLCanvas;

abstract class AbstractPlatformGLCanvas
implements PlatformGLCanvas {
    AbstractPlatformGLCanvas() {
    }

    protected static boolean atLeast32(int n2, int n3) {
        return n2 == 3 && n3 >= 2 || n2 > 3;
    }

    protected static boolean atLeast30(int n2, int n3) {
        return n2 == 3 && n3 >= 0 || n2 > 3;
    }

    protected static boolean validVersionGL(int n2, int n3) {
        return !((n2 != 0 || n3 != 0) && (n2 < 1 || n3 < 0 || n2 == 1 && n3 > 5 || n2 == 2 && n3 > 1 || n2 == 3 && n3 > 3 || n2 == 4 && n3 > 5));
    }

    protected static boolean validVersionGLES(int n2, int n3) {
        return n2 == 0 && n3 == 0 || n2 >= 1 && n3 >= 0 && (n2 != 1 || n3 <= 1) && (n2 != 2 || n3 <= 0);
    }

    public static void validateAttributes(GLData gLData) {
        if (gLData.alphaSize < 0) {
            throw new IllegalArgumentException("Alpha bits cannot be less than 0");
        }
        if (gLData.redSize < 0) {
            throw new IllegalArgumentException("Red bits cannot be less than 0");
        }
        if (gLData.greenSize < 0) {
            throw new IllegalArgumentException("Green bits cannot be less than 0");
        }
        if (gLData.blueSize < 0) {
            throw new IllegalArgumentException("Blue bits cannot be less than 0");
        }
        if (gLData.stencilSize < 0) {
            throw new IllegalArgumentException("Stencil bits cannot be less than 0");
        }
        if (gLData.depthSize < 0) {
            throw new IllegalArgumentException("Depth bits cannot be less than 0");
        }
        if (gLData.forwardCompatible && !AbstractPlatformGLCanvas.atLeast30(gLData.majorVersion, gLData.minorVersion)) {
            throw new IllegalArgumentException("Forward-compatibility is only defined for OpenGL version 3.0 and above");
        }
        if (gLData.samples < 0) {
            throw new IllegalArgumentException("Invalid samples count");
        }
        if (gLData.profile != null && !AbstractPlatformGLCanvas.atLeast32(gLData.majorVersion, gLData.minorVersion)) {
            throw new IllegalArgumentException("Context profiles are only defined for OpenGL version 3.2 and above");
        }
        if (gLData.api == null) {
            throw new IllegalArgumentException("Unspecified client API");
        }
        if (gLData.api == GLData$API.GL && !AbstractPlatformGLCanvas.validVersionGL(gLData.majorVersion, gLData.minorVersion)) {
            throw new IllegalArgumentException("Invalid OpenGL version");
        }
        if (gLData.api == GLData$API.GLES && !AbstractPlatformGLCanvas.validVersionGLES(gLData.majorVersion, gLData.minorVersion)) {
            throw new IllegalArgumentException("Invalid OpenGL ES version");
        }
        if (!gLData.doubleBuffer && gLData.swapInterval != null) {
            throw new IllegalArgumentException("Swap interval set but not using double buffering");
        }
        if (gLData.colorSamplesNV < 0) {
            throw new IllegalArgumentException("Invalid color samples count");
        }
        if (gLData.colorSamplesNV > gLData.samples) {
            throw new IllegalArgumentException("Color samples greater than number of (coverage) samples");
        }
        if (gLData.swapGroupNV < 0) {
            throw new IllegalArgumentException("Invalid swap group");
        }
        if (gLData.swapBarrierNV < 0) {
            throw new IllegalArgumentException("Invalid swap barrier");
        }
        if (!(gLData.swapGroupNV <= 0 && gLData.swapBarrierNV <= 0 || gLData.doubleBuffer)) {
            throw new IllegalArgumentException("Swap group or barrier requested but not using double buffering");
        }
        if (gLData.swapBarrierNV > 0 && gLData.swapGroupNV == 0) {
            throw new IllegalArgumentException("Swap barrier requested but no valid swap group set");
        }
        if (gLData.loseContextOnReset && !gLData.robustness) {
            throw new IllegalArgumentException("Lose context notification requested but not using robustness");
        }
        if (gLData.contextResetIsolation && !gLData.robustness) {
            throw new IllegalArgumentException("Context reset isolation requested but not using robustness");
        }
    }

    @Override
    public int checkStyle(Composite composite, int n2) {
        return n2;
    }

    @Override
    public void resetStyle(Composite composite) {
    }
}

