/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.Struct$Member;
import org.lwjgl.system.Struct$StructValidation;
import org.lwjgl.system.StructBuffer;

public abstract class Struct
extends Pointer$Default {
    protected static final int DEFAULT_PACK_ALIGNMENT = Platform.get() == Platform.WINDOWS ? 8 : 0x40000000;
    protected static final int DEFAULT_ALIGN_AS = 0;
    protected ByteBuffer container;

    protected Struct(long l2, ByteBuffer byteBuffer) {
        super(l2);
        this.container = byteBuffer;
    }

    protected abstract Struct create(long var1, ByteBuffer var3);

    public abstract int sizeof();

    public void clear() {
        MemoryUtil.memSet(this.address(), 0, this.sizeof());
    }

    public void free() {
        MemoryUtil.nmemFree(this.address());
    }

    public boolean isNull(int n2) {
        if (Checks.DEBUG) {
            this.checkMemberOffset(n2);
        }
        return MemoryUtil.memGetAddress(this.address() + (long)n2) == 0L;
    }

    private void checkMemberOffset(int n2) {
        if (n2 < 0 || this.sizeof() - n2 < POINTER_SIZE) {
            throw new IllegalArgumentException("Invalid member offset.");
        }
    }

    protected static ByteBuffer __checkContainer(ByteBuffer byteBuffer, int n2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, n2);
        }
        return byteBuffer;
    }

    private static long getBytes(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) * (long)n3;
    }

    protected static long __checkMalloc(int n2, int n3) {
        long l2 = ((long)n2 & 0xFFFFFFFFL) * (long)n3;
        if (Checks.DEBUG) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (BITS32 && 0xFFFFFFFFL < l2) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return l2;
    }

    protected static ByteBuffer __create(int n2, int n3) {
        APIUtil.apiCheckAllocation(n2, Struct.getBytes(n2, n3), Integer.MAX_VALUE);
        return ByteBuffer.allocateDirect(n2 * n3).order(ByteOrder.nativeOrder());
    }

    protected static ByteBuffer __getContainer(Struct struct) {
        return struct.container;
    }

    protected static ByteBuffer __getContainer(StructBuffer structBuffer) {
        return structBuffer.container;
    }

    public static void validate(long l2, int n2, int n3, Struct$StructValidation struct$StructValidation) {
        for (int i2 = 0; i2 < n2; ++i2) {
            struct$StructValidation.validate(l2 + Integer.toUnsignedLong(i2) * (long)n3);
        }
    }

    public static void validate(long l2, long l3, int n2, Struct$StructValidation struct$StructValidation) {
        Struct.validate(l2, (int)l3, n2, struct$StructValidation);
    }

    protected static Struct$Member __padding(int n2, boolean bl2) {
        return Struct.__padding(n2, 1, bl2);
    }

    protected static Struct$Member __padding(int n2, int n3, boolean bl2) {
        return Struct.__member(bl2 ? n2 * n3 : 0, n3);
    }

    protected static Struct$Member __member(int n2) {
        return Struct.__member(n2, n2);
    }

    protected static Struct$Member __member(int n2, int n3) {
        return Struct.__member(n2, n3, false);
    }

    protected static Struct$Member __member(int n2, int n3, boolean bl2) {
        return new Struct$Member(n2, n3, bl2);
    }

    protected static Struct$Member __array(int n2, int n3) {
        return Struct.__array(n2, n2, n3);
    }

    protected static Struct$Member __array(int n2, int n3, int n4) {
        return new Struct$Member(n2 * n4, n3, false);
    }

    protected static Struct$Member __array(int n2, int n3, boolean bl2, int n4) {
        return new Struct$Member(n2 * n4, n3, bl2);
    }

    protected static Struct$Layout __union(Struct$Member ... struct$MemberArray) {
        return Struct.__union(DEFAULT_PACK_ALIGNMENT, 0, struct$MemberArray);
    }

    protected static Struct$Layout __union(int n2, int n3, Struct$Member ... struct$MemberArray) {
        ArrayList<Struct$Member> arrayList = new ArrayList<Struct$Member>(struct$MemberArray.length);
        int n4 = 0;
        int n5 = n3;
        for (Struct$Member struct$Member : struct$MemberArray) {
            n4 = Math.max(n4, struct$Member.size);
            n5 = Math.max(n5, struct$Member.getAlignment(n2));
            struct$Member.offset = 0;
            arrayList.add(struct$Member);
            if (!(struct$Member instanceof Struct$Layout)) continue;
            Struct.addNestedMembers(struct$Member, arrayList, 0);
        }
        return new Struct$Layout(n4, n5, n3 != 0, arrayList.toArray(new Struct$Member[0]));
    }

    protected static Struct$Layout __struct(Struct$Member ... struct$MemberArray) {
        return Struct.__struct(DEFAULT_PACK_ALIGNMENT, 0, struct$MemberArray);
    }

    protected static Struct$Layout __struct(int n2, int n3, Struct$Member ... struct$MemberArray) {
        ArrayList<Struct$Member> arrayList = new ArrayList<Struct$Member>(struct$MemberArray.length);
        int n4 = 0;
        int n5 = n3;
        for (Struct$Member struct$Member : struct$MemberArray) {
            int n6 = struct$Member.getAlignment(n2);
            struct$Member.offset = Struct.align(n4, n6);
            n4 = struct$Member.offset + struct$Member.size;
            n5 = Math.max(n5, n6);
            arrayList.add(struct$Member);
            if (!(struct$Member instanceof Struct$Layout)) continue;
            Struct.addNestedMembers(struct$Member, arrayList, struct$Member.offset);
        }
        n4 = Struct.align(n4, n5);
        return new Struct$Layout(n4, n5, n3 != 0, arrayList.toArray(new Struct$Member[0]));
    }

    private static void addNestedMembers(Struct$Member struct$Member, List list2, int n2) {
        Struct$Layout struct$Layout = (Struct$Layout)struct$Member;
        for (Struct$Member struct$Member2 : struct$Layout.members) {
            struct$Member2.offset += n2;
            list2.add(struct$Member2);
        }
    }

    private static int align(int n2, int n3) {
        return (n2 - 1 | n3 - 1) + 1;
    }

    static {
        Library.initialize();
    }
}

