/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XMappingEvent$Buffer;

public class XMappingEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int REQUEST;
    public static final int FIRST_KEYCODE;
    public static final int COUNT;

    protected XMappingEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XMappingEvent create(long l2, ByteBuffer byteBuffer) {
        return new XMappingEvent(l2, byteBuffer);
    }

    public XMappingEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XMappingEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XMappingEvent.ntype(this.address());
    }

    public long serial() {
        return XMappingEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XMappingEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XMappingEvent.ndisplay(this.address());
    }

    public long window() {
        return XMappingEvent.nwindow(this.address());
    }

    public int request() {
        return XMappingEvent.nrequest(this.address());
    }

    public int first_keycode() {
        return XMappingEvent.nfirst_keycode(this.address());
    }

    public int count() {
        return XMappingEvent.ncount(this.address());
    }

    public XMappingEvent type(int n2) {
        XMappingEvent.ntype(this.address(), n2);
        return this;
    }

    public XMappingEvent serial(long l2) {
        XMappingEvent.nserial(this.address(), l2);
        return this;
    }

    public XMappingEvent send_event(boolean bl2) {
        XMappingEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XMappingEvent display(long l2) {
        XMappingEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XMappingEvent window(long l2) {
        XMappingEvent.nwindow(this.address(), l2);
        return this;
    }

    public XMappingEvent request(int n2) {
        XMappingEvent.nrequest(this.address(), n2);
        return this;
    }

    public XMappingEvent first_keycode(int n2) {
        XMappingEvent.nfirst_keycode(this.address(), n2);
        return this;
    }

    public XMappingEvent count(int n2) {
        XMappingEvent.ncount(this.address(), n2);
        return this;
    }

    public XMappingEvent set(int n2, long l2, boolean bl2, long l3, long l4, int n3, int n4, int n5) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.request(n3);
        this.first_keycode(n4);
        this.count(n5);
        return this;
    }

    public XMappingEvent set(XMappingEvent xMappingEvent) {
        MemoryUtil.memCopy(xMappingEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XMappingEvent malloc() {
        return new XMappingEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XMappingEvent calloc() {
        return new XMappingEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XMappingEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XMappingEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XMappingEvent create(long l2) {
        return new XMappingEvent(l2, null);
    }

    public static XMappingEvent createSafe(long l2) {
        return l2 == 0L ? null : new XMappingEvent(l2, null);
    }

    public static XMappingEvent$Buffer malloc(int n2) {
        return new XMappingEvent$Buffer(MemoryUtil.nmemAllocChecked(XMappingEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XMappingEvent$Buffer calloc(int n2) {
        return new XMappingEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XMappingEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XMappingEvent.__create(n2, SIZEOF);
        return new XMappingEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XMappingEvent$Buffer create(long l2, int n2) {
        return new XMappingEvent$Buffer(l2, n2);
    }

    public static XMappingEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XMappingEvent$Buffer(l2, n2);
    }

    public static XMappingEvent mallocStack() {
        return XMappingEvent.malloc(MemoryStack.stackGet());
    }

    public static XMappingEvent callocStack() {
        return XMappingEvent.calloc(MemoryStack.stackGet());
    }

    public static XMappingEvent mallocStack(MemoryStack memoryStack) {
        return XMappingEvent.malloc(memoryStack);
    }

    public static XMappingEvent callocStack(MemoryStack memoryStack) {
        return XMappingEvent.calloc(memoryStack);
    }

    public static XMappingEvent$Buffer mallocStack(int n2) {
        return XMappingEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XMappingEvent$Buffer callocStack(int n2) {
        return XMappingEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XMappingEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XMappingEvent.malloc(n2, memoryStack);
    }

    public static XMappingEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XMappingEvent.calloc(n2, memoryStack);
    }

    public static XMappingEvent malloc(MemoryStack memoryStack) {
        return new XMappingEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XMappingEvent calloc(MemoryStack memoryStack) {
        return new XMappingEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XMappingEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XMappingEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XMappingEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XMappingEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nrequest(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)REQUEST);
    }

    public static int nfirst_keycode(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FIRST_KEYCODE);
    }

    public static int ncount(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)COUNT);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nrequest(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)REQUEST, n2);
    }

    public static void nfirst_keycode(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FIRST_KEYCODE, n2);
    }

    public static void ncount(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)COUNT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XMappingEvent.__struct(XMappingEvent.__member(4), XMappingEvent.__member(CLONG_SIZE), XMappingEvent.__member(4), XMappingEvent.__member(POINTER_SIZE), XMappingEvent.__member(CLONG_SIZE), XMappingEvent.__member(4), XMappingEvent.__member(4), XMappingEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        REQUEST = struct$Layout.offsetof(5);
        FIRST_KEYCODE = struct$Layout.offsetof(6);
        COUNT = struct$Layout.offsetof(7);
    }
}

