/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingCloneBuffers$Buffer;

public class IOURingCloneBuffers
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRC_FD;
    public static final int FLAGS;
    public static final int PAD;

    protected IOURingCloneBuffers(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingCloneBuffers create(long l2, ByteBuffer byteBuffer) {
        return new IOURingCloneBuffers(l2, byteBuffer);
    }

    public IOURingCloneBuffers(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingCloneBuffers.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int src_fd() {
        return IOURingCloneBuffers.nsrc_fd(this.address());
    }

    public int flags() {
        return IOURingCloneBuffers.nflags(this.address());
    }

    public IOURingCloneBuffers src_fd(int n2) {
        IOURingCloneBuffers.nsrc_fd(this.address(), n2);
        return this;
    }

    public IOURingCloneBuffers flags(int n2) {
        IOURingCloneBuffers.nflags(this.address(), n2);
        return this;
    }

    public IOURingCloneBuffers set(int n2, int n3) {
        this.src_fd(n2);
        this.flags(n3);
        return this;
    }

    public IOURingCloneBuffers set(IOURingCloneBuffers iOURingCloneBuffers) {
        MemoryUtil.memCopy(iOURingCloneBuffers.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingCloneBuffers malloc() {
        return new IOURingCloneBuffers(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingCloneBuffers calloc() {
        return new IOURingCloneBuffers(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingCloneBuffers create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingCloneBuffers(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingCloneBuffers create(long l2) {
        return new IOURingCloneBuffers(l2, null);
    }

    public static IOURingCloneBuffers createSafe(long l2) {
        return l2 == 0L ? null : new IOURingCloneBuffers(l2, null);
    }

    public static IOURingCloneBuffers$Buffer malloc(int n2) {
        return new IOURingCloneBuffers$Buffer(MemoryUtil.nmemAllocChecked(IOURingCloneBuffers.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingCloneBuffers$Buffer calloc(int n2) {
        return new IOURingCloneBuffers$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingCloneBuffers$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingCloneBuffers.__create(n2, SIZEOF);
        return new IOURingCloneBuffers$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingCloneBuffers$Buffer create(long l2, int n2) {
        return new IOURingCloneBuffers$Buffer(l2, n2);
    }

    public static IOURingCloneBuffers$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingCloneBuffers$Buffer(l2, n2);
    }

    public static IOURingCloneBuffers malloc(MemoryStack memoryStack) {
        return new IOURingCloneBuffers(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingCloneBuffers calloc(MemoryStack memoryStack) {
        return new IOURingCloneBuffers(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingCloneBuffers$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingCloneBuffers$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingCloneBuffers$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingCloneBuffers$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nsrc_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SRC_FD);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static IntBuffer npad(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)PAD, 6);
    }

    public static int npad(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)PAD + Checks.check(n2, 6) * 4L);
    }

    public static void nsrc_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SRC_FD, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void npad(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)PAD, intBuffer.remaining() * 4);
    }

    public static void npad(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)PAD + Checks.check(n2, 6) * 4L, n3);
    }

    static {
        Struct$Layout struct$Layout = IOURingCloneBuffers.__struct(IOURingCloneBuffers.__member(4), IOURingCloneBuffers.__member(4), IOURingCloneBuffers.__array(4, 6));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        SRC_FD = struct$Layout.offsetof(0);
        FLAGS = struct$Layout.offsetof(1);
        PAD = struct$Layout.offsetof(2);
    }
}

