/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingProbe$Buffer;
import org.lwjgl.system.linux.liburing.IOURingProbeOp;
import org.lwjgl.system.linux.liburing.IOURingProbeOp$Buffer;

public class IOURingProbe
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAST_OP;
    public static final int OPS_LEN;
    public static final int RESV;
    public static final int RESV2;
    public static final int OPS;

    protected IOURingProbe(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingProbe create(long l2, ByteBuffer byteBuffer) {
        return new IOURingProbe(l2, byteBuffer);
    }

    public IOURingProbe(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingProbe.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public byte last_op() {
        return IOURingProbe.nlast_op(this.address());
    }

    public byte ops_len() {
        return IOURingProbe.nops_len(this.address());
    }

    public IOURingProbeOp$Buffer ops() {
        return IOURingProbe.nops(this.address());
    }

    public IOURingProbeOp ops(int n2) {
        return IOURingProbe.nops(this.address(), n2);
    }

    public IOURingProbe last_op(byte by2) {
        IOURingProbe.nlast_op(this.address(), by2);
        return this;
    }

    public IOURingProbe ops_len(byte by2) {
        IOURingProbe.nops_len(this.address(), by2);
        return this;
    }

    public IOURingProbe ops(IOURingProbeOp$Buffer iOURingProbeOp$Buffer) {
        IOURingProbe.nops(this.address(), iOURingProbeOp$Buffer);
        return this;
    }

    public IOURingProbe ops(int n2, IOURingProbeOp iOURingProbeOp) {
        IOURingProbe.nops(this.address(), n2, iOURingProbeOp);
        return this;
    }

    public IOURingProbe ops(Consumer consumer) {
        consumer.accept(this.ops());
        return this;
    }

    public IOURingProbe ops(int n2, Consumer consumer) {
        consumer.accept(this.ops(n2));
        return this;
    }

    public IOURingProbe set(byte by2, byte by3, IOURingProbeOp$Buffer iOURingProbeOp$Buffer) {
        this.last_op(by2);
        this.ops_len(by3);
        this.ops(iOURingProbeOp$Buffer);
        return this;
    }

    public IOURingProbe set(IOURingProbe iOURingProbe) {
        MemoryUtil.memCopy(iOURingProbe.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbe malloc() {
        return new IOURingProbe(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingProbe calloc() {
        return new IOURingProbe(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingProbe create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingProbe(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingProbe create(long l2) {
        return new IOURingProbe(l2, null);
    }

    public static IOURingProbe createSafe(long l2) {
        return l2 == 0L ? null : new IOURingProbe(l2, null);
    }

    public static IOURingProbe$Buffer malloc(int n2) {
        return new IOURingProbe$Buffer(MemoryUtil.nmemAllocChecked(IOURingProbe.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingProbe$Buffer calloc(int n2) {
        return new IOURingProbe$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingProbe$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingProbe.__create(n2, SIZEOF);
        return new IOURingProbe$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingProbe$Buffer create(long l2, int n2) {
        return new IOURingProbe$Buffer(l2, n2);
    }

    public static IOURingProbe$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingProbe$Buffer(l2, n2);
    }

    public static IOURingProbe malloc(MemoryStack memoryStack) {
        return new IOURingProbe(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingProbe calloc(MemoryStack memoryStack) {
        return new IOURingProbe(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingProbe$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbe$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingProbe$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbe$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nlast_op(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)LAST_OP);
    }

    public static byte nops_len(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OPS_LEN);
    }

    public static short nresv(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)RESV);
    }

    public static IntBuffer nresv2(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)RESV2, 3);
    }

    public static int nresv2(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)RESV2 + Checks.check(n2, 3) * 4L);
    }

    public static IOURingProbeOp$Buffer nops(long l2) {
        return IOURingProbeOp.create(l2 + (long)OPS, 0);
    }

    public static IOURingProbeOp nops(long l2, int n2) {
        return IOURingProbeOp.create(l2 + (long)OPS + Checks.check(n2, 0) * (long)IOURingProbeOp.SIZEOF);
    }

    public static void nlast_op(long l2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)LAST_OP, by2);
    }

    public static void nops_len(long l2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)OPS_LEN, by2);
    }

    public static void nresv(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)RESV, s2);
    }

    public static void nresv2(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)RESV2, intBuffer.remaining() * 4);
    }

    public static void nresv2(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)RESV2 + Checks.check(n2, 3) * 4L, n3);
    }

    public static void nops(long l2, IOURingProbeOp$Buffer iOURingProbeOp$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(iOURingProbeOp$Buffer, 0);
        }
        MemoryUtil.memCopy(iOURingProbeOp$Buffer.address(), l2 + (long)OPS, iOURingProbeOp$Buffer.remaining() * IOURingProbeOp.SIZEOF);
    }

    public static void nops(long l2, int n2, IOURingProbeOp iOURingProbeOp) {
        MemoryUtil.memCopy(iOURingProbeOp.address(), l2 + (long)OPS + Checks.check(n2, 0) * (long)IOURingProbeOp.SIZEOF, IOURingProbeOp.SIZEOF);
    }

    static {
        Struct$Layout struct$Layout = IOURingProbe.__struct(IOURingProbe.__member(1), IOURingProbe.__member(1), IOURingProbe.__member(2), IOURingProbe.__array(4, 3), IOURingProbe.__array(IOURingProbeOp.SIZEOF, IOURingProbeOp.ALIGNOF, 0));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        LAST_OP = struct$Layout.offsetof(0);
        OPS_LEN = struct$Layout.offsetof(1);
        RESV = struct$Layout.offsetof(2);
        RESV2 = struct$Layout.offsetof(3);
        OPS = struct$Layout.offsetof(4);
    }
}

