/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifiable;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class Textifier
extends Printer {
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    private int access;
    private int valueNumber = 0;
    static Class class$org$objectweb$asm$util$Textifier = Textifier.class$("org.objectweb.asm.util.Textifier");

    public Textifier() {
        this(327680);
        if (this.getClass() != class$org$objectweb$asm$util$Textifier) {
            throw new IllegalStateException();
        }
    }

    protected Textifier(int n2) {
        super(n2);
    }

    public static void main(String[] stringArray) {
        int n2 = 0;
        int n3 = 2;
        boolean bl2 = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            bl2 = false;
        }
        if (bl2 && "-debug".equals(stringArray[0])) {
            n2 = 1;
            n3 = 0;
            if (stringArray.length != 2) {
                bl2 = false;
            }
        }
        if (!bl2) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: Textifier [-debug] <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[n2].endsWith(".class") || stringArray[n2].indexOf(92) > -1 || stringArray[n2].indexOf(47) > -1 ? new ClassReader(new FileInputStream(stringArray[n2])) : new ClassReader(stringArray[n2]);
        classReader.accept(new TraceClassVisitor(new PrintWriter(System.out)), n3);
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.access = n3;
        int n4 = n2 & 0xFFFF;
        int n5 = n2 >>> 16;
        this.buf.setLength(0);
        this.buf.append("// class version ").append(n4).append('.').append(n5).append(" (").append(n2).append(")\n");
        if ((n3 & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        this.buf.append("// access flags 0x").append(Integer.toHexString(n3).toUpperCase()).append('\n');
        this.appendDescriptor(5, string2);
        if (string2 != null) {
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(n3);
            SignatureReader signatureReader = new SignatureReader(string2);
            signatureReader.accept(traceSignatureVisitor);
            this.buf.append("// declaration: ").append(string).append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.appendAccess(n3 & 0xFFFFFFDF);
        if ((n3 & 0x2000) != 0) {
            this.buf.append("@interface ");
        } else if ((n3 & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((n3 & 0x4000) == 0) {
            this.buf.append("class ");
        }
        this.appendDescriptor(0, string);
        if (string3 != null && !"java/lang/Object".equals(string3)) {
            this.buf.append(" extends ");
            this.appendDescriptor(0, string3);
            this.buf.append(' ');
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" implements ");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.appendDescriptor(0, stringArray[i2]);
                this.buf.append(' ');
            }
        }
        this.buf.append(" {\n\n");
        this.text.add(this.buf.toString());
    }

    @Override
    public void visitSource(String string, String string2) {
        this.buf.setLength(0);
        if (string != null) {
            this.buf.append(this.tab).append("// compiled from: ").append(string).append('\n');
        }
        if (string2 != null) {
            this.buf.append(this.tab).append("// debug info: ").append(string2).append('\n');
        }
        if (this.buf.length() > 0) {
            this.text.add(this.buf.toString());
        }
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string);
        this.buf.append(' ');
        if (string2 != null) {
            this.buf.append(string2).append(' ');
        }
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    @Override
    public Textifier visitClassAnnotation(String string, boolean bl2) {
        this.text.add("\n");
        return this.visitAnnotation(string, bl2);
    }

    @Override
    public Printer visitClassTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.text.add("\n");
        return this.visitTypeAnnotation(n2, typePath, string, bl2);
    }

    @Override
    public void visitClassAttribute(Attribute attribute) {
        this.text.add("\n");
        this.visitAttribute(attribute);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("// access flags 0x");
        this.buf.append(Integer.toHexString(n2 & 0xFFFFFFDF).toUpperCase()).append('\n');
        this.buf.append(this.tab);
        this.appendAccess(n2);
        this.buf.append("INNERCLASS ");
        this.appendDescriptor(0, string);
        this.buf.append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        this.appendDescriptor(0, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    @Override
    public Textifier visitField(int n2, String string, String string2, String string3, Object object) {
        Object object2;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n2 & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags 0x").append(Integer.toHexString(n2).toUpperCase()).append('\n');
        if (string3 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(2, string3);
            object2 = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.acceptType((SignatureVisitor)object2);
            this.buf.append(this.tab).append("// declaration: ").append(((TraceSignatureVisitor)object2).getDeclaration()).append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n2);
        this.appendDescriptor(1, string2);
        this.buf.append(' ').append(string);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append('\"').append(object).append('\"');
            } else {
                this.buf.append(object);
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object2 = this.createTextifier();
        this.text.add(((Printer)object2).getText());
        return object2;
    }

    @Override
    public Textifier visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        Object object;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n2 & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags 0x").append(Integer.toHexString(n2).toUpperCase()).append('\n');
        if (string3 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(4, string3);
            object = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.accept((SignatureVisitor)object);
            String string4 = ((TraceSignatureVisitor)object).getDeclaration();
            String string5 = ((TraceSignatureVisitor)object).getReturnType();
            String string6 = ((TraceSignatureVisitor)object).getExceptions();
            this.buf.append(this.tab).append("// declaration: ").append(string5).append(' ').append(string).append(string4);
            if (string6 != null) {
                this.buf.append(" throws ").append(string6);
            }
            this.buf.append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n2 & 0xFFFFFFBF);
        if ((n2 & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n2 & 0x80) != 0) {
            this.buf.append("varargs ");
        }
        if ((n2 & 0x40) != 0) {
            this.buf.append("bridge ");
        }
        if ((this.access & 0x200) != 0 && (n2 & 0x400) == 0 && (n2 & 8) == 0) {
            this.buf.append("default ");
        }
        this.buf.append(string);
        this.appendDescriptor(3, string2);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.appendDescriptor(0, stringArray[i2]);
                this.buf.append(' ');
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object = this.createTextifier();
        this.text.add(((Printer)object).getText());
        return object;
    }

    @Override
    public void visitClassEnd() {
        this.text.add("}\n");
    }

    @Override
    public void visit(String string, Object object) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.buf.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.appendComa(i2);
                    this.visitByte(byArray[i2]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    this.appendComa(i3);
                    this.visitBoolean(blArray[i3]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    this.appendComa(i4);
                    this.visitShort(sArray[i4]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i5 = 0; i5 < cArray.length; ++i5) {
                    this.appendComa(i5);
                    this.visitChar(cArray[i5]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    this.appendComa(i6);
                    this.visitInt(nArray[i6]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i7 = 0; i7 < lArray.length; ++i7) {
                    this.appendComa(i7);
                    this.visitLong(lArray[i7]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    this.appendComa(i8);
                    this.visitFloat(fArray[i8]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i9 = 0; i9 < dArray.length; ++i9) {
                    this.appendComa(i9);
                    this.visitDouble(dArray[i9]);
                }
            }
            this.buf.append('}');
        }
        this.text.add(this.buf.toString());
    }

    private void visitInt(int n2) {
        this.buf.append(n2);
    }

    private void visitLong(long l2) {
        this.buf.append(l2).append('L');
    }

    private void visitFloat(float f2) {
        this.buf.append(f2).append('F');
    }

    private void visitDouble(double d2) {
        this.buf.append(d2).append('D');
    }

    private void visitChar(char c2) {
        this.buf.append("(char)").append((int)c2);
    }

    private void visitShort(short s2) {
        this.buf.append("(short)").append(s2);
    }

    private void visitByte(byte by2) {
        this.buf.append("(byte)").append(by2);
    }

    private void visitBoolean(boolean bl2) {
        this.buf.append(bl2);
    }

    private void visitString(String string) {
        Textifier.appendString(this.buf, string);
    }

    private void visitType(Type type) {
        this.buf.append(type.getClassName()).append(".class");
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.appendDescriptor(1, string2);
        this.buf.append('.').append(string3);
        this.text.add(this.buf.toString());
    }

    @Override
    public Textifier visitAnnotation(String string, String string2) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, string2);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add(")");
        return textifier;
    }

    @Override
    public Textifier visitArray(String string) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add("}");
        return textifier;
    }

    @Override
    public void visitAnnotationEnd() {
    }

    @Override
    public Textifier visitFieldAnnotation(String string, boolean bl2) {
        return this.visitAnnotation(string, bl2);
    }

    @Override
    public Printer visitFieldTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        return this.visitTypeAnnotation(n2, typePath, string, bl2);
    }

    @Override
    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    @Override
    public void visitFieldEnd() {
    }

    public Textifier visitAnnotation(String string, boolean bl2) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add(bl2 ? ")\n" : ") // invisible\n");
        return textifier;
    }

    public Textifier visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.buf.setLength(0);
        this.buf.append(") : ");
        this.appendTypeReference(n2);
        this.buf.append(", ").append(typePath);
        this.buf.append(bl2 ? "\n" : " // invisible\n");
        this.text.add(this.buf.toString());
        return textifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Textifiable) {
            ((Textifiable)((Object)attribute)).textify(this.buf, null);
        } else {
            this.buf.append(" : unknown\n");
        }
        this.text.add(this.buf.toString());
    }

    protected Textifier createTextifier() {
        return new Textifier();
    }

    protected void appendDescriptor(int n2, String string) {
        if (n2 == 5 || n2 == 2 || n2 == 4) {
            if (string != null) {
                this.buf.append("// signature ").append(string).append('\n');
            }
        } else {
            this.buf.append(string);
        }
    }

    private void appendAccess(int n2) {
        if ((n2 & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n2 & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n2 & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n2 & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n2 & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n2 & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n2 & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n2 & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n2 & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n2 & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
        if ((n2 & 0x1000) != 0) {
            this.buf.append("synthetic ");
        }
        if ((n2 & 0x8000) != 0) {
            this.buf.append("mandated ");
        }
        if ((n2 & 0x4000) != 0) {
            this.buf.append("enum ");
        }
    }

    private void appendComa(int n2) {
        if (n2 != 0) {
            this.buf.append(", ");
        }
    }

    private void appendTypeReference(int n2) {
        TypeReference typeReference = new TypeReference(n2);
        switch (typeReference.getSort()) {
            case 0: {
                this.buf.append("CLASS_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 1: {
                this.buf.append("METHOD_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 16: {
                this.buf.append("CLASS_EXTENDS ").append(typeReference.getSuperTypeIndex());
                break;
            }
            case 17: {
                this.buf.append("CLASS_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 18: {
                this.buf.append("METHOD_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 19: {
                this.buf.append("FIELD");
                break;
            }
            case 20: {
                this.buf.append("METHOD_RETURN");
                break;
            }
            case 21: {
                this.buf.append("METHOD_RECEIVER");
                break;
            }
            case 22: {
                this.buf.append("METHOD_FORMAL_PARAMETER ").append(typeReference.getFormalParameterIndex());
                break;
            }
            case 23: {
                this.buf.append("THROWS ").append(typeReference.getExceptionIndex());
                break;
            }
            case 64: {
                this.buf.append("LOCAL_VARIABLE");
                break;
            }
            case 65: {
                this.buf.append("RESOURCE_VARIABLE");
                break;
            }
            case 66: {
                this.buf.append("EXCEPTION_PARAMETER ").append(typeReference.getTryCatchBlockIndex());
                break;
            }
            case 67: {
                this.buf.append("INSTANCEOF");
                break;
            }
            case 68: {
                this.buf.append("NEW");
                break;
            }
            case 69: {
                this.buf.append("CONSTRUCTOR_REFERENCE");
                break;
            }
            case 70: {
                this.buf.append("METHOD_REFERENCE");
                break;
            }
            case 71: {
                this.buf.append("CAST ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 72: {
                this.buf.append("CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 73: {
                this.buf.append("METHOD_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 74: {
                this.buf.append("CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 75: {
                this.buf.append("METHOD_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = classNotFoundException.getMessage();
            throw new NoClassDefFoundError(string2);
        }
    }
}

