/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import ru.woesss.j2me.micro3d.Action;
import ru.woesss.j2me.micro3d.Action$Animation;
import ru.woesss.j2me.micro3d.Action$Bone;
import ru.woesss.j2me.micro3d.Action$RollAnim;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Model;
import ru.woesss.j2me.micro3d.Model$Polygon;
import ru.woesss.j2me.micro3d.SparseIntArray;
import ru.woesss.j2me.micro3d.TextureData;

class Loader {
    private static final int BMP_FILE_HEADER_SIZE = 14;
    private static final int BMP_VERSION_3 = 40;
    private static final int BMP_VERSION_CORE = 12;
    private static final int[] POOL_NORMALS = new int[]{0, 0, 4096, 0, 0, -4096, 0, 0};
    private static final int[] SIZES = new int[]{8, 10, 13, 16};
    private final byte[] data;
    private final int length;
    private int pos;
    private int cached;
    private int cache;

    private Loader(byte[] byArray, int n2, int n3) {
        this.data = byArray;
        this.length = n3;
        this.pos = n2;
    }

    static Model loadMbacData(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        Loader loader = new Loader(byArray, n2, n3);
        if (loader.readUByte() != 77 || loader.readUByte() != 66) {
            throw new RuntimeException("Not a MBAC file");
        }
        int n16 = loader.readUByte();
        if (loader.readUByte() != 0 || n16 < 2 || n16 > 5) {
            throw new RuntimeException("Unsupported MBAC version: " + n16);
        }
        if (n16 > 3) {
            n15 = loader.readUByte();
            n14 = loader.readUByte();
            n13 = loader.readUByte();
            n12 = loader.readUByte();
        } else {
            n15 = 1;
            n14 = 0;
            n13 = 1;
            n12 = 1;
        }
        if (n12 != 1) {
            throw new RuntimeException("Unexpected bone format: " + n12);
        }
        int n17 = loader.readUShort();
        int n18 = loader.readUShort();
        int n19 = loader.readUShort();
        int n20 = loader.readUShort();
        if (n13 < 3) {
            n11 = 1;
            n10 = 0;
            n9 = 0;
            n8 = 1;
            n7 = 0;
        } else {
            n10 = loader.readUShort();
            n9 = loader.readUShort();
            n11 = loader.readUShort();
            n8 = loader.readUShort();
            n7 = loader.readUShort();
        }
        if (n17 > 21845 || n11 > 16 || n8 > 33 || n7 > 256) {
            throw new RuntimeException(String.format("MBAC format error:\nnumVertices=%d numTextures=%d numPatterns=%d numColors=%d\n", n17, n11, n8, n7));
        }
        Model model = new Model(n17, n20, n8, n11, n18, n19, n10, n9);
        int[][][] nArray = new int[n8][n11 + 1][2];
        if (n16 == 5) {
            for (n6 = 0; n6 < n8; ++n6) {
                int[][] nArray2 = nArray[n6];
                nArray2[0][0] = loader.readUShort();
                nArray2[0][1] = loader.readUShort();
                for (n5 = 1; n5 <= n11; ++n5) {
                    nArray2[n5][0] = loader.readUShort();
                    nArray2[n5][1] = loader.readUShort();
                }
            }
        } else {
            nArray[0] = new int[][]{{n10, n9}, {n18, n19}};
        }
        if (n15 == 1) {
            loader.readVerticesV1(model.originalVertices);
        } else if (n15 == 2) {
            loader.readVerticesV2(model.originalVertices);
        } else {
            throw new RuntimeException("Unexpected vertexFormat: " + n15);
        }
        loader.clearCache();
        model.originalVertices.rewind();
        if (n14 != 0) {
            FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n17 * 3);
            if (n14 == 1) {
                try {
                    loader.readNormalsV1(floatBuffer);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Normals loading error", iOException);
                }
            } else if (n14 == 2) {
                try {
                    loader.readNormalsV2(floatBuffer);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Normals loading error", iOException);
                }
            } else {
                throw new RuntimeException("Unsupported normalFormat: " + n14);
            }
            floatBuffer.rewind();
            model.originalNormals = floatBuffer;
            int n21 = n17 * 3 + 3;
            model.normals = BufferUtils.createFloatBuffer(n21);
            model.normals.put(--n21, 1.0f);
        }
        loader.clearCache();
        if (model.hasPolyC) {
            loader.readPolyC(model, n17, n7, n10);
        }
        if (model.hasPolyT) {
            switch (n13) {
                case 1: {
                    loader.readPolyV1(model, n17, n18);
                    break;
                }
                case 2: {
                    loader.readPolyV2(model, n17, n18);
                    break;
                }
                case 3: {
                    loader.readPolyV3(model, n17, n18);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected polygonFormat: " + n13);
                }
            }
        }
        loader.clearCache();
        n6 = 0;
        int n22 = n10;
        n5 = 0;
        int n23 = n18;
        Model$Polygon[] model$PolygonArray = model.polygonsC;
        Model$Polygon[] model$PolygonArray2 = model.polygonsT;
        for (n4 = 0; n4 < n8; ++n4) {
            int n24;
            int[][] nArray3 = nArray[n4];
            int[] nArray4 = nArray3[0];
            int n25 = nArray4[0];
            int n26 = n4 == 0 ? 0 : 1 << n4;
            for (n24 = 0; n24 < n25; ++n24) {
                model$PolygonArray[n6++].pattern = n26;
            }
            n25 = nArray4[1];
            for (n24 = 0; n24 < n25; ++n24) {
                model$PolygonArray[n22++].pattern = n26;
            }
            for (n24 = 0; n24 < n11; ++n24) {
                Model$Polygon model$Polygon;
                int n27;
                nArray4 = nArray3[n24 + 1];
                n25 = nArray4[0];
                for (n27 = 0; n27 < n25; ++n27) {
                    model$Polygon = model$PolygonArray2[n5++];
                    model$Polygon.pattern = n26;
                    model$Polygon.face = n24;
                }
                n25 = nArray4[1];
                for (n27 = 0; n27 < n25; ++n27) {
                    model$Polygon = model$PolygonArray2[n23++];
                    model$Polygon.pattern = n26;
                    model$Polygon.face = n24;
                }
            }
        }
        n4 = loader.readBones(n20, model);
        if (n4 != n17) {
            throw new RuntimeException("Bones vertices = " + n4 + ", but all vertices = " + n17);
        }
        int n28 = loader.available();
        if (n16 >= 4) {
            n28 -= 20;
        }
        if (n28 > 0) {
            System.out.println("Uninterpreted bytes in MBAC (" + n28 + ", v=" + n16);
        }
        return model;
    }

    static Action[] loadMtraData(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        Loader loader = new Loader(byArray, n2, n3);
        if (loader.readUByte() != 77 || loader.readUByte() != 84) {
            throw new RuntimeException("Not a MTRA file");
        }
        int n6 = loader.readUByte();
        if (loader.readUByte() != 0 || n6 < 2 || n6 > 5) {
            throw new RuntimeException("Unsupported version: " + n6);
        }
        int n7 = loader.readUShort();
        int n8 = loader.readUShort();
        Action[] actionArray = new Action[n7];
        int[] nArray = new int[8];
        for (n5 = 0; n5 < 8; ++n5) {
            nArray[n5] = loader.readUShort();
        }
        if (nArray[7] != 0) {
            System.out.println("ActTableData: transTypeCounts[7] = " + nArray[7]);
        }
        n5 = loader.readInt();
        for (n4 = 0; n4 < n7; ++n4) {
            SparseIntArray sparseIntArray;
            int n9;
            Action action;
            int n10 = loader.readUShort();
            actionArray[n4] = action = new Action(n10, n8);
            for (n9 = 0; n9 < n8; ++n9) {
                action.boneActions[n9] = loader.readBoneAction(action, n9 * 12);
            }
            if (n6 < 5) continue;
            n9 = loader.readUShort();
            actionArray[n4].dynamic = sparseIntArray = new SparseIntArray(n9);
            for (int i2 = 0; i2 < n9; ++i2) {
                int n11 = loader.readUShort();
                int n12 = loader.readInt();
                sparseIntArray.put(n11, n12);
            }
        }
        n4 = loader.available();
        if (n6 >= 4) {
            n4 -= 20;
        }
        if (n4 > 0) {
            System.out.println("ActTableData: uninterpreted bytes in MTRA");
        }
        return actionArray;
    }

    static TextureData loadBmpData(byte[] byArray, int n2, int n3) {
        int n4;
        boolean bl2;
        int n5;
        int n6;
        int n7;
        int n8;
        Loader loader = new Loader(byArray, n2, n3);
        if (loader.readUByte() != 66 || loader.readUByte() != 77) {
            throw new RuntimeException("Not a BMP!");
        }
        loader.skip(8);
        int n9 = loader.readInt();
        int n10 = loader.readInt();
        if (n10 == 12) {
            n8 = loader.readUShort();
            n7 = loader.readUShort();
            loader.skip(2);
            n6 = loader.readUShort();
            if (n6 != 8) {
                throw new RuntimeException("Unsupported BMP format: bpp = " + n6);
            }
            n5 = 256;
            bl2 = true;
        } else if (n10 == 40) {
            n8 = loader.readInt();
            n6 = loader.readInt();
            if (n6 < 0) {
                n7 = -n6;
                bl2 = false;
            } else {
                n7 = n6;
                bl2 = true;
            }
            loader.skip(2);
            int n11 = loader.readUShort();
            if (n11 != 8) {
                throw new RuntimeException("Unsupported BMP format: bpp = " + n11);
            }
            int n12 = loader.readInt();
            if (n12 != 0) {
                throw new RuntimeException("Unsupported BMP format: compression = " + n12);
            }
            loader.skip(12);
            n5 = loader.readInt();
            if (n5 == 0) {
                n5 = 256;
            }
            loader.skip(4);
        } else {
            throw new RuntimeException("Unsupported BMP version = " + n10);
        }
        n6 = 14 + n10;
        if (n9 < n6 + n5 * 4) {
            n9 = n6 + n5 * 4;
        }
        TextureData textureData = new TextureData(n8, n7);
        ByteBuffer byteBuffer = textureData.getRaster();
        int n13 = n8 % 4;
        int n14 = n4 = n13 == 0 ? n8 : n8 + 4 - n13;
        if (bl2) {
            for (int i2 = n7 - 1; i2 >= 0; --i2) {
                int n15;
                int n16 = n15 + n8;
                for (n15 = n9 + i2 * n4; n15 < n16; ++n15) {
                    byte by2 = byArray[n15];
                    int n17 = (by2 & 0xFF) * 4 + n6;
                    byte by3 = byArray[n17++];
                    byte by4 = byArray[n17++];
                    byte by5 = byArray[n17];
                    byteBuffer.put(by5).put(by4).put(by3).put((byte)(by2 == 0 ? 0 : 255));
                }
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                int n18;
                int n19 = n18 + n8;
                for (n18 = n9 + i3 * n4; n18 < n19; ++n18) {
                    byte by6 = byArray[n18];
                    int n20 = (by6 & 0xFF) * 4 + n6;
                    byte by7 = byArray[n20++];
                    byte by8 = byArray[n20++];
                    byte by9 = byArray[n20];
                    byteBuffer.put(by9).put(by8).put(by7).put((byte)(by6 == 0 ? 0 : 255));
                }
            }
        }
        return textureData;
    }

    private void readVerticesV1(FloatBuffer floatBuffer) {
        while (floatBuffer.hasRemaining()) {
            floatBuffer.put(this.readShort());
        }
    }

    private void readVerticesV2(FloatBuffer floatBuffer) {
        while (floatBuffer.hasRemaining()) {
            int n2 = this.readUBits(8);
            int n3 = n2 >> 6;
            int n4 = SIZES[n3];
            int n5 = (n2 & 0x3F) + 1;
            if (n5 > floatBuffer.remaining()) {
                throw new IOException("Vertex data largest numVertices param");
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                floatBuffer.put(this.readBits(n4));
                floatBuffer.put(this.readBits(n4));
                floatBuffer.put(this.readBits(n4));
            }
        }
    }

    private void readNormalsV1(FloatBuffer floatBuffer) {
        while (floatBuffer.hasRemaining()) {
            floatBuffer.put(this.readShort());
        }
    }

    private void readNormalsV2(FloatBuffer floatBuffer) {
        int n2 = floatBuffer.capacity() / 3;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            int n5;
            int n6 = this.readUBits(7);
            if (n6 == 64) {
                n5 = this.readUBits(3);
                if (n5 > 5) {
                    throw new RuntimeException("Normal read error");
                }
                n4 = POOL_NORMALS[n5++];
                n3 = POOL_NORMALS[n5++];
                n6 = POOL_NORMALS[n5];
            } else {
                n6 = n6 << 25 >> 19;
                n3 = this.readUBits(7) << 25 >> 19;
                n5 = this.readUBits(1);
                int n7 = 0x1000000 - n6 * n6 - n3 * n3;
                int n8 = n4 = n7 > 0 ? (int)Math.round(Math.sqrt(n7)) : 0;
                if (n5 == 1) {
                    n4 = -n4;
                }
            }
            floatBuffer.put(n6);
            floatBuffer.put(n3);
            floatBuffer.put(n4);
        }
    }

    private void readPolyC(Model model, int n2, int n3, int n4) {
        Object object;
        byte by2;
        byte by3;
        byte by4;
        byte by5;
        byte by6;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.readUByte();
        int n12 = this.readUByte();
        int n13 = this.readUByte();
        int n14 = this.readUByte();
        int n15 = this.readUByte();
        if (n15 != 0) {
            System.out.println("PolyC unknownByte = " + n15);
        }
        byte[] byArray = new byte[n3 * 3];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)this.readUBits(n13);
        }
        Model$Polygon[] model$PolygonArray = model.polygonsC;
        for (n10 = 0; n10 < n4; ++n10) {
            n9 = this.readUBits(n11) << 1;
            if ((n9 & 0xFC09) != 0) {
                throw new RuntimeException("Unexpected material: " + n9);
            }
            n8 = this.readUBits(n12);
            n7 = this.readUBits(n12);
            n6 = this.readUBits(n12);
            if (n8 >= n2 || n7 >= n2 || n6 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            n5 = this.readUBits(n14) * 3;
            by6 = byArray[n5++];
            by5 = byArray[n5++];
            by4 = byArray[n5];
            by3 = (byte)((n9 & 0x20) >> 5);
            by2 = (byte)((n9 & 0x40) >> 6);
            byte[] byArray2 = new byte[]{by6, by5, by4, by3, by2, by6, by5, by4, by3, by2, by6, by5, by4, by3, by2};
            object = new Model$Polygon(n9, byArray2, n8, n7, n6);
            model$PolygonArray[n10] = object;
        }
        for (n10 = n4; n10 < model$PolygonArray.length; ++n10) {
            Model$Polygon model$Polygon;
            n9 = this.readUBits(n11) << 1;
            if ((n9 & 0xFC09) != 0) {
                throw new RuntimeException("Unexpected material: " + n9);
            }
            n8 = this.readUBits(n12);
            n7 = this.readUBits(n12);
            n6 = this.readUBits(n12);
            n5 = this.readUBits(n12);
            if (n8 >= n2 || n7 >= n2 || n6 >= n2 || n5 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            by6 = this.readUBits(n14) * 3;
            by5 = byArray[by6++];
            by4 = byArray[by6++];
            by3 = byArray[by6];
            by2 = (byte)((n9 & 0x20) >> 5);
            byte by7 = (byte)((n9 & 0x40) >> 6);
            object = new byte[]{by5, by4, by3, by2, by7, by5, by4, by3, by2, by7, by5, by4, by3, by2, by7, by5, by4, by3, by2, by7, by5, by4, by3, by2, by7, by5, by4, by3, by2, by7};
            model$PolygonArray[n10] = model$Polygon = new Model$Polygon(n9, (byte[])object, n8, n7, n6, n6, n7, n5);
        }
    }

    private void readPolyV1(Model model, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Model$Polygon[] model$PolygonArray = model.polygonsT;
        for (n9 = 0; n9 < n3; ++n9) {
            n8 = this.readUShort();
            if ((n8 & 0xFFF9) != 0) {
                throw new IOException("Unexpected material: " + n8);
            }
            n7 = this.readUShort();
            n6 = this.readUShort();
            n5 = this.readUShort();
            if (n7 >= n2 || n6 >= n2 || n5 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            n4 = (n8 & 4) << 2 | (n8 & 2) >> 1;
            byte by2 = (byte)(n4 & 1);
            byte[] by3 = new byte[]{this.readByte(), this.readByte(), 1, 0, by2, this.readByte(), this.readByte(), 1, 0, by2, this.readByte(), this.readByte(), 1, 0, by2};
            model$PolygonArray[n9] = new Model$Polygon(n4, by3, n7, n6, n5);
        }
        n8 = model$PolygonArray.length;
        for (n9 = n3; n9 < n8; ++n9) {
            n7 = this.readUShort();
            if ((n7 & 0xFFF8) != 0 || (n7 & 1) == 0) {
                throw new IOException("Unexpected material: " + n7);
            }
            n6 = this.readUShort();
            n5 = this.readUShort();
            n4 = this.readUShort();
            int n10 = this.readUShort();
            if (n6 >= n2 || n5 >= n2 || n4 >= n2 || n10 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            byte by2 = this.readByte();
            byte by3 = this.readByte();
            byte by4 = this.readByte();
            byte by5 = this.readByte();
            byte by6 = this.readByte();
            byte by7 = this.readByte();
            byte by8 = this.readByte();
            byte by9 = this.readByte();
            int n11 = (n7 & 4) << 2 | (n7 & 2) >> 1;
            byte by10 = (byte)(n11 & 1);
            byte[] byArray = new byte[]{by2, by3, 1, 0, by10, by4, by5, 1, 0, by10, by6, by7, 1, 0, by10, by6, by7, 1, 0, by10, by4, by5, 1, 0, by10, by8, by9, 1, 0, by10};
            model$PolygonArray[n9] = new Model$Polygon(n11, byArray, n6, n5, n4, n4, n5, n10);
        }
    }

    private void readPolyV2(Model model, int n2, int n3) {
        byte by2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.readUByte();
        int n10 = this.readUByte();
        Model$Polygon[] model$PolygonArray = model.polygonsT;
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = this.readUBits(n9);
            if ((n7 & 0xFF88) != 0) {
                throw new IOException("Unexpected material: " + n7);
            }
            n6 = this.readUBits(n10);
            n5 = this.readUBits(n10);
            n4 = this.readUBits(n10);
            if (n6 >= n2 || n5 >= n2 || n4 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            byte by4 = (byte)(n7 & 1);
            byte by3 = (byte)((n7 & 0x20) >> 5);
            by2 = (byte)((n7 & 0x40) >> 6);
            byte[] byArray = new byte[]{(byte)this.readUBits(7), (byte)this.readUBits(7), by3, by2, by4, (byte)this.readUBits(7), (byte)this.readUBits(7), by3, by2, by4, (byte)this.readUBits(7), (byte)this.readUBits(7), by3, by2, by4};
            model$PolygonArray[n8] = new Model$Polygon(n7, byArray, n6, n5, n4);
        }
        n7 = model$PolygonArray.length;
        for (n8 = n3; n8 < n7; ++n8) {
            n6 = this.readUBits(n9);
            if ((n6 & 0xFF88) != 0) {
                throw new RuntimeException("Unexpected material: " + n6);
            }
            n5 = this.readUBits(n10);
            n4 = this.readUBits(n10);
            int n11 = this.readUBits(n10);
            int n12 = this.readUBits(n10);
            if (n5 >= n2 || n4 >= n2 || n11 >= n2 || n12 >= n2) {
                throw new RuntimeException("Format error: indices greatest or equal num vertices");
            }
            by2 = (byte)this.readUBits(7);
            byte by4 = (byte)this.readUBits(7);
            byte by5 = (byte)this.readUBits(7);
            byte by6 = (byte)this.readUBits(7);
            byte by7 = (byte)this.readUBits(7);
            byte by8 = (byte)this.readUBits(7);
            byte by9 = (byte)this.readUBits(7);
            byte by10 = (byte)this.readUBits(7);
            byte by11 = (byte)(n6 & 1);
            byte by12 = (byte)((n6 & 0x20) >> 5);
            byte by13 = (byte)((n6 & 0x40) >> 6);
            byte[] byArray = new byte[]{by2, by4, by12, by13, by11, by5, by6, by12, by13, by11, by7, by8, by12, by13, by11, by7, by8, by12, by13, by11, by5, by6, by12, by13, by11, by9, by10, by12, by13, by11};
            model$PolygonArray[n8] = new Model$Polygon(n6, byArray, n5, n4, n11, n11, n4, n12);
        }
    }

    private void readPolyV3(Model model, int n2, int n3) {
        byte by2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.readUBits(8);
        int n10 = this.readUBits(8);
        int n11 = this.readUBits(8);
        int n12 = this.readUBits(8);
        if (n12 != 0) {
            System.out.println("PolyT v3: unknownByte = " + n12);
        }
        Model$Polygon[] model$PolygonArray = model.polygonsT;
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = this.readUBits(n9);
            if ((n7 & 0xFC08) != 0) {
                throw new IOException("Unexpected material: " + n7);
            }
            n6 = this.readUBits(n10);
            n5 = this.readUBits(n10);
            n4 = this.readUBits(n10);
            if (n6 >= n2 || n5 >= n2 || n4 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            byte by4 = (byte)(n7 & 1);
            byte by3 = (byte)((n7 & 0x20) >> 5);
            by2 = (byte)((n7 & 0x40) >> 6);
            byte[] byArray = new byte[]{(byte)this.readUBits(n11), (byte)this.readUBits(n11), by3, by2, by4, (byte)this.readUBits(n11), (byte)this.readUBits(n11), by3, by2, by4, (byte)this.readUBits(n11), (byte)this.readUBits(n11), by3, by2, by4};
            model$PolygonArray[n8] = new Model$Polygon(n7, byArray, n6, n5, n4);
        }
        n7 = model$PolygonArray.length;
        for (n8 = n3; n8 < n7; ++n8) {
            n6 = this.readUBits(n9);
            if ((n6 & 0xFC08) != 0) {
                throw new IOException("Unexpected material: " + n6);
            }
            n5 = this.readUBits(n10);
            n4 = this.readUBits(n10);
            int n13 = this.readUBits(n10);
            int n14 = this.readUBits(n10);
            if (n5 >= n2 || n4 >= n2 || n13 >= n2 || n14 >= n2) {
                throw new IOException("Format error: indices greatest or equal num vertices");
            }
            by2 = (byte)this.readUBits(n11);
            byte by4 = (byte)this.readUBits(n11);
            byte by5 = (byte)this.readUBits(n11);
            byte by6 = (byte)this.readUBits(n11);
            byte by7 = (byte)this.readUBits(n11);
            byte by8 = (byte)this.readUBits(n11);
            byte by9 = (byte)this.readUBits(n11);
            byte by10 = (byte)this.readUBits(n11);
            byte by11 = (byte)(n6 & 1);
            byte by12 = (byte)((n6 & 0x20) >> 5);
            byte by13 = (byte)((n6 & 0x40) >> 6);
            byte[] byArray = new byte[]{by2, by4, by12, by13, by11, by5, by6, by12, by13, by11, by7, by8, by12, by13, by11, by7, by8, by12, by13, by11, by5, by6, by12, by13, by11, by9, by10, by12, by13, by11};
            model$PolygonArray[n8] = new Model$Polygon(n6, byArray, n5, n4, n13, n13, n4, n14);
        }
    }

    private int readBones(int n2, Model model) {
        ByteBuffer byteBuffer = model.bones;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.readUShort();
            short s2 = this.readShort();
            if (s2 < -1) {
                throw new RuntimeException("Format error (negative parent). Please report this bug");
            }
            byteBuffer.putInt(n4);
            byteBuffer.putInt(s2);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat(this.readShort());
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat(this.readShort());
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat((float)this.readShort() * 2.4414062E-4f);
            byteBuffer.putFloat(this.readShort());
            n3 += n4;
        }
        byteBuffer.rewind();
        return n3;
    }

    private Action$Bone readBoneAction(Action action, int n2) {
        int n3 = this.readUByte();
        Action$Bone action$Bone = new Action$Bone(n3, n2, action.matrices);
        switch (n3) {
            case 0: {
                float[] fArray = action.matrices;
                fArray[n2] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 1] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 2] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 3] = this.readShort();
                fArray[n2 + 4] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 5] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 6] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 7] = this.readShort();
                fArray[n2 + 8] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 9] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 10] = (float)this.readShort() * 2.4414062E-4f;
                fArray[n2 + 11] = this.readShort();
                break;
            }
            case 1: {
                System.arraycopy(MathUtil.IDENTITY_AFFINE, 0, action.matrices, n2, 12);
                break;
            }
            case 2: {
                float f2;
                int n4;
                int n5;
                int n6 = this.readUShort();
                Action$Animation action$Animation = new Action$Animation(n6);
                for (int i2 = 0; i2 < n6; ++i2) {
                    n5 = this.readUShort();
                    n4 = this.readShort();
                    short s2 = this.readShort();
                    short s3 = this.readShort();
                    action$Animation.set(i2, n5, n4, s2, s3);
                }
                action$Bone.translate = action$Animation;
                n6 = this.readUShort();
                Action$Animation action$Animation2 = new Action$Animation(n6);
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = this.readUShort();
                    float f3 = (float)this.readShort() * 2.4414062E-4f;
                    float f4 = (float)this.readShort() * 2.4414062E-4f;
                    f2 = (float)this.readShort() * 2.4414062E-4f;
                    action$Animation2.set(n5, n4, f3, f4, f2);
                }
                action$Bone.scale = action$Animation2;
                n6 = this.readUShort();
                Action$Animation action$Animation3 = new Action$Animation(n6);
                for (n4 = 0; n4 < n6; ++n4) {
                    int n7 = this.readUShort();
                    float f5 = this.readShort();
                    f2 = this.readShort();
                    float f6 = this.readShort();
                    action$Animation3.set(n4, n7, f5, f2, f6);
                }
                action$Bone.rotate = action$Animation3;
                n6 = this.readUShort();
                Action$RollAnim action$RollAnim = new Action$RollAnim(n6);
                for (int i3 = 0; i3 < n6; ++i3) {
                    int n8 = this.readUShort();
                    f2 = (float)this.readShort() * 0.0015339808f;
                    action$RollAnim.set(i3, n8, f2);
                }
                action$Bone.roll = action$RollAnim;
                break;
            }
            case 3: {
                Action$Animation action$Animation = new Action$Animation(1);
                short s4 = this.readShort();
                short s5 = this.readShort();
                short s6 = this.readShort();
                action$Animation.set(0, 0, s4, s5, s6);
                action$Bone.translate = action$Animation;
                int n9 = this.readUShort();
                Action$Animation action$Animation4 = new Action$Animation(n9);
                for (int i4 = 0; i4 < n9; ++i4) {
                    int n10 = this.readUShort();
                    float f7 = this.readShort();
                    float f8 = this.readShort();
                    float f9 = this.readShort();
                    action$Animation4.set(i4, n10, f7, f8, f9);
                }
                action$Bone.rotate = action$Animation4;
                float f10 = (float)this.readShort() * 0.0015339808f;
                Action$RollAnim action$RollAnim = new Action$RollAnim(1);
                action$RollAnim.set(0, 0, f10);
                action$Bone.roll = action$RollAnim;
                break;
            }
            case 4: {
                float f11;
                int n11;
                int n12 = this.readUShort();
                Action$Animation action$Animation = new Action$Animation(n12);
                for (int i5 = 0; i5 < n12; ++i5) {
                    n11 = this.readUShort();
                    float f12 = this.readShort();
                    f11 = this.readShort();
                    float f13 = this.readShort();
                    action$Animation.set(i5, n11, f12, f11, f13);
                }
                action$Bone.rotate = action$Animation;
                n12 = this.readUShort();
                Action$RollAnim action$RollAnim = new Action$RollAnim(n12);
                for (n11 = 0; n11 < n12; ++n11) {
                    int n13 = this.readUShort();
                    f11 = (float)this.readShort() * 0.0015339808f;
                    action$RollAnim.set(n11, n13, f11);
                }
                action$Bone.roll = action$RollAnim;
                break;
            }
            case 5: {
                int n14 = this.readUShort();
                Action$Animation action$Animation = new Action$Animation(n14);
                for (int i6 = 0; i6 < n14; ++i6) {
                    int n15 = this.readUShort();
                    float f14 = this.readShort();
                    float f15 = this.readShort();
                    float f16 = this.readShort();
                    action$Animation.set(i6, n15, f14, f15, f16);
                }
                action$Bone.rotate = action$Animation;
                break;
            }
            case 6: {
                int n16;
                int n17;
                int n18 = this.readUShort();
                Action$Animation action$Animation = new Action$Animation(n18);
                for (int i7 = 0; i7 < n18; ++i7) {
                    n17 = this.readUShort();
                    n16 = this.readShort();
                    short s7 = this.readShort();
                    short s8 = this.readShort();
                    action$Animation.set(i7, n17, n16, s7, s8);
                }
                action$Bone.translate = action$Animation;
                n18 = this.readUShort();
                Action$Animation action$Animation5 = new Action$Animation(n18);
                for (n17 = 0; n17 < n18; ++n17) {
                    n16 = this.readUShort();
                    float f17 = this.readShort();
                    float f18 = this.readShort();
                    float f19 = this.readShort();
                    action$Animation5.set(n17, n16, f17, f18, f19);
                }
                action$Bone.rotate = action$Animation5;
                n18 = this.readUShort();
                Action$RollAnim action$RollAnim = new Action$RollAnim(n18);
                for (n16 = 0; n16 < n18; ++n16) {
                    int n19 = this.readUShort();
                    float f20 = (float)this.readShort() * 0.0015339808f;
                    action$RollAnim.set(n16, n19, f20);
                }
                action$Bone.roll = action$RollAnim;
                break;
            }
            default: {
                throw new RuntimeException("Animation type " + n3 + " is not supported");
            }
        }
        return action$Bone;
    }

    private byte readByte() {
        if (this.pos >= this.length) {
            throw new EOFException();
        }
        return this.data[this.pos++];
    }

    private int readUByte() {
        if (this.pos >= this.length) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF;
    }

    private short readShort() {
        if (this.pos + 2 > this.length) {
            throw new EOFException();
        }
        return (short)(this.data[this.pos++] & 0xFF | this.data[this.pos++] << 8);
    }

    private int readUShort() {
        if (this.pos + 2 > this.length) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF | (this.data[this.pos++] & 0xFF) << 8;
    }

    private int readInt() {
        if (this.pos + 4 > this.length) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF | (this.data[this.pos++] & 0xFF) << 8 | (this.data[this.pos++] & 0xFF) << 16 | this.data[this.pos++] << 24;
    }

    private int available() {
        return this.length - this.pos;
    }

    private int readUBits(int n2) {
        if (n2 > 25) {
            System.out.println("readUBits(size=" + n2 + ')');
            throw new IllegalArgumentException("Invalid bit size=" + n2);
        }
        while (n2 > this.cached) {
            this.cache |= this.readUByte() << this.cached;
            this.cached += 8;
        }
        int n3 = ~(-1 << n2);
        int n4 = this.cache & n3;
        this.cached -= n2;
        this.cache >>>= n2;
        return n4;
    }

    private int readBits(int n2) {
        int n3 = 32 - n2;
        return this.readUBits(n2) << n3 >> n3;
    }

    private void clearCache() {
        this.cache = 0;
        this.cached = 0;
    }

    private void skip(int n2) {
        if (this.pos + n2 > this.length) {
            throw new EOFException();
        }
        this.pos += n2;
    }
}

