/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import java.nio.IntBuffer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLX13;
import org.lwjgl.opengl.GLXARBCreateContext;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.opengl.GLXNVDelayBeforeSwap;
import org.lwjgl.opengl.swt.AbstractPlatformGLCanvas;
import org.lwjgl.opengl.swt.GLCanvas;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.system.linux.XVisualInfo;

class PlatformLinuxGLCanvas
extends AbstractPlatformGLCanvas {
    PlatformLinuxGLCanvas() {
    }

    public long create(GLCanvas canvas, GLData data, GLData effective) {
        PlatformLinuxGLCanvas.validateAttributes((GLData)data);
        GTK.gtk_widget_realize((long)canvas.handle);
        long window = GTK3.gtk_widget_get_window((long)canvas.handle);
        long xDisplay = this.gdk_x11_display_get_xdisplay(window);
        IntBuffer attribList = BufferUtils.createIntBuffer((int)64);
        this.populateFBConfigAttribs(data, attribList);
        PointerBuffer fbCfg = GLX13.glXChooseFBConfig((long)xDisplay, (int)0, (IntBuffer)attribList);
        if (fbCfg == null || !fbCfg.hasRemaining()) {
            canvas.dispose();
            throw new SWTException("Unable to find matching FB Config");
        }
        XVisualInfo viz = GLX13.glXGetVisualFromFBConfig((long)xDisplay, (long)fbCfg.get(0));
        long screen = GDK.gdk_screen_get_default();
        long gdkvisual = GDK.gdk_x11_screen_lookup_visual((long)screen, (int)((int)viz.visualid()));
        GdkWindowAttr winAttrs = new GdkWindowAttr();
        winAttrs.width = 1;
        winAttrs.height = 1;
        winAttrs.event_mask = 32526;
        winAttrs.window_type = 2;
        winAttrs.visual = gdkvisual;
        canvas.glWindow = GDK.gdk_window_new((long)window, (GdkWindowAttr)winAttrs, (int)32);
        GDK.gdk_window_set_user_data((long)canvas.glWindow, (long)canvas.handle);
        canvas.xWindow = GDK.gdk_x11_window_get_xid((long)canvas.glWindow);
        GDK.gdk_window_show((long)canvas.glWindow);
        attribList.rewind();
        GLXCapabilities caps = GL.getCapabilitiesGLX();
        this.populateContextAttribs(data, attribList, caps);
        long share = data.shareContext != null ? data.shareContext.context : 0L;
        long context = GLXARBCreateContext.glXCreateContextAttribsARB((long)xDisplay, (long)fbCfg.get(0), (long)share, (boolean)true, (IntBuffer)attribList);
        if (context == 0L) {
            throw new SWTException("Unable to create context");
        }
        Listener listener = event -> {
            switch (event.type) {
                case 11: {
                    Rectangle clientArea = DPIUtil.autoScaleUp((Rectangle)canvas.getClientArea());
                    GDK.gdk_window_move((long)canvas.glWindow, (int)clientArea.x, (int)clientArea.y);
                    GDK.gdk_window_resize((long)canvas.glWindow, (int)clientArea.width, (int)clientArea.height);
                    break;
                }
                case 12: {
                    this.deleteContext(canvas, context);
                }
            }
        };
        canvas.addListener(11, listener);
        canvas.addListener(12, listener);
        return context;
    }

    private void populateFBConfigAttribs(GLData data, IntBuffer attribList) {
        if (data.redSize > 0) {
            attribList.put(8).put(data.redSize);
        }
        if (data.greenSize > 0) {
            attribList.put(9).put(data.greenSize);
        }
        if (data.blueSize > 0) {
            attribList.put(10).put(data.blueSize);
        }
        if (data.alphaSize > 0) {
            attribList.put(11).put(data.alphaSize);
        }
        if (data.depthSize > 0) {
            attribList.put(12).put(data.depthSize);
        }
        if (data.stencilSize > 0) {
            attribList.put(13).put(data.stencilSize);
        }
        if (data.doubleBuffer) {
            attribList.put(5).put(1);
        }
        if (data.stereo) {
            attribList.put(6).put(1);
        }
        if (data.sRGB) {
            attribList.put(8370).put(1);
        }
        if (data.accumRedSize > 0) {
            attribList.put(14).put(data.accumRedSize);
        }
        if (data.accumGreenSize > 0) {
            attribList.put(15).put(data.accumGreenSize);
        }
        if (data.accumBlueSize > 0) {
            attribList.put(16).put(data.accumBlueSize);
        }
        if (data.accumAlphaSize > 0) {
            attribList.put(17).put(data.accumAlphaSize);
        }
        if (data.samples > 0) {
            attribList.put(100000).put(1);
            attribList.put(100001).put(data.samples);
            if (data.colorSamplesNV > 0) {
                attribList.put(8371).put(data.colorSamplesNV);
            }
        }
        attribList.put(0);
        attribList.flip();
    }

    private void populateContextAttribs(GLData data, IntBuffer attribList, GLXCapabilities caps) {
        attribList.put(8337).put(data.majorVersion);
        attribList.put(8338).put(data.minorVersion);
        int profile = 0;
        if (data.api == GLData.API.GL) {
            if (data.profile == GLData.Profile.COMPATIBILITY) {
                profile = 2;
            } else if (data.profile == GLData.Profile.CORE) {
                profile = 1;
            }
        } else if (data.api == GLData.API.GLES) {
            if (!caps.GLX_EXT_create_context_es2_profile) {
                throw new SWTException("OpenGL ES API requested but GLX_EXT_create_context_es2_profile is unavailable");
            }
            profile = 4;
        }
        if (profile > 0) {
            if (!caps.GLX_ARB_create_context_profile) {
                throw new SWTException("OpenGL profile requested but GLX_ARB_create_context_profile is unavailable");
            }
            attribList.put(37158).put(profile);
        }
        int contextFlags = 0;
        if (data.debug) {
            contextFlags |= 1;
        }
        if (data.forwardCompatible) {
            contextFlags |= 2;
        }
        if (data.noErrorContext) {
            contextFlags |= 8;
            attribList.put(12723).put(1);
        }
        if (data.robustness) {
            if (!caps.GLX_ARB_create_context_robustness) {
                throw new SWTException("Context with robust buffer access requested but GLX_ARB_create_context_robustness is unavailable");
            }
            contextFlags |= 4;
            if (data.loseContextOnReset) {
                attribList.put(33366).put(33362);
            }
            if (data.contextResetIsolation) {
                if (!caps.GLX_ARB_robustness_application_isolation && !caps.GLX_ARB_robustness_share_group_isolation) {
                    throw new SWTException("Robustness isolation requested but neither GLX_ARB_robustness_application_isolation nor GLX_ARB_robustness_share_group_isolation available");
                }
                contextFlags |= 8;
            }
        }
        if (contextFlags > 0) {
            attribList.put(8340).put(contextFlags);
        }
        if (data.contextReleaseBehavior != null) {
            if (!caps.GLX_ARB_context_flush_control) {
                throw new SWTException("Context release behavior requested but GLX_ARB_context_flush_control is unavailable");
            }
            if (data.contextReleaseBehavior == GLData.ReleaseBehavior.NONE) {
                attribList.put(8343).put(0);
            } else if (data.contextReleaseBehavior == GLData.ReleaseBehavior.FLUSH) {
                attribList.put(8343).put(8344);
            }
        }
        attribList.put(0);
        attribList.flip();
    }

    public boolean isCurrent(long context) {
        return GLX13.glXGetCurrentContext() == context;
    }

    public boolean makeCurrent(GLCanvas canvas, long context) {
        long window = GTK3.gtk_widget_get_window((long)canvas.handle);
        long xDisplay = this.gdk_x11_display_get_xdisplay(window);
        return GLX13.glXMakeCurrent((long)xDisplay, (long)canvas.xWindow, (long)context);
    }

    public boolean deleteContext(GLCanvas canvas, long context) {
        long window = GTK3.gtk_widget_get_window((long)canvas.handle);
        long xDisplay = this.gdk_x11_display_get_xdisplay(window);
        if (context != 0L) {
            if (GLX13.glXGetCurrentContext() == context) {
                GLX13.glXMakeCurrent((long)xDisplay, (long)0L, (long)0L);
            }
            GLX13.glXDestroyContext((long)xDisplay, (long)context);
            canvas.context = 0L;
        }
        if (canvas.glWindow != 0L) {
            GDK.gdk_window_destroy((long)canvas.glWindow);
            canvas.glWindow = 0L;
        }
        return true;
    }

    public boolean swapBuffers(GLCanvas canvas) {
        long window = GTK3.gtk_widget_get_window((long)canvas.handle);
        long xDisplay = this.gdk_x11_display_get_xdisplay(window);
        GLX13.glXSwapBuffers((long)xDisplay, (long)canvas.xWindow);
        return false;
    }

    public boolean delayBeforeSwapNV(GLCanvas canvas, float seconds) {
        long window = GTK3.gtk_widget_get_window((long)canvas.handle);
        long xDisplay = this.gdk_x11_display_get_xdisplay(window);
        return GLXNVDelayBeforeSwap.glXDelayBeforeSwapNV((long)xDisplay, (long)canvas.xWindow, (float)seconds);
    }

    private long gdk_x11_display_get_xdisplay(long window) {
        long display = GDK.gdk_window_get_display((long)window);
        return GDK.gdk_x11_display_get_xdisplay((long)display);
    }
}

