/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.gtk.OS;

public final class Converter {
    public static final byte[] NullByteArray = new byte[1];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final char[] EmptyCharArray = new char[0];

    public static char[] mbcsToWcs(byte[] byArray) {
        int[] nArray = new int[1];
        int n = OS.g_utf8_to_utf16(byArray, byArray.length, null, nArray, null);
        if (n == 0) {
            return EmptyCharArray;
        }
        int n2 = nArray[0];
        char[] cArray = new char[n2];
        OS.memmove(cArray, n, n2 * 2);
        OS.g_free(n);
        return cArray;
    }

    public static byte[] wcsToMbcs(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return Converter.wcsToMbcs(cArray, bl);
    }

    public static String cCharPtrToJavaString(int n, boolean bl) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        if (bl) {
            OS.g_free(n);
        }
        return new String(Converter.mbcsToWcs(byArray));
    }

    public static byte[] wcsToMbcs(char[] cArray, boolean bl) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = OS.g_utf16_to_utf8(cArray, cArray.length, nArray, nArray2, null);
        if (n == 0) {
            return bl ? NullByteArray : EmptyByteArray;
        }
        int n2 = nArray2[0];
        byte[] byArray = new byte[n2 + (bl ? 1 : 0)];
        OS.memmove(byArray, n, n2);
        OS.g_free(n);
        return byArray;
    }

    public static char wcsToMbcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return '\u0000';
    }

    public static char mbcsToWcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = n <= 255 ? new byte[]{(byte)n} : new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        char[] cArray = Converter.mbcsToWcs(byArray);
        if (cArray.length == 0) {
            return '\u0000';
        }
        return cArray[0];
    }
}

