/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    int mozillaHandle;
    int embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static int eventProc;
    static Boolean IsXULRunner24;
    static final int STOP_PROPOGATE = 1;
    static final String LIB_FIX_XULRUNNER10 = "libswt-xulrunner-fix10.so";
    static final String LIB_FIX_XULRUNNER31 = "libswt-xulrunner-fix31.so";
    static final String LIB_XPCOM = "libxpcom.so";
    static final String LIB_XUL = "libxul.so";
    static boolean IsSparc;

    MozillaDelegate(Browser browser) {
        Object object;
        if (IsSparc) {
            object = Converter.wcsToMbcs("libCrun.so.1", true);
            OS.dlopen(object, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
        if (OS.GTK3) {
            object = " [Browser style SWT.MOZILLA and Java system property org.eclipse.swt.browser.DefaultType=mozilla are not supported with GTK 3 as XULRunner is not ported for GTK 3 yet]";
            SWT.error(2, null, (String)object);
        }
        this.browser = browser;
    }

    static int eventProc(int n, int n2, int n3) {
        int n4 = OS.gtk_widget_get_parent(n);
        if ((n4 = OS.gtk_widget_get_parent(n4)) == 0) {
            return 0;
        }
        Widget widget = Display.getCurrent().findWidget(n4);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(n, n2, n3);
        }
        return 0;
    }

    static Browser findBrowser(int n) {
        int n2 = OS.gtk_widget_get_parent(n);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(n2);
    }

    static String getCacheParentPath() {
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{LIB_XUL};
    }

    static String getJSLibraryName_Pre10() {
        return "libmozjs.so";
    }

    static String getLibraryName(String string) {
        if (IsXULRunner24 == null) {
            IsXULRunner24 = new File(string, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
        }
        return IsXULRunner24 != false ? LIB_XUL : LIB_XPCOM;
    }

    static String getProfilePath() {
        int n;
        String string = System.getProperty("user.home");
        if (string.equals("?") && (n = C.getenv(MozillaDelegate.wcsToMbcs(null, "HOME", true))) != 0) {
            int n2 = C.strlen(n);
            byte[] byArray = new byte[n2];
            C.memmove(byArray, n, n2);
            string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        }
        return string + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    static void loadAdditionalLibraries(String string, boolean bl) {
        Object object;
        String string2 = null;
        if (!bl) {
            if (IsXULRunner24 == null) {
                Boolean bl2 = IsXULRunner24 = new File(string, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
            }
            if (IsXULRunner24.booleanValue()) {
                string2 = LIB_FIX_XULRUNNER31;
            }
        } else if (MozillaVersion.CheckVersion(5, true)) {
            string2 = LIB_FIX_XULRUNNER10;
        }
        if (string2 == null) {
            return;
        }
        File file = new File(MozillaDelegate.getProfilePath() + "/libs/" + Mozilla.OS() + '/' + Mozilla.Arch());
        File file2 = new File(file, string2);
        if (!file2.exists() && (object = (Object)Library.class.getResourceAsStream('/' + string2)) != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] byArray = new byte[4096];
            try {
                int n;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = ((InputStream)object).read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                ((InputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (file2.exists()) {
            object = Converter.wcsToMbcs(file2.getAbsolutePath(), true);
            OS.dlopen((byte[])object, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return Converter.mbcsToWcs(byArray);
    }

    static boolean needsSpinup() {
        return true;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        return Converter.wcsToMbcs(string2, bl);
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    int getHandle() {
        if (OS.GTK3) {
            this.embedHandle = OS.gtk_box_new(0, 0);
            OS.gtk_box_set_homogeneous(this.embedHandle, false);
        } else {
            this.embedHandle = OS.gtk_hbox_new(false, 0);
        }
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    Point getNativeSize(int n, int n2) {
        return new Point(n, n2);
    }

    int getSiteWindow() {
        return this.embedHandle;
    }

    int gtk_event(int n, int n2, int n3) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        if (gdkEvent.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (n3 == 1) {
            return 1;
        }
        return 0;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
        int n = this.browser.getShell().getStyle();
        if ((n & 0x4000) != 0 && ((n & 0x80000) == 0 || (this.browser.getStyle() & 0x80000) == 0)) {
            this.browser.getDisplay().asyncExec(() -> {
                if (this.browser == null || this.browser.isDisposed()) {
                    return;
                }
                ((Mozilla)this.browser.webBrowser).Activate();
            });
        }
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        int n;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((n = OS.gtk_container_get_children(this.embedHandle)) != 0) {
            this.mozillaHandle = OS.g_list_data(n);
            OS.g_list_free(n);
            if (this.mozillaHandle != 0) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1);
            }
        }
    }

    void onDispose(int n) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(int n, int n2, int n3) {
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        OS.gtk_widget_set_size_request(n, n2, n3);
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }
}

