/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name = "";
    String command;
    String iconPath;
    Display display;
    boolean gioExpectUri;
    static long modTime;
    static Map<String, List<String>> mimeTable;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    static String[] parseCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != string.charAt(n); ++n2) {
                }
                if (n2 >= string.length()) {
                    arrayList.add(string.substring(n, n2));
                } else {
                    arrayList.add(string.substring(n + 1, n2));
                }
                n = n2 + 1;
                continue;
            }
            for (n2 = n; n2 < string.length() && !Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        String string2;
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        if ((string2 = Program.gio_getMimeType(string)) == null) {
            return null;
        }
        return Program.gio_getProgram(display, string2);
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    public ImageData getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData imageData = null;
        int n = OS.gtk_icon_theme_get_default();
        byte[] byArray = Converter.wcsToMbcs(this.iconPath, true);
        int n2 = OS.g_icon_new_for_string(byArray, null);
        if (n2 != 0) {
            int n3 = OS.gtk_icon_theme_lookup_by_gicon(n, n2, 16, 0);
            if (n3 != 0) {
                int n4 = OS.gtk_icon_info_load_icon(n3, null);
                if (n4 != 0) {
                    int n5 = OS.gdk_pixbuf_get_rowstride(n4);
                    int n6 = OS.gdk_pixbuf_get_pixels(n4);
                    int n7 = OS.gdk_pixbuf_get_height(n4);
                    int n8 = OS.gdk_pixbuf_get_width(n4);
                    boolean bl = OS.gdk_pixbuf_get_has_alpha(n4);
                    byte[] byArray2 = new byte[n5 * n7];
                    OS.memmove(byArray2, n6, byArray2.length);
                    OS.g_object_unref(n4);
                    if (bl) {
                        PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
                        imageData = new ImageData(n8, n7, 32, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n5;
                        int n9 = 3;
                        int n10 = 0;
                        byte[] byArray3 = new byte[n8 * n7];
                        for (int i = 0; i < n7; ++i) {
                            for (int j = 0; j < n8; ++j) {
                                byArray3[n10++] = byArray2[n9];
                                byArray2[n9] = 0;
                                n9 += 4;
                            }
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
                        imageData = new ImageData(n8, n7, 24, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n5;
                    }
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 8, 0)) {
                    OS.g_object_unref(n3);
                } else {
                    OS.gtk_icon_info_free(n3);
                }
            }
            OS.g_object_unref(n2);
        }
        return imageData;
    }

    static Map<String, List<String>> gio_getMimeInfo() {
        Path path = Paths.get("/usr/share/mime/globs", new String[0]);
        long l = 0L;
        try {
            l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (modTime != 0L && modTime == l) {
            return mimeTable;
        }
        try {
            mimeTable = new HashMap<String, List<String>>();
            modTime = l;
            for (String string : Files.readAllLines(path)) {
                int n = string.indexOf(58);
                if (n <= 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = string3.indexOf(".");
                if (n2 <= 0) continue;
                String string4 = string3.substring(n2);
                if (mimeTable.containsKey(string4)) {
                    List<String> list = mimeTable.get(string4);
                    arrayList.addAll(list);
                }
                arrayList.add(string2);
                mimeTable.put(string4, arrayList);
            }
            return mimeTable;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static String gio_getMimeType(String string) {
        String string2 = null;
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map != null && map.containsKey(string)) {
            List<String> list = map.get(string);
            string2 = list.get(0);
        }
        return string2;
    }

    static Program gio_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(string, true);
        int n = OS.g_app_info_get_default_for_type(byArray, false);
        if (n != 0) {
            program = Program.gio_getProgram(display, n);
        }
        return program;
    }

    static Program gio_getProgram(Display display, int n) {
        int n2;
        byte[] byArray;
        int n3;
        Program program = new Program();
        program.display = display;
        int n4 = OS.g_app_info_get_name(n);
        if (n4 != 0 && (n3 = OS.strlen(n4)) > 0) {
            byArray = new byte[n3];
            OS.memmove(byArray, n4, n3);
            program.name = new String(Converter.mbcsToWcs(byArray));
        }
        if ((n2 = OS.g_app_info_get_executable(n)) != 0 && (n3 = OS.strlen(n2)) > 0) {
            byArray = new byte[n3];
            OS.memmove(byArray, n2, n3);
            program.command = new String(Converter.mbcsToWcs(byArray));
        }
        program.gioExpectUri = OS.g_app_info_supports_uris(n);
        int n5 = OS.g_app_info_get_icon(n);
        if (n5 != 0) {
            int n6 = OS.g_icon_to_string(n5);
            if (n6 != 0) {
                n3 = OS.strlen(n6);
                if (n3 > 0) {
                    byArray = new byte[n3];
                    OS.memmove(byArray, n6, n3);
                    program.iconPath = new String(Converter.mbcsToWcs(byArray));
                }
                OS.g_free(n6);
            }
            OS.g_object_unref(n5);
        }
        return program.command != null ? program : null;
    }

    static Program[] getPrograms(Display display) {
        int n;
        int n2 = n = OS.g_app_info_get_all();
        LinkedHashSet<Program> linkedHashSet = new LinkedHashSet<Program>();
        while (n2 != 0) {
            Program program;
            int n3 = OS.g_list_data(n2);
            if (n3 != 0 && (program = Program.gio_getProgram(display, n3)) != null) {
                linkedHashSet.add(program);
            }
            n2 = OS.g_list_next(n2);
        }
        if (n != 0) {
            OS.g_list_free(n);
        }
        return linkedHashSet.toArray(new Program[linkedHashSet.size()]);
    }

    static boolean isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (OS.g_file_test(byArray, 4)) {
            return false;
        }
        if (!OS.g_file_test(byArray, 8)) {
            return false;
        }
        int n = OS.g_file_new_for_path(byArray);
        boolean bl = false;
        if (n != 0) {
            byte[] byArray2 = Converter.wcsToMbcs("*", true);
            int n2 = OS.g_file_query_info(n, byArray2, 0, 0, 0);
            if (n2 != 0) {
                byte[] byArray3;
                int n3 = OS.g_file_info_get_content_type(n2);
                if (n3 != 0 && !(bl = OS.g_content_type_is_a(n3, byArray3 = Converter.wcsToMbcs("application/x-executable", true)))) {
                    byte[] byArray4 = Converter.wcsToMbcs("application/x-shellscript", true);
                    bl = OS.g_content_type_equals(n3, byArray4);
                }
                OS.g_object_unref(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    static boolean gio_launch(String string) {
        boolean bl = false;
        byte[] byArray = Converter.wcsToMbcs(string, true);
        int n = OS.g_file_new_for_commandline_arg(byArray);
        if (n != 0) {
            int n2 = OS.g_file_get_uri(n);
            if (n2 != 0) {
                bl = OS.g_app_info_launch_default_for_uri(n2, 0, 0);
                OS.g_free(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    boolean gio_execute(String string) {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = Converter.wcsToMbcs(this.command, true);
        int n = OS.g_app_info_create_from_commandline(byArray2, byArray = Converter.wcsToMbcs(this.name, true), this.gioExpectUri ? 2 : 0, 0);
        if (n != 0) {
            byte[] byArray3 = Converter.wcsToMbcs(string, true);
            int n2 = 0;
            if (string.length() > 0) {
                n2 = OS.g_app_info_supports_uris(n) ? OS.g_file_new_for_uri(byArray3) : OS.g_file_new_for_path(byArray3);
            }
            int n3 = 0;
            if (n2 != 0) {
                n3 = OS.g_list_append(0, n2);
            }
            bl = OS.g_app_info_launch(n, n3, 0, 0);
            if (n3 != 0) {
                OS.g_list_free(n3);
                OS.g_object_unref(n2);
            }
            OS.g_object_unref(n);
        }
        return bl;
    }

    public static String[] getExtensions() {
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string, null);
    }

    public static boolean launch(String string, String string2) {
        return Program.launch(Display.getCurrent(), string, string2);
    }

    static boolean launch(Display display, String string, String string2) {
        String string3;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        if (string2 != null && Program.isExecutable(string)) {
            try {
                Compatibility.exec(new String[]{string}, null, string2);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (Program.gio_launch(string)) {
            return true;
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string3 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string3 = string.toLowerCase();
        if (string3.startsWith(PREFIX_HTTP) || string3.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{string}, null, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command) && this.gioExpectUri == program.gioExpectUri;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return this.gio_execute(string);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

