/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.opengl.glx.GLX;
import org.eclipse.swt.internal.opengl.glx.XVisualInfo;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int context;
    int xWindow;
    int glWindow;
    XVisualInfo vinfo;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite composite, int n, GLData gLData) {
        super(composite, n);
        if (gLData == null) {
            SWT.error(4);
        }
        int[] nArray = new int[32];
        int n2 = 0;
        nArray[n2++] = 4;
        if (gLData.doubleBuffer) {
            nArray[n2++] = 5;
        }
        if (gLData.stereo) {
            nArray[n2++] = 6;
        }
        if (gLData.redSize > 0) {
            nArray[n2++] = 8;
            nArray[n2++] = gLData.redSize;
        }
        if (gLData.greenSize > 0) {
            nArray[n2++] = 9;
            nArray[n2++] = gLData.greenSize;
        }
        if (gLData.blueSize > 0) {
            nArray[n2++] = 10;
            nArray[n2++] = gLData.blueSize;
        }
        if (gLData.alphaSize > 0) {
            nArray[n2++] = 11;
            nArray[n2++] = gLData.alphaSize;
        }
        if (gLData.depthSize > 0) {
            nArray[n2++] = 12;
            nArray[n2++] = gLData.depthSize;
        }
        if (gLData.stencilSize > 0) {
            nArray[n2++] = 13;
            nArray[n2++] = gLData.stencilSize;
        }
        if (gLData.accumRedSize > 0) {
            nArray[n2++] = 14;
            nArray[n2++] = gLData.accumRedSize;
        }
        if (gLData.accumGreenSize > 0) {
            nArray[n2++] = 15;
            nArray[n2++] = gLData.accumGreenSize;
        }
        if (gLData.accumBlueSize > 0) {
            nArray[n2++] = 16;
            nArray[n2++] = gLData.accumBlueSize;
        }
        if (gLData.accumAlphaSize > 0) {
            nArray[n2++] = 17;
            nArray[n2++] = gLData.accumAlphaSize;
        }
        if (gLData.sampleBuffers > 0) {
            nArray[n2++] = 100000;
            nArray[n2++] = gLData.sampleBuffers;
        }
        if (gLData.samples > 0) {
            nArray[n2++] = 100001;
            nArray[n2++] = gLData.samples;
        }
        nArray[n2++] = 0;
        OS.gtk_widget_realize(this.handle);
        int n3 = OS.GTK_WIDGET_WINDOW(this.handle);
        int n4 = OS.gdk_x11_drawable_get_xdisplay(n3);
        int n5 = GLX.glXChooseVisual(n4, OS.XDefaultScreen(n4), nArray);
        if (n5 == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.vinfo = new XVisualInfo();
        GLX.memmove(this.vinfo, n5, XVisualInfo.sizeof);
        OS.XFree(n5);
        int n6 = OS.gdk_screen_get_default();
        int n7 = OS.gdk_x11_screen_lookup_visual(n6, this.vinfo.visualid);
        int n8 = gLData.shareContext != null ? gLData.shareContext.context : 0;
        this.context = GLX.glXCreateContext(n4, this.vinfo, n8, true);
        if (this.context == 0) {
            SWT.error(2);
        }
        GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
        gdkWindowAttr.width = 1;
        gdkWindowAttr.height = 1;
        gdkWindowAttr.event_mask = 163598;
        gdkWindowAttr.window_type = 2;
        gdkWindowAttr.visual = n7;
        this.glWindow = OS.gdk_window_new(n3, gdkWindowAttr, 64);
        OS.gdk_window_set_user_data(this.glWindow, this.handle);
        if ((n & 0x40000) != 0) {
            OS.gdk_window_set_back_pixmap(n3, 0, false);
        }
        this.xWindow = OS.gdk_x11_drawable_get_xid(this.glWindow);
        OS.gdk_window_show(this.glWindow);
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        int[] nArray = new int[4];
                        GLX.glGetIntegerv(2978, nArray);
                        GLX.glViewport(nArray[0], nArray[1], nArray[2], nArray[3]);
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = GLCanvas.this.getClientArea();
                        OS.gdk_window_move(GLCanvas.this.glWindow, rectangle.x, rectangle.y);
                        OS.gdk_window_resize(GLCanvas.this.glWindow, rectangle.width, rectangle.height);
                        break;
                    }
                    case 12: {
                        int n = OS.GTK_WIDGET_WINDOW(GLCanvas.this.handle);
                        int n2 = OS.gdk_x11_drawable_get_xdisplay(n);
                        if (GLCanvas.this.context != 0) {
                            if (GLX.glXGetCurrentContext() == GLCanvas.this.context) {
                                GLX.glXMakeCurrent(n2, 0, 0);
                            }
                            GLX.glXDestroyContext(n2, GLCanvas.this.context);
                            GLCanvas.this.context = 0;
                        }
                        if (GLCanvas.this.glWindow == 0) break;
                        OS.gdk_window_destroy(GLCanvas.this.glWindow);
                        GLCanvas.this.glWindow = 0;
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        int n = OS.GTK_WIDGET_WINDOW(this.handle);
        int n2 = OS.gdk_x11_drawable_get_xdisplay(n);
        GLData gLData = new GLData();
        int[] nArray = new int[1];
        GLX.glXGetConfig(n2, this.vinfo, 5, nArray);
        gLData.doubleBuffer = nArray[0] != 0;
        GLX.glXGetConfig(n2, this.vinfo, 6, nArray);
        gLData.stereo = nArray[0] != 0;
        GLX.glXGetConfig(n2, this.vinfo, 8, nArray);
        gLData.redSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 9, nArray);
        gLData.greenSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 10, nArray);
        gLData.blueSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 11, nArray);
        gLData.alphaSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 12, nArray);
        gLData.depthSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 13, nArray);
        gLData.stencilSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 14, nArray);
        gLData.accumRedSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 15, nArray);
        gLData.accumGreenSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 16, nArray);
        gLData.accumBlueSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 17, nArray);
        gLData.accumAlphaSize = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 100000, nArray);
        gLData.sampleBuffers = nArray[0];
        GLX.glXGetConfig(n2, this.vinfo, 100001, nArray);
        gLData.samples = nArray[0];
        return gLData;
    }

    public boolean isCurrent() {
        return GLX.glXGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        if (GLX.glXGetCurrentContext() == this.context) {
            return;
        }
        int n = OS.GTK_WIDGET_WINDOW(this.handle);
        int n2 = OS.gdk_x11_drawable_get_xdisplay(n);
        GLX.glXMakeCurrent(n2, this.xWindow, this.context);
    }

    public void swapBuffers() {
        int n = OS.GTK_WIDGET_WINDOW(this.handle);
        int n2 = OS.gdk_x11_drawable_get_xdisplay(n);
        GLX.glXSwapBuffers(n2, this.xWindow);
    }
}

