/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebErrorPrivate;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.CERT_CONTEXT;
import org.eclipse.swt.internal.win32.CERT_INFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class WebFrameLoadDelegate {
    COMObject iWebFrameLoadDelegate;
    int refCount = 0;
    Browser browser;
    String html;
    String url;
    static final String OBJECTNAME_EXTERNAL = "external";

    WebFrameLoadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    void addEventHandlers(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.browser.execute(stringBuffer.toString());
            stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseover', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseout', SWTmousehandler, true);");
            this.browser.execute(stringBuffer.toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            stringBuffer.append('}');
            this.browser.execute(stringBuffer.toString());
        }
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebFrameLoadDelegate = new COMObject(new int[]{2, 0, 0, 2, 2, 3, 2, 3, 3, 2, 3, 2, 5, 2, 2, 3, 4}){

            @Override
            public int method0(int[] nArray) {
                return WebFrameLoadDelegate.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return WebFrameLoadDelegate.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return WebFrameLoadDelegate.this.Release();
            }

            @Override
            public int method3(int[] nArray) {
                return WebFrameLoadDelegate.this.didStartProvisionalLoadForFrame(nArray[0], nArray[1]);
            }

            @Override
            public int method4(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method5(int[] nArray) {
                return WebFrameLoadDelegate.this.didFailProvisionalLoadWithError(nArray[0], nArray[1], nArray[2]);
            }

            @Override
            public int method6(int[] nArray) {
                return WebFrameLoadDelegate.this.didCommitLoadForFrame(nArray[0], nArray[1]);
            }

            @Override
            public int method7(int[] nArray) {
                return WebFrameLoadDelegate.this.didReceiveTitle(nArray[0], nArray[1], nArray[2]);
            }

            @Override
            public int method8(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method9(int[] nArray) {
                return WebFrameLoadDelegate.this.didFinishLoadForFrame(nArray[0], nArray[1]);
            }

            @Override
            public int method10(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method11(int[] nArray) {
                return WebFrameLoadDelegate.this.didChangeLocationWithinPageForFrame(nArray[0], nArray[1]);
            }

            @Override
            public int method12(int[] nArray) {
                return 0;
            }

            @Override
            public int method13(int[] nArray) {
                return -2147467263;
            }

            @Override
            public int method14(int[] nArray) {
                return 0;
            }

            @Override
            public int method15(int[] nArray) {
                return 0;
            }

            @Override
            public int method16(int[] nArray) {
                return WebFrameLoadDelegate.this.didClearWindowObject(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        };
        int n = this.iWebFrameLoadDelegate.ppVtable;
        int[] nArray = new int[1];
        COM.MoveMemory(nArray, n, OS.PTR_SIZEOF);
        int[] nArray2 = new int[17];
        COM.MoveMemory(nArray2, nArray[0], OS.PTR_SIZEOF * nArray2.length);
        nArray2[12] = WebKit_win32.willPerformClientRedirectToURL_CALLBACK(nArray2[12]);
        COM.MoveMemory(nArray[0], nArray2, OS.PTR_SIZEOF * nArray2.length);
    }

    int didChangeLocationWithinPageForFrame(int n, int n2) {
        int n3;
        SWTEventListener[] sWTEventListenerArray;
        TypedEvent typedEvent;
        IWebFrame iWebFrame = new IWebFrame(n2);
        int[] nArray = new int[1];
        int n4 = iWebFrame.dataSource(nArray);
        if (n4 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(nArray[0]);
        nArray[0] = 0;
        n4 = iWebDataSource.request(nArray);
        iWebDataSource.Release();
        if (n4 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebURLRequest iWebURLRequest = new IWebURLRequest(nArray[0]);
        nArray[0] = 0;
        n4 = iWebURLRequest.URL(nArray);
        iWebURLRequest.Release();
        if (n4 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        if (string.length() == 0) {
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n5 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n5) == '#') {
                string = "about:blank" + string.substring(n5);
            }
        }
        Display display = this.browser.getDisplay();
        nArray[0] = 0;
        IWebView iWebView = new IWebView(n);
        n4 = iWebView.mainFrame(nArray);
        boolean bl = false;
        if (n4 == 0 && nArray[0] != 0) {
            bl = n2 == nArray[0];
            new IWebFrame(nArray[0]).Release();
        }
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            sWTEventListenerArray = this.browser.webBrowser.statusTextListeners;
            for (n3 = 0; n3 < sWTEventListenerArray.length; ++n3) {
                sWTEventListenerArray[n3].changed((StatusTextEvent)typedEvent);
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        sWTEventListenerArray = this.browser.webBrowser.locationListeners;
        for (n3 = 0; n3 < sWTEventListenerArray.length; ++n3) {
            sWTEventListenerArray[n3].changed((LocationEvent)typedEvent);
        }
        return 0;
    }

    int didClearWindowObject(int n, int n2, int n3, int n4) {
        WebKit_win32.JSGlobalContextRetain(n2);
        int n5 = WebKit_win32.JSContextGetGlobalObject(n2);
        int n6 = ((WebKit)this.browser.webBrowser).webViewData;
        int n7 = WebKit_win32.JSObjectMake(n2, WebKit.ExternalClass, n6);
        byte[] byArray = "external\u0000".getBytes(StandardCharsets.UTF_8);
        int n8 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        WebKit_win32.JSObjectSetProperty(n2, n5, n8, n7, 0, null);
        WebKit_win32.JSStringRelease(n8);
        for (BrowserFunction object2 : this.browser.webBrowser.functions.values()) {
            this.browser.execute(object2.functionString);
        }
        IWebView iWebView = new IWebView(n);
        int[] nArray = new int[1];
        iWebView.mainFrame(nArray);
        boolean bl = nArray[0] == n4;
        new IWebFrame(nArray[0]).Release();
        this.addEventHandlers(bl);
        return 0;
    }

    int didCommitLoadForFrame(int n, int n2) {
        Object object;
        IWebFrame iWebFrame = new IWebFrame(n2);
        int[] nArray = new int[1];
        int n3 = iWebFrame.dataSource(nArray);
        if (n3 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(nArray[0]);
        nArray[0] = 0;
        n3 = iWebDataSource.request(nArray);
        iWebDataSource.Release();
        if (n3 != 0 || nArray[0] == 0) {
            return 0;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(nArray[0]);
        nArray[0] = 0;
        n3 = iWebMutableURLRequest.URL(nArray);
        iWebMutableURLRequest.Release();
        if (n3 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        if (string.length() == 0) {
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n4 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n4) == '#') {
                string = "about:blank" + string.substring(n4);
            }
        }
        Display display = this.browser.getDisplay();
        nArray[0] = 0;
        IWebView iWebView = new IWebView(n);
        n3 = iWebView.mainFrame(nArray);
        boolean bl = false;
        if (n3 == 0 && nArray[0] != 0) {
            bl = n2 == nArray[0];
            new IWebFrame(nArray[0]).Release();
        }
        if (bl) {
            this.url = string;
            if (string.startsWith("about:blank") && this.html != null) {
                return 0;
            }
            for (BrowserFunction sWTEventListenerArray2 : this.browser.webBrowser.functions.values()) {
                this.browser.webBrowser.execute(sWTEventListenerArray2.functionString);
            }
            object = new ProgressEvent(this.browser);
            ((ProgressEvent)object).display = display;
            ((ProgressEvent)object).widget = this.browser;
            ((ProgressEvent)object).current = 1;
            ((ProgressEvent)object).total = 100;
            ProgressListener[] progressListenerArray = this.browser.webBrowser.progressListeners;
            for (int i = 0; i < progressListenerArray.length; ++i) {
                progressListenerArray[i].changed((ProgressEvent)object);
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
            for (int i = 0; i < statusTextListenerArray.length; ++i) {
                statusTextListenerArray[i].changed(statusTextEvent);
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        object = new LocationEvent(this.browser);
        ((LocationEvent)object).display = display;
        ((LocationEvent)object).widget = this.browser;
        ((LocationEvent)object).location = string;
        ((LocationEvent)object).top = bl;
        LocationListener[] locationListenerArray = this.browser.webBrowser.locationListeners;
        for (int i = 0; i < locationListenerArray.length; ++i) {
            locationListenerArray[i].changed((LocationEvent)object);
        }
        return 0;
    }

    int didFailProvisionalLoadWithError(int n, int n2, int n3) {
        IWebError iWebError = new IWebError(n2);
        int[] nArray = new int[1];
        int n4 = iWebError.code(nArray);
        if (-1000 < nArray[0]) {
            return 0;
        }
        String string = null;
        int[] nArray2 = new int[1];
        n4 = iWebError.failingURL(nArray2);
        if (n4 == 0 && nArray2[0] != 0) {
            string = WebKit.extractBSTR(nArray2[0]);
            COM.SysFreeString(nArray2[0]);
        }
        if (string != null && -1204 <= nArray[0] && nArray[0] <= -1200) {
            int[] nArray3 = new int[1];
            n4 = iWebError.localizedDescription(nArray3);
            if (n4 != 0 || nArray3[0] == 0) {
                return 0;
            }
            String string2 = WebKit.extractBSTR(nArray3[0]);
            COM.SysFreeString(nArray3[0]);
            nArray3[0] = 0;
            n4 = iWebError.QueryInterface(WebKit_win32.IID_IWebErrorPrivate, nArray3);
            if (n4 != 0 || nArray3[0] == 0) {
                return 0;
            }
            IWebErrorPrivate iWebErrorPrivate = new IWebErrorPrivate(nArray3[0]);
            nArray3[0] = 0;
            int[] nArray4 = new int[1];
            n4 = iWebErrorPrivate.sslPeerCertificate(nArray4);
            iWebErrorPrivate.Release();
            if (n4 != 0 || nArray4[0] == 0) {
                return 0;
            }
            if (this.showCertificateDialog(n, string, string2, nArray4[0])) {
                IWebFrame iWebFrame = new IWebFrame(n3);
                n4 = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0, WebKit_win32.IID_IWebMutableURLRequest, nArray3);
                if (n4 != 0 || nArray3[0] == 0) {
                    nArray4[0] = 0;
                    return 0;
                }
                IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(nArray3[0]);
                iWebMutableURLRequest.setURL(nArray2[0]);
                iWebMutableURLRequest.setAllowsAnyHTTPSCertificate();
                iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
                iWebMutableURLRequest.Release();
            }
            nArray4[0] = 0;
            return 0;
        }
        int[] nArray5 = new int[1];
        n4 = iWebError.localizedDescription(nArray5);
        if (n4 != 0 || nArray5[0] == 0) {
            return 0;
        }
        String string3 = WebKit.extractBSTR(nArray5[0]);
        COM.SysFreeString(nArray5[0]);
        if (!this.browser.isDisposed()) {
            String string4 = string != null ? string + "\n\n" : "";
            string4 = string4 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string3});
            MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
            messageBox.setMessage(string4);
            messageBox.open();
        }
        return 0;
    }

    int didFinishLoadForFrame(int n, int n2) {
        Object object;
        IWebView iWebView = new IWebView(n);
        int[] nArray = new int[1];
        int n3 = iWebView.mainFrame(nArray);
        if (n3 != 0 || nArray[0] == 0) {
            return 0;
        }
        boolean bl = n2 == nArray[0];
        new IWebFrame(nArray[0]).Release();
        if (!bl) {
            return 0;
        }
        if (this.html != null && this.getUrl().startsWith("about:blank")) {
            ((WebKit)this.browser.webBrowser).loadingText = true;
            int n4 = WebKit.createBSTR(this.html);
            int n5 = ((WebKit)this.browser.webBrowser).untrustedText ? WebKit.createBSTR("about:blank") : WebKit.createBSTR("file:///");
            object = new IWebFrame(n2);
            object.loadHTMLString(n4, n5);
            this.html = null;
        }
        if (!((WebKit)this.browser.webBrowser).loadingText) {
            int n6;
            SWTEventListener[] sWTEventListenerArray;
            TypedEvent typedEvent;
            if (this.browser.isDisposed()) {
                return 0;
            }
            Display display = this.browser.getDisplay();
            IWebFrame iWebFrame = new IWebFrame(n2);
            object = new int[1];
            n3 = iWebFrame.dataSource((int[])object);
            if (n3 != 0 || object[0] == 0) {
                return 0;
            }
            IWebDataSource iWebDataSource = new IWebDataSource((int)object[0]);
            object[0] = false;
            n3 = iWebDataSource.pageTitle((int[])object);
            iWebDataSource.Release();
            if (n3 != 0) {
                return 0;
            }
            String string = null;
            if (object[0] != false) {
                string = WebKit.extractBSTR((int)object[0]);
                COM.SysFreeString((int)object[0]);
            }
            if (string == null || string.length() == 0) {
                typedEvent = new TitleEvent(this.browser);
                typedEvent.display = display;
                typedEvent.widget = this.browser;
                typedEvent.title = this.getUrl();
                sWTEventListenerArray = this.browser.webBrowser.titleListeners;
                for (n6 = 0; n6 < sWTEventListenerArray.length; ++n6) {
                    sWTEventListenerArray[n6].changed((TitleEvent)typedEvent);
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            typedEvent = new ProgressEvent(this.browser);
            ((ProgressEvent)typedEvent).display = display;
            ((ProgressEvent)typedEvent).widget = this.browser;
            ((ProgressEvent)typedEvent).current = 100;
            ((ProgressEvent)typedEvent).total = 100;
            sWTEventListenerArray = this.browser.webBrowser.progressListeners;
            for (n6 = 0; n6 < sWTEventListenerArray.length; ++n6) {
                sWTEventListenerArray[n6].completed((ProgressEvent)typedEvent);
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        ((WebKit)this.browser.webBrowser).loadingText = false;
        return 0;
    }

    int didReceiveTitle(int n, int n2, int n3) {
        IWebView iWebView = new IWebView(n);
        int[] nArray = new int[1];
        int n4 = iWebView.mainFrame(nArray);
        if (n4 != 0 || n3 == 0) {
            return 0;
        }
        if (n3 == nArray[0]) {
            String string = WebKit.extractBSTR(n2);
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            TitleListener[] titleListenerArray = this.browser.webBrowser.titleListeners;
            for (int i = 0; i < titleListenerArray.length; ++i) {
                titleListenerArray[i].changed(titleEvent);
            }
        }
        new IWebFrame(nArray[0]).Release();
        return 0;
    }

    int didStartProvisionalLoadForFrame(int n, int n2) {
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebFrameLoadDelegate != null) {
            this.iWebFrameLoadDelegate.dispose();
            this.iWebFrameLoadDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebFrameLoadDelegate.getAddress();
    }

    String getUrl() {
        if (this.url == null || this.url.length() == 0) {
            return "about:blank";
        }
        return this.url;
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.iWebFrameLoadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebFrameLoadDelegate)) {
            COM.MoveMemory(n2, new int[]{this.iWebFrameLoadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    boolean showCertificateDialog(int n, String string, String string2, int n2) {
        Shell shell = this.browser.getShell();
        Shell shell2 = new Shell(shell, 67680);
        shell2.setText(Compatibility.getMessage("SWT_InvalidCert_Title"));
        shell2.setLayout(new GridLayout());
        Label label = new Label(shell2, 64);
        String string3 = null;
        try {
            string3 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            string3 = string;
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(Compatibility.getMessage("SWT_InvalidCert_Message", new String[]{string3}));
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage(string2));
        stringBuffer.append("\n");
        stringBuffer.append(Compatibility.getMessage("SWT_InvalidCert_Connect"));
        stringBuffer.append("\n");
        label.setText(stringBuffer.toString());
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n3 = monitor.getBounds().width * 2 / 3;
        int n4 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n4, n3);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        boolean[] blArray = new boolean[1];
        Button[] buttonArray = new Button[3];
        Listener listener = event -> {
            if (event.widget == buttonArray[2]) {
                this.showCertificate(shell2, n2);
            } else {
                blArray[0] = event.widget == buttonArray[0];
                shell2.close();
            }
        };
        Composite composite = new Composite(shell2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(3, true));
        buttonArray[0] = new Button(composite, 8);
        buttonArray[0].setText(SWT.getMessage("SWT_Continue"));
        buttonArray[0].setLayoutData(new GridData(768));
        buttonArray[0].addListener(13, listener);
        buttonArray[1] = new Button(composite, 8);
        buttonArray[1].setText(SWT.getMessage("SWT_Cancel"));
        buttonArray[1].setLayoutData(new GridData(768));
        buttonArray[1].addListener(13, listener);
        buttonArray[2] = new Button(composite, 8);
        buttonArray[2].setText(SWT.getMessage("SWT_ViewCertificate"));
        buttonArray[2].setLayoutData(new GridData(768));
        buttonArray[2].addListener(13, listener);
        shell2.setDefaultButton(buttonArray[0]);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n5 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n6 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n5, n6);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return blArray[0];
    }

    void showCertificate(Shell shell, int n) {
        Object object;
        CERT_CONTEXT cERT_CONTEXT = new CERT_CONTEXT();
        OS.MoveMemory(cERT_CONTEXT, n, CERT_CONTEXT.sizeof);
        CERT_INFO cERT_INFO = new CERT_INFO();
        OS.MoveMemory(cERT_INFO, cERT_CONTEXT.pCertInfo, CERT_INFO.sizeof);
        int n2 = OS.CertNameToStr(1, cERT_INFO.Issuer, 1, null, 0);
        TCHAR tCHAR = new TCHAR(0, n2);
        OS.CertNameToStr(1, cERT_INFO.Issuer, 1, tCHAR, n2);
        String string = tCHAR.toString(0, tCHAR.strlen());
        n2 = OS.CertNameToStr(1, cERT_INFO.Subject, 1, null, 0);
        tCHAR = new TCHAR(0, n2);
        OS.CertNameToStr(1, cERT_INFO.Subject, 1, tCHAR, n2);
        String string2 = tCHAR.toString(0, tCHAR.strlen());
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        OS.FileTimeToSystemTime(cERT_INFO.NotBefore, sYSTEMTIME);
        String string3 = sYSTEMTIME.wDay + "/" + sYSTEMTIME.wMonth + "/" + sYSTEMTIME.wYear;
        String string4 = sYSTEMTIME.wHour + ":" + sYSTEMTIME.wMinute + ":" + sYSTEMTIME.wSecond;
        sYSTEMTIME = new SYSTEMTIME();
        OS.FileTimeToSystemTime(cERT_INFO.NotAfter, sYSTEMTIME);
        String string5 = sYSTEMTIME.wDay + "/" + sYSTEMTIME.wMonth + "/" + sYSTEMTIME.wYear;
        String string6 = sYSTEMTIME.wHour + ":" + sYSTEMTIME.wMinute + ":" + sYSTEMTIME.wSecond;
        n2 = cERT_INFO.SerialNumber.cbData;
        byte[] byArray = new byte[n2];
        OS.MoveMemory(byArray, cERT_INFO.SerialNumber.pbData, n2);
        String string7 = new String();
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = 0xFF & byArray[i];
            object = Integer.toHexString(n3);
            if (((String)object).length() == 1) {
                string7 = string7 + "0";
            }
            string7 = string7 + (String)object + " ";
        }
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setText(SWT.getMessage("SWT_Certificate"));
        shell2.setLayout(new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(shell2, 0);
        tabFolder.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        tabFolder.setLayout(new FillLayout());
        object = new TabItem(tabFolder, 0);
        ((TabItem)object).setText(SWT.getMessage("SWT_General"));
        Composite composite = new Composite(tabFolder, 2048);
        composite.setLayout(new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(1, 0x1000000, false, false));
        label.setText(Compatibility.getMessage("SWT_IssuedTo", new Object[]{string2}));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData(new GridData(1, 0x1000000, false, false));
        label2.setText(Compatibility.getMessage("SWT_IssuedFrom", new Object[]{string}));
        Label label3 = new Label(composite, 0);
        label3.setLayoutData(new GridData(1, 0x1000000, false, false));
        label3.setText(Compatibility.getMessage("SWT_ValidFromTo", new Object[]{string3, string5}));
        ((TabItem)object).setControl(composite);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SWT.getMessage("SWT_Details"));
        Table table = new Table(tabFolder, 67588);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(SWT.getMessage("SWT_Field"));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(SWT.getMessage("SWT_Value"));
        TableItem tableItem = new TableItem(table, 0);
        String string8 = "V" + String.valueOf(cERT_INFO.dwVersion + 1);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Version"), string8});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_SerialNumber"), string7});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Issuer"), string});
        tableItem = new TableItem(table, 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(string4);
        stringBuffer.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidFrom"), stringBuffer.toString()});
        tableItem = new TableItem(table, 0);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string5);
        stringBuffer2.append(", ");
        stringBuffer2.append(string6);
        stringBuffer2.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidTo"), stringBuffer2.toString()});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Subject"), string2});
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).pack();
        }
        tabItem.setControl(table);
        Button button = new Button(shell2, 8);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        gridData.widthHint = 75;
        button.setLayoutData(gridData);
        button.setText(SWT.getMessage("SWT_OK"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n4 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n5 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n4, n5);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

