/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDownload;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLResponse;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

class WebDownloadDelegate {
    COMObject iWebDownloadDelegate;
    Browser browser;
    int refCount = 0;
    int status = -1;
    long size;
    long totalSize;
    String url;
    static final int DOWNLOAD_FINISHED = 0;
    static final int DOWNLOAD_CANCELLED = 1;
    static final int DOWNLOAD_ERROR = 3;

    WebDownloadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebDownloadDelegate = new COMObject(new int[]{2, 0, 0, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 1, 1}){

            @Override
            public long method0(long[] lArray) {
                return WebDownloadDelegate.this.QueryInterface(lArray[0], lArray[1]);
            }

            @Override
            public long method1(long[] lArray) {
                return WebDownloadDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] lArray) {
                return WebDownloadDelegate.this.Release();
            }

            @Override
            public long method3(long[] lArray) {
                return WebDownloadDelegate.this.decideDestinationWithSuggestedFilename(lArray[0], lArray[1]);
            }

            @Override
            public long method4(long[] lArray) {
                return -2147467263L;
            }

            @Override
            public long method5(long[] lArray) {
                return -2147467263L;
            }

            @Override
            public long method6(long[] lArray) {
                return WebDownloadDelegate.this.didFailWithError(lArray[0], lArray[1]);
            }

            @Override
            public long method7(long[] lArray) {
                return -2147467263L;
            }

            @Override
            public long method8(long[] lArray) {
                return WebDownloadDelegate.this.didReceiveDataOfLength(lArray[0], (int)lArray[1]);
            }

            @Override
            public long method9(long[] lArray) {
                return WebDownloadDelegate.this.didReceiveResponse(lArray[0], lArray[1]);
            }

            @Override
            public long method10(long[] lArray) {
                return -2147467263L;
            }

            @Override
            public long method11(long[] lArray) {
                return -2147467263L;
            }

            @Override
            public long method12(long[] lArray) {
                return WebDownloadDelegate.this.willSendRequest(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            @Override
            public long method13(long[] lArray) {
                return WebDownloadDelegate.this.didBegin(lArray[0]);
            }

            @Override
            public long method14(long[] lArray) {
                return WebDownloadDelegate.this.didFinish(lArray[0]);
            }
        };
    }

    int decideDestinationWithSuggestedFilename(long l, long l2) {
        String string = WebKit.extractBSTR(l2);
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        fileDialog.setOverwrite(true);
        String string2 = fileDialog.open();
        IWebDownload iWebDownload = new IWebDownload(l);
        iWebDownload.setDeletesFileUponFailure(0);
        if (string2 == null) {
            iWebDownload.setDestination(WebKit.createBSTR(""), 1);
            iWebDownload.cancel();
            iWebDownload.Release();
        } else {
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            iWebDownload.setDestination(WebKit.createBSTR(string2), 1);
            this.openDownloadWindow(iWebDownload, string2);
        }
        return 0;
    }

    int didBegin(long l) {
        new IWebDownload(l).AddRef();
        this.status = -1;
        this.size = 0L;
        this.totalSize = 0L;
        this.url = null;
        return 0;
    }

    int didFailWithError(long l, long l2) {
        new IWebDownload(l).Release();
        this.status = 3;
        return 0;
    }

    int didFinish(long l) {
        new IWebDownload(l).Release();
        this.status = 0;
        return 0;
    }

    int didReceiveDataOfLength(long l, int n) {
        this.size += (long)n;
        return 0;
    }

    int didReceiveResponse(long l, long l2) {
        if (l2 != 0L) {
            long[] lArray;
            IWebURLResponse iWebURLResponse = new IWebURLResponse(l2);
            long[] lArray2 = new long[1];
            int n = iWebURLResponse.expectedContentLength(lArray2);
            if (n == 0) {
                this.totalSize = lArray2[0];
            }
            if ((n = iWebURLResponse.URL(lArray = new long[1])) == 0 && lArray[0] != 0L) {
                this.url = WebKit.extractBSTR(lArray[0]);
                COM.SysFreeString(lArray[0]);
            }
        }
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebDownloadDelegate != null) {
            this.iWebDownloadDelegate.dispose();
            this.iWebDownloadDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebDownloadDelegate.getAddress();
    }

    void openDownloadWindow(IWebDownload iWebDownload, String string) {
        final Shell shell = new Shell();
        shell.setText(Compatibility.getMessage("SWT_FileDownload"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Download_Location", new Object[]{string, this.url}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width / 2;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = event -> {
            iWebDownload.cancel();
            this.status = 1;
            iWebDownload.Release();
        };
        button.addListener(13, listener);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed() || WebDownloadDelegate.this.status == 0 || WebDownloadDelegate.this.status == 1) {
                    shell.dispose();
                    return;
                }
                if (WebDownloadDelegate.this.status == 3) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    button.removeListener(13, listener);
                    button.addListener(13, event -> shell.dispose());
                    return;
                }
                long l = WebDownloadDelegate.this.size / 1024L;
                long l2 = WebDownloadDelegate.this.totalSize / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{new Long(l), new Long(l2)});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebDownloadDelegate)) {
            COM.MoveMemory(l2, new long[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int willSendRequest(long l, long l2, long l3, long l4) {
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(l2);
        iWebMutableURLRequest.AddRef();
        OS.MoveMemory(l4, new long[]{l2}, C.PTR_SIZEOF);
        return 0;
    }
}

