/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Matcher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    boolean ignoreResize;
    boolean lockText;
    int scrollWidth;
    int visibleCount;
    long cbtHook;
    String[] items = new String[0];
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static long EditProc;
    static long ListProc;
    static final long ComboProc;
    static final TCHAR ComboClass;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = (int)OS.SendMessage(this.handle, 323, 0L, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (0 > n || n > n3) {
            this.error(6);
        }
        if ((n2 = (int)OS.SendMessage(this.handle, 330, (long)n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n2 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        int n = -1;
        if (!this.noSelection) {
            n = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n != -1) {
            OS.SendMessage(this.handle, 334, (long)n, 0L);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    void applyEditSegments() {
        int n;
        int n2;
        if (--this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) {
            return;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        int n3 = OS.GetWindowTextLength(l);
        int n4 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n4, n3 + 1);
        if (n3 > 0) {
            OS.GetWindowText(l, tCHAR, n3 + 1);
        }
        String string = tCHAR.toString(0, n3);
        this.segments = null;
        Event event = this.getSegments(string);
        if (event == null || event.segments == null) {
            return;
        }
        this.segments = event.segments;
        int n5 = this.segments.length;
        if (n5 == 0) {
            return;
        }
        char[] cArray = event.segmentsChars;
        int n6 = (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
        OS.SendMessage(l, 197, (long)(n6 + Math.min(n5, LIMIT - n6)), 0L);
        char[] cArray2 = new char[(n3 += n5) + 1];
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n7 < n3) {
            if (n8 < n5 && n7 - n8 == this.segments[n8]) {
                n = cArray != null && cArray.length > n8 ? cArray[n8] : n2;
                cArray2[n7++] = n;
                ++n8;
                continue;
            }
            if (string == null) continue;
            cArray2[n7] = string.charAt(n7++ - n8);
        }
        while (n8 < n5) {
            this.segments[n8] = n7 - n8;
            n = cArray != null && cArray.length > n8 ? cArray[n8] : n2;
            cArray2[n7++] = n;
            ++n8;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(l, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        boolean bl = this.ignoreCharacter;
        boolean bl2 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        cArray2[n3] = '\u0000';
        tCHAR = new TCHAR(n4, cArray2, false);
        OS.SendMessage(l, 177, 0L, -1L);
        long l2 = OS.SendMessage(l, 198, 0L, 0L);
        OS.SendMessage(l, 194, l2, tCHAR);
        nArray[0] = this.translateOffset(nArray[0]);
        nArray2[0] = this.translateOffset(nArray2[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        if (cArray != null && cArray.length > 0) {
            int n10 = this.state & 0x400000;
            if (cArray[0] == '\u202b') {
                super.updateTextDirection(0x4000000);
            } else if (cArray[0] == '\u202a') {
                super.updateTextDirection(0x2000000);
            }
            this.state |= n10;
        }
        OS.SendMessage(l, 177, (long)nArray[0], (long)nArray2[0]);
        this.ignoreCharacter = bl;
        this.ignoreModify = bl2;
    }

    void applyListSegments() {
        boolean bl;
        int n = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n == -1) {
            return;
        }
        boolean bl2 = bl = this.items.length != n;
        if (bl) {
            this.items = new String[n];
        }
        int n2 = this.items.length;
        int n3 = -1;
        int n4 = this.getCodePage();
        if (!this.noSelection) {
            n3 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        }
        while (n2-- > 0) {
            String string;
            TCHAR tCHAR = null;
            if (bl) {
                int n5 = (int)OS.SendMessage(this.handle, 329, (long)n2, 0L);
                if (n5 == -1) {
                    this.error(1);
                }
                if (OS.SendMessage(this.handle, 328, (long)n2, tCHAR = new TCHAR(n4, n5 + 1)) == -1L) {
                    return;
                }
                this.items[n2] = string = tCHAR.toString(0, n5);
            } else {
                string = this.items[n2];
            }
            if (OS.SendMessage(this.handle, 324, (long)n2, 0L) == -1L) {
                return;
            }
            if (tCHAR == null) {
                tCHAR = new TCHAR(n4, string, true);
            }
            if (OS.SendMessage(this.handle, 330, (long)n2, tCHAR) != -1L) continue;
            return;
        }
        if (n3 != -1) {
            OS.SendMessage(this.handle, 334, (long)n3, 0L);
        }
    }

    @Override
    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (l == this.handle) {
            switch (n) {
                case 5: {
                    this.ignoreResize = true;
                    boolean bl = this.lockText;
                    if ((this.style & 8) == 0) {
                        this.lockText = true;
                    }
                    long l4 = OS.CallWindowProc(ComboProc, l, n, l2, l3);
                    if ((this.style & 8) == 0) {
                        this.lockText = bl;
                    }
                    this.ignoreResize = false;
                    return l4;
                }
            }
            return OS.CallWindowProc(ComboProc, l, n, l2, l3);
        }
        long l5 = OS.GetDlgItem(this.handle, 1001);
        if (l == l5) {
            if (this.lockText && n == 12) {
                long l6 = OS.GetProcessHeap();
                int n2 = OS.GetWindowTextLength(this.handle);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
                OS.GetWindowText(this.handle, tCHAR, n2 + 1);
                int n3 = tCHAR.length() * TCHAR.sizeof;
                long l7 = OS.HeapAlloc(l6, 8, n3);
                OS.MoveMemory(l7, tCHAR, n3);
                long l8 = OS.CallWindowProc(EditProc, l5, n, l2, l7);
                OS.HeapFree(l6, 0, l7);
                return l8;
            }
            return OS.CallWindowProc(EditProc, l, n, l2, l3);
        }
        long l9 = OS.GetDlgItem(this.handle, 1000);
        if (l == l9) {
            return OS.CallWindowProc(ListProc, l, n, l2, l3);
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    long CBTProc(long l, long l2, long l3) {
        if ((int)l == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(l2, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n = OS.GetWindowLong(l2, -16);
                OS.SetWindowLong(l2, -16, n & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, (int)l, l2, l3);
    }

    @Override
    boolean checkHandle(long l) {
        return l == this.handle || l == OS.GetDlgItem(this.handle, 1001) || l == OS.GetDlgItem(this.handle, 1000);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    void clearSegments(boolean bl) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        int n2 = (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
        if (n2 < LIMIT) {
            OS.SendMessage(l, 197, (long)Math.max(1, n2 - n), 0L);
        }
        if (!bl) {
            this.segments = null;
            return;
        }
        boolean bl2 = this.ignoreCharacter;
        boolean bl3 = this.ignoreModify;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int n3 = OS.GetWindowTextLength(l);
        int n4 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n4, n3 + 1);
        if (n3 > 0) {
            OS.GetWindowText(l, tCHAR, n3 + 1);
        }
        tCHAR = this.deprocessText(tCHAR, 0, -1, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(l, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        nArray[0] = this.untranslateOffset(nArray[0]);
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        this.segments = null;
        OS.SendMessage(l, 177, 0L, -1L);
        long l2 = OS.SendMessage(l, 198, 0L, 0L);
        OS.SendMessage(l, 194, l2, tCHAR);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(l, 177, (long)nArray[0], (long)nArray2[0]);
        this.ignoreCharacter = bl2;
        this.ignoreModify = bl3;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0L, -1L);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        int n3;
        long l;
        long l2;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n == -1) {
            l2 = 0L;
            long l3 = OS.GetDC(this.handle);
            l = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l != 0L) {
                l2 = OS.SelectObject(l3, l);
            }
            int n6 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            RECT rECT = new RECT();
            int n7 = 3072;
            if ((this.style & 8) == 0) {
                n7 |= 0x2000;
            }
            int n8 = OS.GetWindowTextLength(this.handle);
            int n9 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n9, n8 + 1);
            OS.GetWindowText(this.handle, tCHAR, n8 + 1);
            OS.DrawText(l3, tCHAR, n8, rECT, n7);
            n4 = Math.max(n4, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n4 = Math.max(n4, this.scrollWidth);
            } else {
                for (int i = 0; i < n6; ++i) {
                    int n10;
                    n8 = (int)OS.SendMessage(this.handle, 329, (long)i, 0L);
                    if (n8 == -1) continue;
                    if (n8 + 1 > tCHAR.length()) {
                        tCHAR = new TCHAR(n9, n8 + 1);
                    }
                    if ((n10 = (int)OS.SendMessage(this.handle, 328, (long)i, tCHAR)) == -1) continue;
                    OS.DrawText(l3, tCHAR, n8, rECT, n7);
                    n4 = Math.max(n4, rECT.right - rECT.left);
                }
            }
            if (l != 0L) {
                OS.SelectObject(l3, l2);
            }
            OS.ReleaseDC(this.handle, l3);
        }
        if (n2 == -1 && (this.style & 0x40) != 0) {
            int n11 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            n3 = (int)OS.SendMessage(this.handle, 340, 0L, 0L);
            n5 = n11 * n3;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if ((this.style & 8) != 0) {
            n4 += 8;
        } else {
            l = OS.GetDlgItem(this.handle, 1001);
            if (l != 0L) {
                l2 = OS.SendMessage(l, 212, 0L, 0L);
                int n12 = OS.LOWORD(l2) + OS.HIWORD(l2);
                n4 += n12 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n4 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n5 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n3 = OS.GetSystemMetrics(45);
            n4 += OS.GetSystemMetrics(2) + n3 * 2;
            int n13 = (int)OS.SendMessage(this.handle, 340, -1L, 0L);
            n5 = (this.style & 4) != 0 ? n13 + 6 : (n5 += n13 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(3);
        }
        return new Point(n4, n5);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0L, 0L);
    }

    @Override
    void createHandle() {
        long l;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            int n = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            l = callback.getAddress();
            if (l == 0L) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, l, 0L, n);
            super.createHandle();
            if (this.cbtHook != 0L) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0L;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L && EditProc == 0L) {
            EditProc = OS.GetWindowLongPtr(l2, -4);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L && ListProc == 0L) {
            ListProc = OS.GetWindowLongPtr(l, -4);
        }
        if ((this.style & 0x40) != 0) {
            int n = 52;
            this.SetWindowPos(this.handle, 0L, 0, 0, 16383, 16383, n);
            this.SetWindowPos(this.handle, 0L, 0, 0, 0, 0, n);
        }
    }

    @Override
    void createWidget() {
        int n;
        super.createWidget();
        this.visibleCount = 5;
        if ((this.style & 0x40) == 0 && (n = (int)OS.SendMessage(this.handle, 340, 0L, 0L)) != -1 && n != 0) {
            int n2 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n2 = (rECT.bottom - rECT.top) / 3;
            } else {
                long l = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(l, mONITORINFO);
                n2 = (mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top) / 3;
            }
            this.visibleCount = Math.max(this.visibleCount, n2 / n);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0L, 0L);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR tCHAR, int n, int n2, boolean bl) {
        char[] cArray;
        if (tCHAR == null || this.segments == null) {
            return tCHAR;
        }
        int n3 = tCHAR.length();
        if (n3 == 0) {
            return tCHAR;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return tCHAR;
        }
        if (n < 0) {
            n = 0;
        }
        if (OS.IsUnicode) {
            cArray = tCHAR.chars;
            if (tCHAR.chars[n3 - 1] == '\u0000') {
                --n3;
            }
        } else {
            cArray = new char[n3];
            n3 = OS.MultiByteToWideChar(this.getCodePage(), 1, tCHAR.bytes, n3, cArray, n3);
        }
        if (n2 == -1) {
            n2 = n3;
        }
        if (n2 > this.segments[0] && n <= this.segments[n4 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            for (int i = n; i < n2; ++i) {
                if (n6 < n4 && i - n6 == this.segments[n6]) {
                    ++n6;
                    continue;
                }
                cArray[i - n6 + n5] = cArray[i];
            }
            n3 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n3) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
            return new TCHAR(this.getCodePage(), cArray2, bl);
        }
        return tCHAR;
    }

    @Override
    void deregister() {
        long l;
        super.deregister();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            this.display.removeControl(l2);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            this.display.removeControl(l);
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        if (n != n2) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1L, 0L);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1L, 0L);
        this.sendEvent(24);
        this.clearSegments(false);
        --this.clearSegmentsCount;
    }

    @Override
    boolean dragDetect(long l, int n, int n2, boolean bl, boolean[] blArray, boolean[] blArray2) {
        long l2;
        if (bl && (this.style & 8) == 0 && (l2 = OS.GetDlgItem(this.handle, 1001)) != 0L) {
            long l3;
            int n3;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n3 = OS.LOWORD(OS.SendMessage(l2, 215, 0L, l3 = OS.MAKELPARAM(n, n2)))) && n3 < nArray2[0] && super.dragDetect(l, n, n2, bl, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(l, n, n2, bl, blArray, blArray2);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        int n = this.translateOffset(this.getCaretPosition());
        long l = OS.GetDlgItem(this.handle, 1001);
        long l2 = OS.SendMessage(l, 214, (long)n, 0L);
        if (l2 == -1L) {
            l2 = 0L;
            if (n >= OS.GetWindowTextLength(l)) {
                int n2 = this.getCodePage();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(l, 176, nArray, nArray2);
                OS.SendMessage(l, 177, (long)n, (long)n);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(l, 194, 0L, new TCHAR(n2, " ", true));
                l2 = OS.SendMessage(l, 214, (long)n, 0L);
                OS.SendMessage(l, 177, (long)n, (long)(n + 1));
                OS.SendMessage(l, 194, 0L, new TCHAR(n2, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(l, 177, (long)nArray[0], (long)nArray[0]);
                OS.SendMessage(l, 177, (long)nArray[0], (long)nArray2[0]);
            }
        }
        POINT pOINT = new POINT();
        pOINT.x = OS.GET_X_LPARAM(l2);
        pOINT.y = OS.GET_Y_LPARAM(l2);
        OS.MapWindowPoints(l, this.handle, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l = OS.GetDlgItem(this.handle, 1001);
        OS.SendMessage(l, 176, nArray, nArray2);
        int n = nArray[0];
        if (nArray[0] != nArray2[0] && !OS.IsWinCE) {
            POINT pOINT;
            int n2 = OS.GetWindowThreadProcessId(l, null);
            GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
            gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
            if (OS.GetGUIThreadInfo(n2, gUITHREADINFO) && (gUITHREADINFO.hwndCaret == l || gUITHREADINFO.hwndCaret == 0L) && OS.GetCaretPos(pOINT = new POINT())) {
                long l2 = OS.SendMessage(l, 214, (long)nArray2[0], 0L);
                if (l2 == -1L) {
                    long l3 = OS.SendMessage(l, 214, (long)nArray[0], 0L);
                    int n3 = OS.GET_X_LPARAM(l3);
                    if (pOINT.x > n3) {
                        n = nArray2[0];
                    }
                } else {
                    int n4 = OS.GET_X_LPARAM(l2);
                    if (pOINT.x >= n4) {
                        n = nArray2[0];
                    }
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.mbcsToWcsPos(n);
        }
        return this.untranslateOffset(n);
    }

    public String getItem(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L);
        if (n2 != -1) {
            if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                return this.items[n];
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
            int n3 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR);
            if (n3 != -1) {
                return tCHAR.toString(0, n2);
            }
        }
        int n4 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (0 <= n && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        int n = (int)OS.SendMessage(this.handle, 340, 0L, 0L);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0L, 0L) != 0L;
        }
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, bl ? 1L : 0L, 0L);
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    Event getSegments(String string) {
        int n;
        Event event = null;
        if (this.hooks(49) || this.filters(49)) {
            event = new Event();
            event.text = string;
            this.sendEvent(49, event);
            if (event != null && event.segments != null) {
                int n2;
                int n3 = event.segments.length;
                int n4 = n2 = string == null ? 0 : string.length();
                for (n = 1; n < n3; ++n) {
                    if (event.segments[n] >= event.segments[n - 1] && event.segments[n] <= n2) continue;
                    SWT.error(5);
                }
            }
        }
        if ((this.state & 0x400000) != 0) {
            n = BidiUtil.resolveTextDirection(string);
            if (n == 0) {
                n = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
            }
            int[] nArray = null;
            char[] cArray = null;
            if (event == null) {
                event = new Event();
            } else {
                nArray = event.segments;
                cArray = event.segmentsChars;
            }
            int n5 = nArray == null ? 0 : nArray.length;
            event.segments = new int[n5 + 1];
            event.segmentsChars = new char[n5 + 1];
            if (nArray != null) {
                System.arraycopy(nArray, 0, event.segments, 1, n5);
            }
            if (cArray != null) {
                System.arraycopy(cArray, 0, event.segmentsChars, 1, n5);
            }
            event.segments[0] = 0;
            event.segmentsChars[0] = n == 0x4000000 ? 8235 : 8234;
        }
        return event;
    }

    String getSegmentsText(String string, Event event) {
        int n;
        int n2;
        if (string == null || event == null) {
            return string;
        }
        int[] nArray = event.segments;
        if (nArray == null) {
            return string;
        }
        int n3 = nArray.length;
        if (n3 == 0) {
            return string;
        }
        char[] cArray = event.segmentsChars;
        int n4 = string.length();
        char[] cArray2 = new char[n4];
        string.getChars(0, n4, cArray2, 0);
        char[] cArray3 = new char[n4 + n3];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n5 < n4) {
            if (n6 < n3 && n5 == nArray[n6]) {
                n = cArray != null && cArray.length > n6 ? cArray[n6] : n2;
                cArray3[n5 + n6++] = n;
                continue;
            }
            cArray3[n5 + n6] = cArray2[n5++];
        }
        while (n6 < n3) {
            nArray[n6] = n5;
            n = cArray != null && cArray.length > n6 ? cArray[n6] : n2;
            cArray3[n5 + n6++] = n;
        }
        return new String(cArray3, 0, cArray3.length);
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(this.untranslateOffset(nArray[0]), this.untranslateOffset(nArray2[0]));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return (int)OS.SendMessage(this.handle, 327, 0L, 0L);
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
            return tCHAR.toString();
        }
        return tCHAR.toString(0, n);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n = (int)OS.SendMessage(this.handle, 340, -1L, 0L);
        if (n == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n + 6 : n + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return LIMIT;
        }
        int n = (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
        if (this.segments != null && n < LIMIT) {
            n = Math.max(1, n - this.segments.length);
        }
        return n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    boolean hasFocus() {
        long l = OS.GetFocus();
        if (l == this.handle) {
            return true;
        }
        if (l == 0L) {
            return false;
        }
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l == l2) {
            return true;
        }
        long l3 = OS.GetDlgItem(this.handle, 1000);
        return l == l3;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            for (int i = n; i < n2; ++i) {
                if (!string.equals(this.getItem(i))) continue;
                return i;
            }
            return -1;
        }
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (0 > n || n >= n3) {
            return -1;
        }
        int n4 = n - 1;
        int n5 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n4 = (int)OS.SendMessage(this.handle, 344, (long)(n5 = n4), tCHAR)) != -1 && n4 > n5) continue;
            return -1;
        } while (!string.equals(this.getItem(n4)));
        return n4;
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(l);
        if (n2 == 0) {
            return 0;
        }
        if (n >= n2) {
            return n2;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(l, byArray, n2 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0L, 0L);
    }

    @Override
    void register() {
        long l;
        super.register();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            this.display.addControl(l2, this);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            this.display.addControl(l, this);
        }
    }

    public void remove(int n) {
        this.checkWidget();
        this.remove(n, true);
    }

    void remove(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L);
            if (n4 == -1) {
                n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
                if (0 <= n && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
                if (0 <= n && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = OS.GetWindowTextLength(this.handle);
        n3 = (int)OS.SendMessage(this.handle, 324, (long)n, 0L);
        if (n3 == -1) {
            n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
            if (0 <= n && n < n2) {
                this.error(15);
            }
            this.error(6);
        } else if (n3 == 0) {
            OS.SendMessage(this.handle, 331, 0L, 0L);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl && n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
        }
        int n6 = this.getCodePage();
        int n7 = 3104;
        for (int i = n; i <= n2; ++i) {
            int n8;
            int n9;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n9 = (int)OS.SendMessage(this.handle, 329, (long)n, 0L)) == -1 || (n8 = (int)OS.SendMessage(this.handle, 328, (long)n, tCHAR = new TCHAR(n6, n9 + 1))) == -1)) break;
            n9 = (int)OS.SendMessage(this.handle, 324, (long)n, 0L);
            if (n9 == -1) {
                this.error(15);
            } else if (n9 == 0) {
                OS.SendMessage(this.handle, 331, 0L, 0L);
            }
            if ((this.style & 0x100) == 0) continue;
            OS.DrawText(l, tCHAR, -1, rECT, n7);
            n5 = Math.max(n5, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n5, false);
        }
        if (n4 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0L, 0L);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        int n = -1;
        if (!this.noSelection) {
            n = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        }
        this.clearSegments(true);
        this.applyEditSegments();
        this.applyListSegments();
        if (n != -1) {
            OS.SendMessage(this.handle, 334, (long)n, 0L);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    @Override
    boolean sendKeyEvent(int n, int n2, long l, long l2, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, l, l2, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c = event.character;
        int n3 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n3 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && OS.GetDlgItem(this.handle, 1001) == OS.GetCapture()) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 == 0L) {
            return true;
        }
        OS.SendMessage(l3, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(l3, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n4 = OS.GetWindowTextLength(l3);
                if (nArray[0] == n4) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
                    OS.SendMessage(l3, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n4);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(l3, 177, (long)nArray[0], (long)nArray2[0]);
        OS.SendMessage(l3, 194, 0L, (TCHAR)object);
        return false;
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (0 <= n && n < n2) {
            int n3 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
            if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 2) && this.getListVisible() && (this.style & 8) != 0 && n2 == 1 && n3 == -1) {
                OS.SendMessage(this.handle, 256, 40L, 0L);
                this.sendEvent(24);
                return;
            }
            int n4 = (int)OS.SendMessage(this.handle, 334, (long)n, 0L);
            if (n4 != -1 && n4 != n3) {
                if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 2) && this.getListVisible() && (this.style & 8) != 0) {
                    int n5 = 38;
                    int n6 = 40;
                    if (n == 0) {
                        n5 = 40;
                        n6 = 38;
                    }
                    OS.SendMessage(this.handle, 256, (long)n5, 0L);
                    OS.SendMessage(this.handle, 256, (long)n6, 0L);
                }
                this.sendEvent(24);
            }
        }
    }

    @Override
    void setBackgroundImage(long l) {
        long l2;
        super.setBackgroundImage(l);
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 != 0L) {
            OS.InvalidateRect(l3, null, true);
        }
        if ((l2 = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
    }

    @Override
    void setBackgroundPixel(int n) {
        long l;
        super.setBackgroundPixel(n);
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l, null, true);
        }
    }

    @Override
    void setBoundsInPixels(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 4) != 0) {
            int n6 = this.getItemCount() == 0 ? 5 : this.visibleCount;
            n4 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n6 + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0L, rECT) != 0L) {
                int n7 = rECT.right - rECT.left;
                int n8 = rECT.bottom - rECT.top;
                if (n7 == n3 && n8 == n4) {
                    n5 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0L, n, n2, n3, n4, n5);
        } else {
            super.setBoundsInPixels(n, n2, n3, n4, n5);
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        boolean bl = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        super.setFont(font);
        if ((this.style & 8) == 0) {
            this.lockText = bl;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    @Override
    void setForegroundPixel(int n) {
        long l;
        super.setForegroundPixel(n);
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L) {
            OS.InvalidateRect(l2, null, true);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.InvalidateRect(l, null, true);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getSelectionIndex();
        this.remove(n, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n);
        if (n2 != -1) {
            this.select(n2);
        }
    }

    public void setItems(String ... stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            this.error(5);
        }
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0L, 0L);
        int n2 = this.getCodePage();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            TCHAR tCHAR = new TCHAR(n2, string, true);
            int n3 = (int)OS.SendMessage(this.handle, 323, 0L, tCHAR);
            if (n3 == -1) {
                this.error(14);
            }
            if (n3 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) == 0) continue;
            int n4 = 3104;
            OS.DrawText(l, tCHAR, -1, rECT, n4);
            n = Math.max(n, rECT.right - rECT.left);
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n + 3);
        }
        this.sendEvent(24);
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n2 = this.getCodePage();
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        int n4 = 3104;
        for (int i = 0; i < n3; ++i) {
            TCHAR tCHAR;
            int n5;
            int n6 = (int)OS.SendMessage(this.handle, 329, (long)i, 0L);
            if (n6 == -1 || (n5 = (int)OS.SendMessage(this.handle, 328, (long)i, tCHAR = new TCHAR(n2, n6 + 1))) == -1) continue;
            OS.DrawText(l2, tCHAR, -1, rECT, n4);
            n = Math.max(n, rECT.right - rECT.left);
        }
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        this.setScrollWidth(n + 3);
    }

    void setScrollWidth(int n) {
        int n2;
        this.scrollWidth = n;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, (long)n, 0L);
            return;
        }
        boolean bl = false;
        int n3 = (int)OS.SendMessage(this.handle, 326, 0L, 0L);
        if (n3 > 3) {
            n2 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n2 = (rECT.right - rECT.left) / 4;
            } else {
                long l = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(l, mONITORINFO);
                n2 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            bl = n > n2;
        }
        n2 = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        if (bl) {
            OS.SendMessage(this.handle, 352, 0L, 0L);
            OS.SendMessage(this.handle, 350, (long)n, 0L);
        } else {
            OS.SendMessage(this.handle, 352, (long)(n += OS.GetSystemMetrics(3)), 0L);
            OS.SendMessage(this.handle, 350, 0L, 0L);
        }
        if ((this.style & 8) == 0) {
            this.lockText = n2;
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n = 3104;
        OS.DrawText(l2, tCHAR, -1, rECT, n);
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        if (bl) {
            if (n <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n + 3);
        } else {
            if (n < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = this.translateOffset(point.x);
        int n2 = this.translateOffset(point.y);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
            n2 = this.wcsToMbcsPos(n2);
        }
        long l = OS.MAKELPARAM(n, n2);
        OS.SendMessage(this.handle, 322, 0L, l);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
            return;
        }
        this.clearSegments(false);
        int n = LIMIT;
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l != 0L) {
            n = (int)OS.SendMessage(l, 213, 0L, 0L) & Integer.MAX_VALUE;
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.applyEditSegments();
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.segments != null && n > 0) {
            OS.SendMessage(this.handle, 321, (long)(n + Math.min(this.segments.length, LIMIT - n)), 0L);
        } else {
            OS.SendMessage(this.handle, 321, (long)n, 0L);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        long l = OS.GetDlgItem(this.handle, 1001);
        long l2 = OS.GetDlgItem(this.handle, 1000);
        if (l != 0L) {
            shell.setToolTipText(l, string);
        }
        if (l2 != 0L) {
            shell.setToolTipText(l2, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        this.updateDropDownHeight();
    }

    @Override
    void subclass() {
        long l;
        super.subclass();
        long l2 = this.display.windowProc;
        long l3 = OS.GetDlgItem(this.handle, 1001);
        if (l3 != 0L) {
            OS.SetWindowLongPtr(l3, -4, l2);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L) {
            OS.SetWindowLongPtr(l, -4, l2);
        }
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    @Override
    boolean translateTraversal(MSG mSG) {
        switch ((int)mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0L, 0L) == 0L) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    @Override
    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
            OS.SendMessage(this.handle, 335, 0L, 0L);
            return true;
        }
        return super.traverseEscape();
    }

    @Override
    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
            OS.SendMessage(this.handle, 335, 0L, 0L);
            return true;
        }
        return super.traverseReturn();
    }

    @Override
    void unsubclass() {
        long l;
        super.unsubclass();
        long l2 = OS.GetDlgItem(this.handle, 1001);
        if (l2 != 0L && EditProc != 0L) {
            OS.SetWindowLongPtr(l2, -4, EditProc);
        }
        if ((l = OS.GetDlgItem(this.handle, 1000)) != 0L && ListProc != 0L) {
            OS.SetWindowLongPtr(l, -4, ListProc);
        }
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    void updateDropDownHeight() {
        if ((this.style & 4) != 0) {
            RECT rECT = new RECT();
            OS.SendMessage(this.handle, 338, 0L, rECT);
            int n = this.getItemCount() == 0 ? 5 : this.visibleCount;
            int n2 = this.getTextHeightInPixels() + this.getItemHeightInPixels() * n + 2;
            if (n2 != rECT.bottom - rECT.top) {
                this.forceResize();
                OS.GetWindowRect(this.handle, rECT);
                int n3 = 54;
                this.SetWindowPos(this.handle, 0L, 0, 0, rECT.right - rECT.left, n2, n3);
            }
        }
    }

    @Override
    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            if (n == 0x6000000 && !OS.IsUnicode) {
                this.state &= 0xFFBFFFFF;
                return false;
            }
            this.clearSegments(true);
            this.applyEditSegments();
            this.applyListSegments();
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        int n;
        int n2 = OS.GetWindowLong(this.handle, -20);
        n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
        OS.SetWindowLong(this.handle, -20, n2 &= 0xFFFFDFFF);
        long l = 0L;
        long l2 = 0L;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            l = cOMBOBOXINFO.hwndItem;
            l2 = cOMBOBOXINFO.hwndList;
        }
        if (l != 0L) {
            n = OS.GetWindowLong(l, -20);
            int n3 = OS.GetWindowLong(l, -16);
            if ((this.style & 0x4000000) != 0) {
                n |= 0x3000;
                n3 |= 2;
            } else {
                n &= 0xFFFFCFFF;
                n3 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(l, -20, n);
            OS.SetWindowLong(l, -16, n3);
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            int n4 = rECT.right - rECT.left;
            int n5 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n6 = rECT.right - rECT.left;
            int n7 = rECT.bottom - rECT.top;
            int n8 = 22;
            this.SetWindowPos(l, 0L, 0, 0, n4 - 1, n5 - 1, n8);
            this.SetWindowPos(this.handle, 0L, 0, 0, n6 - 1, n7 - 1, n8);
            this.SetWindowPos(l, 0L, 0, 0, n4, n5, n8);
            this.SetWindowPos(this.handle, 0L, 0, 0, n6, n7, n8);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (l2 != 0L) {
            n = OS.GetWindowLong(l2, -20);
            n = (this.style & 0x4000000) != 0 ? (n |= 0x400000) : (n &= 0xFFBFFFFF);
            OS.SetWindowLong(l2, -20, n);
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        event2.start = this.untranslateOffset(event2.start);
        event2.end = this.untranslateOffset(event2.end);
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        long l = OS.GetDlgItem(this.handle, 1001);
        if (l == 0L) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA(l);
        if (n2 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA(l, byArray, n2 + 1);
        int n3 = 0;
        for (int i = 0; n3 < n2 && n != i; ++i) {
            if (!OS.IsDBCSLeadByte(byArray[n3++])) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    @Override
    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n | 1;
        }
        if ((this.style & 8) != 0) {
            return n | 3;
        }
        return n | 2;
    }

    @Override
    TCHAR windowClass() {
        return ComboClass;
    }

    @Override
    long windowProc() {
        return ComboProc;
    }

    @Override
    long windowProc(long l, int n, long l2, long l3) {
        long l4;
        if (this.handle == 0L) {
            return 0L;
        }
        if (l != this.handle) {
            l4 = OS.GetDlgItem(this.handle, 1001);
            long l5 = OS.GetDlgItem(this.handle, 1000);
            if (l4 != 0L && l == l4 || l5 != 0L && l == l5) {
                LRESULT lRESULT = null;
                boolean bl = false;
                boolean bl2 = false;
                switch (n) {
                    case 258: {
                        bl = (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) && !this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0;
                        lRESULT = this.wmChar(l, l2, l3);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(l, l2, l3);
                        break;
                    }
                    case 256: {
                        bl = l2 == 46L && (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0);
                        lRESULT = this.wmKeyDown(l, l2, l3);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(l, l2, l3);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(l, l2, l3);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(l, l2, l3);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(l, l2, l3);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(l, l2, l3);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(l, l2, l3);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(l, l2, l3);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(l, l2, l3);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(l, l2, l3);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(l, l2, l3);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(l, l2, l3);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(l, l2, l3);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(l, l2, l3);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(l, l2, l3);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(l, l2, l3);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(l, l2, l3);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(l, l2, l3);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(l, l2, l3);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(l, l2, l3);
                        break;
                    }
                    case 198: {
                        if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                        return 0L;
                    }
                    case 199: 
                    case 772: {
                        if (this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0) {
                            return 0L;
                        }
                    }
                    case 768: 
                    case 769: 
                    case 770: 
                    case 771: {
                        bl = this.hooks(49) || this.filters(49) || (this.state & 0x400000) != 0;
                    }
                    case 12: {
                        if (l != l4) break;
                        lRESULT = this.wmClipboard(l, n, l2, l3);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                if (bl) {
                    if (this.getDrawing() && OS.IsWindowVisible(l4)) {
                        bl2 = true;
                        OS.DefWindowProc(l4, 11, 0L, 0L);
                    }
                    this.clearSegments(true);
                    long l6 = this.callWindowProc(l, n, l2, l3);
                    this.applyEditSegments();
                    if (bl2) {
                        OS.DefWindowProc(l4, 11, 1L, 0L);
                        OS.InvalidateRect(l4, null, true);
                    }
                    return l6;
                }
                return this.callWindowProc(l, n, l2, l3);
            }
        }
        switch (n) {
            case 334: {
                Object object;
                l4 = -1L;
                int n2 = (int)l2;
                if ((this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
                    object = this.getText();
                    String string = null;
                    if (l2 == -1L) {
                        string = "";
                    } else if (0L <= l2 && l2 < (long)this.getItemCount()) {
                        string = this.getItem((int)l2);
                    }
                    if (string != null && !string.equals(object)) {
                        int n3 = OS.GetWindowTextLength(this.handle);
                        object = string;
                        if ((string = this.verifyText(string, 0, n3, null)) == null) {
                            return 0L;
                        }
                        if (!string.equals(object) && (n2 = this.indexOf(string)) != -1 && (long)n2 != l2) {
                            return this.callWindowProc(this.handle, 334, n2, l3);
                        }
                    }
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0 || (l4 = super.windowProc(l, n, l2, l3)) == -1L || l4 == -2L) break;
                object = this.getSegments(this.items[n2]);
                int[] nArray = this.segments = object != null ? ((Event)object).segments : null;
                if (((Event)object).segmentsChars != null) {
                    int n4 = this.state & 0x400000;
                    if (((Event)object).segmentsChars[0] == '\u202b') {
                        super.updateTextDirection(0x4000000);
                    } else if (((Event)object).segmentsChars[0] == '\u202a') {
                        super.updateTextDirection(0x2000000);
                    }
                    this.state |= n4;
                }
                return l4;
            }
            case 323: 
            case 330: 
            case 344: {
                if (l3 == 0L || !this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                l4 = -1L;
                int n5 = OS.IsUnicode ? OS.wcslen(l3) : OS.strlen(l3);
                TCHAR tCHAR = new TCHAR(this.getCodePage(), n5);
                OS.MoveMemory(tCHAR, l3, tCHAR.length() * TCHAR.sizeof);
                String string = tCHAR.toString(0, n5);
                Event event = this.getSegments(string);
                if (event != null && event.segments != null) {
                    tCHAR = new TCHAR(this.getCodePage(), this.getSegmentsText(string, event), true);
                    long l7 = OS.GetProcessHeap();
                    n5 = tCHAR.length() * TCHAR.sizeof;
                    long l8 = OS.HeapAlloc(l7, 8, n5);
                    OS.MoveMemory(l8, tCHAR, n5);
                    l4 = super.windowProc(l, n, l2, l8);
                    OS.HeapFree(l7, 0, l8);
                }
                if (n == 323 || n == 330) {
                    int n6 = n == 323 ? this.items.length : (int)l2;
                    String[] stringArray = new String[this.items.length + 1];
                    System.arraycopy(this.items, 0, stringArray, 0, n6);
                    stringArray[n6] = string;
                    System.arraycopy(this.items, n6, stringArray, n6 + 1, this.items.length - n6);
                    this.items = stringArray;
                }
                if (l4 == -1L || l4 == -2L) break;
                return l4;
            }
            case 324: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                l4 = super.windowProc(l, n, l2, l3);
                if (l4 != -1L && l4 != -2L) {
                    int n7 = (int)l2;
                    if (this.items.length == 1) {
                        this.items = new String[0];
                    } else if (this.items.length > 1) {
                        String[] stringArray = new String[this.items.length - 1];
                        System.arraycopy(this.items, 0, stringArray, 0, n7);
                        System.arraycopy(this.items, n7 + 1, stringArray, n7, this.items.length - n7 - 1);
                        this.items = stringArray;
                    }
                    if (!this.noSelection && (long)(n7 = (int)OS.SendMessage(this.handle, 327, 0L, 0L)) == l2) {
                        this.clearSegments(false);
                        this.applyEditSegments();
                    }
                }
                return l4;
            }
            case 331: {
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                if (this.items.length > 0) {
                    this.items = new String[0];
                }
                this.clearSegments(false);
                this.applyEditSegments();
            }
        }
        return super.windowProc(l, n, l2, l3);
    }

    @Override
    LRESULT WM_CTLCOLOR(long l, long l2) {
        return this.wmColorChild(l, l2);
    }

    @Override
    LRESULT WM_GETDLGCODE(long l, long l2) {
        long l3 = this.callWindowProc(this.handle, 135, l, l2);
        return new LRESULT(l3 | 1L);
    }

    @Override
    LRESULT WM_KILLFOCUS(long l, long l2) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(l, l2);
        }
        return null;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        int n;
        int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n2 != (n = (int)OS.SendMessage(this.handle, 327, 0L, 0L))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendSelectionEvent(13, null, true);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(long l, long l2) {
        return null;
    }

    @Override
    LRESULT WM_SIZE(long l, long l2) {
        if (this.ignoreResize) {
            return null;
        }
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(l, l2);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    long l3;
                    long l4 = OS.GetDlgItem(this.handle, 1001);
                    if (l4 != 0L) {
                        OS.InvalidateRect(l4, null, true);
                    }
                    if ((l3 = OS.GetDlgItem(this.handle, 1000)) != 0L) {
                        OS.InvalidateRect(l3, null, true);
                    }
                } else {
                    int n = 133;
                    OS.RedrawWindow(this.handle, null, 0L, n);
                }
            }
            return lRESULT;
        }
        boolean bl = this.lockText;
        if ((this.style & 8) == 0) {
            this.lockText = true;
        }
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if ((this.style & 8) == 0) {
            this.lockText = bl;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(long l, long l2) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
            if ((wINDOWPOS.flags & 1) == 0) {
                wINDOWPOS.flags |= 8;
                OS.MoveMemory(l2, wINDOWPOS, WINDOWPOS.sizeof);
                OS.InvalidateRect(this.handle, null, true);
                RECT rECT = new RECT();
                OS.GetWindowRect(this.handle, rECT);
                int n = rECT.right - rECT.left;
                int n2 = rECT.bottom - rECT.top;
                if (n != 0 && n2 != 0) {
                    long l3 = this.parent.handle;
                    long l4 = OS.GetWindow(l3, 5);
                    OS.MapWindowPoints(0L, l3, rECT, 2);
                    long l5 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                    while (l4 != 0L) {
                        if (l4 != this.handle) {
                            OS.GetWindowRect(l4, rECT);
                            OS.MapWindowPoints(0L, l3, rECT, 2);
                            long l6 = OS.CreateRectRgn(rECT.left, rECT.top, rECT.right, rECT.bottom);
                            OS.CombineRgn(l5, l5, l6, 4);
                            OS.DeleteObject(l6);
                        }
                        l4 = OS.GetWindow(l4, 2);
                    }
                    int n3 = 1029;
                    OS.RedrawWindow(l3, null, l5, n3);
                    OS.DeleteObject(l5);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmChar(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l2) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.sendSelectionEvent(14);
                }
                this.ignoreDefaultSelection = false;
                if (this.getSelectionIndex() == -1 && (this.style & 4) != 0 && (this.style & 8) == 0) {
                    if (OS.SendMessage(this.handle, 343, 0L, 0L) != 0L) {
                        OS.SendMessage(this.handle, 335, 0L, 0L);
                    }
                    return LRESULT.ZERO;
                }
            }
            case 27: {
                if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0L, 0L) == 0L) {
                    return LRESULT.ZERO;
                }
            }
            case 127: {
                String string;
                Matcher matcher;
                if (OS.GetKeyState(17) >= 0) break;
                if (OS.WIN32_VERSION < OS.VERSION(6, 0) || (this.style & 8) != 0) {
                    return LRESULT.ZERO;
                }
                Point point = this.getSelection();
                long l4 = OS.GetDlgItem(this.handle, 1001);
                int n = point.x;
                int n2 = point.y;
                if (n == n2 && (matcher = CTRL_BS_PATTERN.matcher(string = this.getText().substring(0, n))).find()) {
                    n = matcher.start();
                    n2 = matcher.end();
                    OS.SendMessage(l4, 177, (long)n, (long)n2);
                }
                if (n < n2) {
                    OS.SendMessage(l4, 194, 1L, 0L);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(long l, int n, long l2, long l3) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n) {
            case 768: 
            case 771: {
                OS.SendMessage(l, 176, nArray, nArray2);
                if (this.untranslateOffset(nArray[0]) == this.untranslateOffset(nArray2[0])) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(l, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(l, 198, 0L, 0L) == 0L) break;
                this.ignoreModify = true;
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                int n2 = OS.GetWindowTextLength(l);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(l, 176, (int[])object, nArray3);
                if (n2 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
                    OS.GetWindowText(l, tCHAR, n2 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, l, n, l2, l3);
                OS.SendMessage(l, 176, nArray, nArray2);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                if (this.lockText) {
                    return null;
                }
                nArray2[0] = OS.GetWindowTextLength(l);
                int n2 = OS.IsUnicode ? OS.wcslen(l3) : OS.strlen(l3);
                object = new TCHAR(this.getCodePage(), n2);
                int n3 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, l3, n3);
                string = ((TCHAR)object).toString(0, n2);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    OS.CallWindowProc(EditProc, l, n, l2, l3);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n == 12) {
                    long l4 = OS.GetProcessHeap();
                    int n4 = ((TCHAR)object).length() * TCHAR.sizeof;
                    long l5 = OS.HeapAlloc(l4, 8, n4);
                    OS.MoveMemory(l5, (TCHAR)object, n4);
                    long l6 = OS.CallWindowProc(EditProc, l, n, l2, l5);
                    OS.HeapFree(l4, 0, l5);
                    return new LRESULT(l6);
                }
                OS.SendMessage(l, 194, 0L, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    @Override
    LRESULT wmCommandChild(long l, long l2) {
        int n = OS.HIWORD(l);
        switch (n) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
                if (n2 != -1) {
                    OS.SendMessage(this.handle, 334, (long)n2, 0L);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 7: {
                this.setCursor();
                this.updateDropDownHeight();
                break;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    long l3 = l2;
                    int n3 = OS.GetWindowLong(l3, -20);
                    int n4 = OS.GetWindowLong(l3, -16);
                    if (n == 1792) {
                        n3 |= 0x3000;
                        n4 |= 2;
                    } else {
                        n3 &= 0xFFFFCFFF;
                        n4 &= 0xFFFFFFFD;
                    }
                    OS.SetWindowLong(l3, -20, n3);
                    OS.SetWindowLong(l3, -16, n4);
                }
                if (!this.hooks(49) && !this.filters(49) && (this.state & 0x400000) == 0) break;
                this.clearSegments(true);
                this.state &= 0xFFBFFFFF;
                this.applyEditSegments();
            }
        }
        return super.wmCommandChild(l, l2);
    }

    @Override
    LRESULT wmIMEChar(long l, long l2, long l3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = (int)l2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, l2, l3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        long l4 = this.callWindowProc(l, 646, l2, l3);
        MSG mSG = new MSG();
        int n = 10420227;
        while (OS.PeekMessage(mSG, l, 258, 258, n)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, l2, l3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(l4);
    }

    @Override
    LRESULT wmKeyDown(long l, long l2, long l3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        switch ((int)l2) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (this.segments == null) break;
                long l4 = 0L;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.SendMessage(this.handle, 320, nArray, nArray2);
                while (true) {
                    l4 = this.callWindowProc(l, 256, l2, l3);
                    OS.SendMessage(this.handle, 320, nArray3, nArray4);
                    if (nArray3[0] != nArray[0] ? this.untranslateOffset(nArray3[0]) != this.untranslateOffset(nArray[0]) : nArray4[0] == nArray2[0] || this.untranslateOffset(nArray4[0]) != this.untranslateOffset(nArray2[0])) break;
                    nArray[0] = nArray3[0];
                    nArray2[0] = nArray4[0];
                }
                lRESULT = l4 == 0L ? LRESULT.ZERO : new LRESULT(l4);
                break;
            }
            case 13: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0L, 0L) == 0L) break;
                this.ignoreDefaultSelection = true;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT wmSysKeyDown(long l, long l2, long l3) {
        int n = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
        LRESULT lRESULT = super.wmSysKeyDown(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && l2 == 40L) {
            long l4 = this.callWindowProc(l, 260, l2, l3);
            int n2 = (int)OS.SendMessage(this.handle, 327, 0L, 0L);
            if (n != n2) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendSelectionEvent(13, null, true);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(l4);
        }
        return lRESULT;
    }

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }
}

