/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import java.io.IOException;
import ru.woesss.micro3d.PlatformHelper;

public class Texture {
    int nPointer;
    boolean isForModel;

    static {
        System.loadLibrary("java_micro3d_v3_32");
        Texture.nInitClass();
    }

    public Texture(byte[] b, boolean isForModel) {
        if (b == null) {
            throw new NullPointerException();
        }
        this.nPointer = this.nInit(b, isForModel);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
        this.isForModel = isForModel;
    }

    public Texture(String name, boolean isForModel) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        byte[] b = PlatformHelper.getResourceBytes(name);
        if (b == null) {
            throw new IOException("Resource \"" + name + "\" not found");
        }
        this.nPointer = this.nInit(b, isForModel);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
        this.isForModel = isForModel;
    }

    public final void dispose() {
        if (this.nPointer != 0) {
            this.nFinalize();
            this.nPointer = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private native int nInit(byte[] var1, boolean var2);

    private native void nFinalize();

    private static native void nInitClass();
}

