/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Vector3D;
import ru.woesss.j2me.micro3d.MathUtil;

public class AffineTransform {
    public static final int M00 = 0;
    public static final int M01 = 1;
    public static final int M02 = 2;
    public static final int M03 = 3;
    public static final int M10 = 4;
    public static final int M11 = 5;
    public static final int M12 = 6;
    public static final int M13 = 7;
    public static final int M20 = 8;
    public static final int M21 = 9;
    public static final int M22 = 10;
    public static final int M23 = 11;
    public static final int MAX_VALUE = Short.MAX_VALUE;
    public static final int MIN_VALUE = Short.MIN_VALUE;
    int m00;
    int m01;
    int m02;
    int m03;
    int m10;
    int m11;
    int m12;
    int m13;
    int m20;
    int m21;
    int m22;
    int m23;

    public AffineTransform() {
    }

    public AffineTransform(int[][] nArray) {
        this.set(nArray);
    }

    public int get(int n2) {
        switch (n2) {
            case 0: {
                return this.m00;
            }
            case 1: {
                return this.m01;
            }
            case 2: {
                return this.m02;
            }
            case 3: {
                return this.m03;
            }
            case 4: {
                return this.m10;
            }
            case 5: {
                return this.m11;
            }
            case 6: {
                return this.m12;
            }
            case 7: {
                return this.m13;
            }
            case 8: {
                return this.m20;
            }
            case 9: {
                return this.m21;
            }
            case 10: {
                return this.m22;
            }
            case 11: {
                return this.m23;
            }
        }
        throw new IllegalArgumentException();
    }

    public static AffineTransform getViewPointTransform(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        if (vector3D == null || vector3D2 == null || vector3D3 == null) {
            throw new NullPointerException();
        }
        AffineTransform affineTransform = new AffineTransform();
        int n2 = -vector3D.x;
        int n3 = -vector3D.y;
        int n4 = -vector3D.z;
        Vector3D vector3D4 = Vector3D.outerProduct(vector3D2, vector3D3);
        if (vector3D4.isZero()) {
            throw new IllegalArgumentException();
        }
        vector3D4.normalize();
        affineTransform.m00 = vector3D4.x;
        affineTransform.m01 = vector3D4.y;
        affineTransform.m02 = vector3D4.z;
        affineTransform.m03 = n2 * vector3D4.x + n3 * vector3D4.y + n4 * vector3D4.z + 2048 >> 12;
        vector3D4 = Vector3D.outerProduct(vector3D2, vector3D4);
        vector3D4.normalize();
        affineTransform.m10 = vector3D4.x;
        affineTransform.m11 = vector3D4.y;
        affineTransform.m12 = vector3D4.z;
        affineTransform.m13 = n2 * vector3D4.x + n3 * vector3D4.y + n4 * vector3D4.z + 2048 >> 12;
        vector3D4.set(vector3D2);
        vector3D4.normalize();
        affineTransform.m20 = vector3D4.x;
        affineTransform.m21 = vector3D4.y;
        affineTransform.m22 = vector3D4.z;
        affineTransform.m23 = n2 * vector3D4.x + n3 * vector3D4.y + n4 * vector3D4.z + 2048 >> 12;
        return affineTransform;
    }

    public void multiply(AffineTransform affineTransform) {
        this.mulA2(this, affineTransform);
    }

    public static AffineTransform multiply(AffineTransform affineTransform, AffineTransform affineTransform2) {
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.mulA2(affineTransform, affineTransform2);
        return affineTransform3;
    }

    public static void multiply(AffineTransform affineTransform, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        affineTransform.mulA2(affineTransform2, affineTransform3);
    }

    public void normalize() {
        if ((this.m00 & this.m01 & this.m02 & this.m10 & this.m11 & this.m12 & this.m20 & this.m21 & this.m22) == 0) {
            return;
        }
        Vector3D vector3D = new Vector3D(this.m00, this.m10, this.m20);
        vector3D.normalize();
        this.m00 = vector3D.x;
        this.m10 = vector3D.y;
        this.m20 = vector3D.z;
        Vector3D vector3D2 = new Vector3D(this.m01, this.m11, this.m21);
        vector3D2 = Vector3D.outerProduct(vector3D, vector3D2);
        vector3D2.normalize();
        this.m02 = vector3D2.x;
        this.m12 = vector3D2.y;
        this.m22 = vector3D2.z;
        vector3D2.outerProduct(vector3D);
        this.m01 = vector3D2.x >> 12;
        this.m11 = vector3D2.y >> 12;
        this.m21 = vector3D2.z >> 12;
    }

    public void rotateV(Vector3D vector3D, int n2) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        int n3 = vector3D.x;
        int n4 = vector3D.y;
        int n5 = vector3D.z;
        int n6 = MathUtil.iCos(n2);
        int n7 = MathUtil.iSin(n2);
        int n8 = n3 * n7 + 2048 >> 12;
        int n9 = n4 * n7 + 2048 >> 12;
        int n10 = n5 * n7 + 2048 >> 12;
        int n11 = 4096 - n6;
        int n12 = (n3 * n4 + 2048 >> 12) * n11 + 2048 >> 12;
        int n13 = (n4 * n5 + 2048 >> 12) * n11 + 2048 >> 12;
        int n14 = (n3 * n5 + 2048 >> 12) * n11 + 2048 >> 12;
        this.m00 = n6 + ((n3 * n3 + 2048 >> 12) * n11 + 2048 >> 12);
        this.m01 = n12 - n10;
        this.m02 = n14 + n9;
        this.m10 = n12 + n10;
        this.m11 = n6 + ((n4 * n4 + 2048 >> 12) * n11 + 2048 >> 12);
        this.m20 = n14 - n9;
        this.m12 = n13 - n8;
        this.m21 = n13 + n8;
        this.m22 = n6 + ((n5 * n5 + 2048 >> 12) * n11 + 2048 >> 12);
    }

    public void rotateX(int n2) {
        int n3 = MathUtil.iCos(n2);
        int n4 = MathUtil.iSin(n2);
        this.m00 = 4096;
        this.m01 = 0;
        this.m02 = 0;
        this.m10 = 0;
        this.m11 = n3;
        this.m12 = -n4;
        this.m20 = 0;
        this.m21 = n4;
        this.m22 = n3;
    }

    public void rotateY(int n2) {
        int n3 = MathUtil.iCos(n2);
        int n4 = MathUtil.iSin(n2);
        this.m00 = n3;
        this.m01 = 0;
        this.m02 = n4;
        this.m10 = 0;
        this.m11 = 4096;
        this.m12 = 0;
        this.m20 = -n4;
        this.m21 = 0;
        this.m22 = n3;
    }

    public void rotateZ(int n2) {
        int n3 = MathUtil.iCos(n2);
        int n4 = MathUtil.iSin(n2);
        this.m00 = n3;
        this.m01 = -n4;
        this.m02 = 0;
        this.m10 = n4;
        this.m11 = n3;
        this.m12 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 4096;
    }

    public void set(int[][] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (nArray.length < 3) {
            throw new IllegalArgumentException();
        }
        if (nArray[0].length < 4 || nArray[1].length < 4 || nArray[2].length < 4) {
            throw new IllegalArgumentException();
        }
        this.m00 = MathUtil.clamp(nArray[0][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m01 = MathUtil.clamp(nArray[0][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m02 = MathUtil.clamp(nArray[0][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m03 = MathUtil.clamp(nArray[0][3], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m10 = MathUtil.clamp(nArray[1][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m11 = MathUtil.clamp(nArray[1][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m12 = MathUtil.clamp(nArray[1][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m13 = MathUtil.clamp(nArray[1][3], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m20 = MathUtil.clamp(nArray[2][0], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m21 = MathUtil.clamp(nArray[2][1], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m22 = MathUtil.clamp(nArray[2][2], Short.MIN_VALUE, Short.MAX_VALUE);
        this.m23 = MathUtil.clamp(nArray[2][3], Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public void set(int n2, int n3) {
        switch (n2) {
            case 0: {
                this.m00 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 1: {
                this.m01 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 2: {
                this.m02 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 3: {
                this.m03 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 4: {
                this.m10 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 5: {
                this.m11 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 6: {
                this.m12 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 7: {
                this.m13 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 8: {
                this.m20 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 9: {
                this.m21 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 10: {
                this.m22 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case 11: {
                this.m23 = MathUtil.clamp(n3, Short.MIN_VALUE, Short.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setIdentity() {
        this.m00 = 4096;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = 4096;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = 4096;
        this.m23 = 0;
    }

    public Vector3D transformPoint(Vector3D vector3D) {
        if (vector3D == null) {
            throw new NullPointerException();
        }
        Vector3D vector3D2 = new Vector3D();
        vector3D2.x = (vector3D.x * this.m00 + vector3D.y * this.m01 + vector3D.z * this.m02 + 2048 >> 12) + this.m03;
        vector3D2.y = (vector3D.x * this.m10 + vector3D.y * this.m11 + vector3D.z * this.m12 + 2048 >> 12) + this.m13;
        vector3D2.z = (vector3D.x * this.m20 + vector3D.y * this.m21 + vector3D.z * this.m22 + 2048 >> 12) + this.m23;
        return vector3D2;
    }

    private void mulA2(AffineTransform affineTransform, AffineTransform affineTransform2) {
        int n2 = affineTransform.m00;
        int n3 = affineTransform.m01;
        int n4 = affineTransform.m02;
        int n5 = affineTransform.m10;
        int n6 = affineTransform.m11;
        int n7 = affineTransform.m12;
        int n8 = affineTransform.m20;
        int n9 = affineTransform.m21;
        int n10 = affineTransform.m22;
        int n11 = affineTransform2.m00;
        int n12 = affineTransform2.m01;
        int n13 = affineTransform2.m02;
        int n14 = affineTransform2.m03;
        int n15 = affineTransform2.m10;
        int n16 = affineTransform2.m11;
        int n17 = affineTransform2.m12;
        int n18 = affineTransform2.m13;
        int n19 = affineTransform2.m20;
        int n20 = affineTransform2.m21;
        int n21 = affineTransform2.m22;
        int n22 = affineTransform2.m23;
        this.m00 = n2 * n11 + n3 * n15 + n4 * n19 + 2048 >> 12;
        this.m01 = n2 * n12 + n3 * n16 + n4 * n20 + 2048 >> 12;
        this.m02 = n2 * n13 + n3 * n17 + n4 * n21 + 2048 >> 12;
        this.m03 = (n2 * n14 + n3 * n18 + n4 * n22 + 2048 >> 12) + affineTransform.m03;
        this.m10 = n5 * n11 + n6 * n15 + n7 * n19 + 2048 >> 12;
        this.m11 = n5 * n12 + n6 * n16 + n7 * n20 + 2048 >> 12;
        this.m12 = n5 * n13 + n6 * n17 + n7 * n21 + 2048 >> 12;
        this.m13 = (n5 * n14 + n6 * n18 + n7 * n22 + 2048 >> 12) + affineTransform.m13;
        this.m20 = n8 * n11 + n9 * n15 + n10 * n19 + 2048 >> 12;
        this.m21 = n8 * n12 + n9 * n16 + n10 * n20 + 2048 >> 12;
        this.m22 = n8 * n13 + n9 * n17 + n10 * n21 + 2048 >> 12;
        this.m23 = (n8 * n14 + n9 * n18 + n10 * n22 + 2048 >> 12) + affineTransform.m23;
    }
}

