/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledLayer
extends Layer {
    private int cellHeight;
    private int cellWidth;
    private int rows;
    private int columns;
    private int[][] cellMatrix;
    Image sourceImage;
    private int numberOfTiles;
    int[] tileSetX;
    int[] tileSetY;
    private int[] anim_to_static;
    private int numOfAnimTiles;

    public TiledLayer(int n2, int n3, Image image, int n4, int n5) {
        super(n2 < 1 || n4 < 1 ? -1 : n2 * n4, n3 < 1 || n5 < 1 ? -1 : n3 * n5);
        if (image.getWidth() % n4 != 0 || image.getHeight() % n5 != 0) {
            throw new IllegalArgumentException();
        }
        this.columns = n2;
        this.rows = n3;
        this.cellMatrix = new int[n3][n2];
        int n6 = image.getWidth() / n4 * (image.getHeight() / n5);
        this.createStaticSet(image, n6 + 1, n4, n5, true);
    }

    public int createAnimatedTile(int n2) {
        if (n2 < 0 || n2 >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        if (this.anim_to_static == null) {
            this.anim_to_static = new int[4];
            this.numOfAnimTiles = 1;
        } else if (this.numOfAnimTiles == this.anim_to_static.length) {
            int[] nArray = new int[this.anim_to_static.length * 2];
            System.arraycopy(this.anim_to_static, 0, nArray, 0, this.anim_to_static.length);
            this.anim_to_static = nArray;
        }
        this.anim_to_static[this.numOfAnimTiles] = n2;
        ++this.numOfAnimTiles;
        return -(this.numOfAnimTiles - 1);
    }

    public void setAnimatedTile(int n2, int n3) {
        if (n3 < 0 || n3 >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        n2 = -n2;
        if (this.anim_to_static == null || n2 <= 0 || n2 >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        this.anim_to_static[n2] = n3;
    }

    public int getAnimatedTile(int n2) {
        n2 = -n2;
        if (this.anim_to_static == null || n2 <= 0 || n2 >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.anim_to_static[n2];
    }

    public void setCell(int n2, int n3, int n4) {
        if (n2 < 0 || n2 >= this.columns || n3 < 0 || n3 >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (n4 > 0 ? n4 >= this.numberOfTiles : n4 < 0 && (this.anim_to_static == null || -n4 >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        this.cellMatrix[n3][n2] = n4;
    }

    public int getCell(int n2, int n3) {
        if (n2 < 0 || n2 >= this.columns || n3 < 0 || n3 >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        return this.cellMatrix[n3][n2];
    }

    public void fillCells(int n2, int n3, int n4, int n5, int n6) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= this.columns || n3 < 0 || n3 >= this.rows || n2 + n4 > this.columns || n3 + n5 > this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (n6 > 0 ? n6 >= this.numberOfTiles : n6 < 0 && (this.anim_to_static == null || -n6 >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            for (int i3 = n2; i3 < n2 + n4; ++i3) {
                this.cellMatrix[i2][i3] = n6;
            }
        }
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setStaticTileSet(Image image, int n2, int n3) {
        if (n2 < 1 || n3 < 1 || image.getWidth() % n2 != 0 || image.getHeight() % n3 != 0) {
            throw new IllegalArgumentException();
        }
        this.setWidth(this.columns * n2);
        this.setHeight(this.rows * n3);
        int n4 = image.getWidth() / n2 * (image.getHeight() / n3);
        if (n4 >= this.numberOfTiles - 1) {
            this.createStaticSet(image, n4 + 1, n2, n3, true);
        } else {
            this.createStaticSet(image, n4 + 1, n2, n3, false);
        }
    }

    @Override
    public final void paint(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            int n7 = this.columns;
            int n8 = 0;
            int n9 = this.rows;
            int n10 = (graphics.getClipX() - this.x) / this.cellWidth;
            if (n10 > 0) {
                n6 = n10;
            }
            if ((n10 = ((n5 = this.x + this.columns * this.cellWidth) - (n4 = graphics.getClipX() + graphics.getClipWidth())) / this.cellWidth) > 0) {
                n7 -= n10;
            }
            if ((n10 = (graphics.getClipY() - this.y) / this.cellHeight) > 0) {
                n8 = n10;
            }
            if ((n10 = ((n3 = this.y + this.rows * this.cellHeight) - (n2 = graphics.getClipY() + graphics.getClipHeight())) / this.cellHeight) > 0) {
                n9 -= n10;
            }
            int n11 = 0;
            int n12 = this.y + n8 * this.cellHeight;
            int n13 = n8;
            while (n13 < n9) {
                int n14 = this.x + n6 * this.cellWidth;
                int n15 = n6;
                while (n15 < n7) {
                    n11 = this.cellMatrix[n13][n15];
                    if (n11 != 0) {
                        if (n11 < 0) {
                            n11 = this.getAnimatedTile(n11);
                        }
                        graphics.drawRegion(this.sourceImage, this.tileSetX[n11], this.tileSetY[n11], this.cellWidth, this.cellHeight, 0, n14, n12, 20);
                    }
                    ++n15;
                    n14 += this.cellWidth;
                }
                ++n13;
                n12 += this.cellHeight;
            }
        }
    }

    private void createStaticSet(Image image, int n2, int n3, int n4, boolean bl2) {
        int n5;
        this.cellWidth = n3;
        this.cellHeight = n4;
        int n6 = image.getWidth();
        int n7 = image.getHeight();
        this.sourceImage = image;
        this.numberOfTiles = n2;
        this.tileSetX = new int[this.numberOfTiles];
        this.tileSetY = new int[this.numberOfTiles];
        if (!bl2) {
            this.rows = 0;
            while (this.rows < this.cellMatrix.length) {
                n5 = this.cellMatrix[this.rows].length;
                this.columns = 0;
                while (this.columns < n5) {
                    this.cellMatrix[this.rows][this.columns] = 0;
                    ++this.columns;
                }
                ++this.rows;
            }
            this.anim_to_static = null;
        }
        n5 = 1;
        for (int i2 = 0; i2 < n7; i2 += n4) {
            for (int i3 = 0; i3 < n6; i3 += n3) {
                this.tileSetX[n5] = i3;
                this.tileSetY[n5] = i2;
                ++n5;
            }
        }
    }
}

