/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.misc.NativeMem;
import emulator.Emulator;
import emulator.graphics2D.awt.ImageAWT;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ExtendedImage
extends NativeMem {
    private final boolean hasAlpha;
    private Image image;

    public ExtendedImage(Image image) {
        if (image == null || image.getWidth() % 8 != 0) {
            throw new IllegalArgumentException("ExtendedImage: width is not divisible by 8");
        }
        this.image = image;
        this.hasAlpha = image.getImpl().isTransparent();
    }

    public void blitToScreen(int n2, int n3) {
        Displayable displayable = Display.getDisplay(null).getCurrent();
        if (displayable instanceof Canvas) {
            Graphics graphics = new Graphics(Emulator.getEmulator().getScreen().getBackBufferImage(), Emulator.getEmulator().getScreen().getXRayScreenImage());
            graphics.drawImage(this.image, n2, n3, 0);
            Emulator.getEventQueue().c();
        }
    }

    public void clear(byte by2) {
        this.image.getImpl().fill(by2 == 0 ? -1 : -16777216);
    }

    public Image getImage() {
        return this.image;
    }

    public int getPixel(int n2, int n3) {
        int n4 = this.image.getImpl().getRGB(n2, n3);
        if (this.hasAlpha) {
            if ((n4 & 0xFF000000) != -16777216) {
                return 0;
            }
            return (n4 & 0xFFFFFF) == 0xFFFFFF ? 1 : 2;
        }
        return (n4 & 0xFFFFFF) == 0xFFFFFF ? 0 : 1;
    }

    public void getPixelBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n4 * n5];
        this.image.getRGB(nArray, 0, n4, n2, n3, n4, n5);
        if (this.hasAlpha) {
            int n6 = nArray.length / 4;
            int n7 = 0;
            for (int i2 = 0; i2 < n6; ++i2) {
                int n8 = 0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n9;
                    n8 <<= 2;
                    if (((n9 = nArray[n7++]) & 0xFF000000) != -16777216) continue;
                    if ((n9 & 0xFFFFFF) == 0xFFFFFF) {
                        n8 |= 1;
                        continue;
                    }
                    n8 |= 2;
                }
                byArray[i2] = (byte)n8;
            }
        } else {
            int n10 = nArray.length / 8;
            int n11 = 0;
            for (int i4 = 0; i4 < n10; ++i4) {
                int n12 = 0;
                for (int i5 = 0; i5 < 8; ++i5) {
                    n12 <<= 1;
                    if ((nArray[n11++] & 0xFFFFFF) == 0xFFFFFF) continue;
                    n12 |= 1;
                }
                byArray[i4] = (byte)n12;
            }
        }
    }

    public void setPixel(int n2, int n3, byte by2) {
        if (!this.hasAlpha) {
            this.image.getImpl().setRGB(n2, n3, by2 == 1 ? 0 : -1);
            return;
        }
        if (by2 == 0) {
            this.image.getImpl().setRGB(n2, n3, 0);
        } else {
            this.image.getImpl().setRGB(n2, n3, by2 == 1 ? -1 : 0);
        }
    }

    public void setPixels(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = this.image.getWidth();
        int n7 = this.image.getHeight();
        int n8 = n2 + n4;
        int n9 = n3 + n5;
        if (n2 >= n6 || n8 <= 0 || n3 >= n7 || n9 <= 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n8 > n6) {
            n8 = n6;
        }
        if (n9 > n7) {
            n9 = n7;
        }
        n4 = n8 - n2;
        n5 = n9 - n3;
        int[] nArray = new int[n4 * n5];
        if (this.hasAlpha) {
            int n10 = Math.min(byArray.length, nArray.length / 4);
            int n11 = 0;
            for (int i2 = 0; i2 < n10; ++i2) {
                byte by2 = byArray[i2];
                for (int i3 = 3; i3 >= 0; --i3) {
                    int n12 = by2 >> i3 & 3;
                    if (n12 == 0) {
                        nArray[n11++] = 0;
                        continue;
                    }
                    nArray[n11++] = n12 == 1 ? -1 : 0;
                }
            }
        } else {
            int n13 = Math.min(byArray.length, nArray.length / 8);
            int n14 = 0;
            for (int i4 = 0; i4 < n13; ++i4) {
                byte by3 = byArray[i4];
                for (int i5 = 7; i5 >= 0; --i5) {
                    int n15 = by3 >> i5 & 1;
                    nArray[n14++] = n15 == 1 ? 0 : -1;
                }
            }
        }
        ((ImageAWT)this.image.getImpl()).getBufferedImage().setRGB(n2, n3, n4, n5, nArray, 0, n4);
    }
}

