/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ConnectionPoint;
import com.sun.jna.platform.win32.COM.ConnectionPointContainer;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.util.ComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.IConnectionPoint;
import com.sun.jna.platform.win32.COM.util.IConnectionPointContainer;
import com.sun.jna.platform.win32.COM.util.IRawDispatchHandle;
import com.sun.jna.platform.win32.COM.util.IUnknown;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.COM.util.annotation.ComProperty;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Guid$IID;
import com.sun.jna.platform.win32.Guid$REFIID;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OaIdl$DISPID;
import com.sun.jna.platform.win32.OaIdl$DISPIDByReference;
import com.sun.jna.platform.win32.OaIdl$EXCEPINFO$ByReference;
import com.sun.jna.platform.win32.OleAuto$DISPPARAMS$ByReference;
import com.sun.jna.platform.win32.Variant$VARIANT;
import com.sun.jna.platform.win32.Variant$VARIANT$ByReference;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinDef$WORD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ProxyObject
implements IConnectionPoint,
com.sun.jna.platform.win32.COM.util.IDispatch,
IRawDispatchHandle,
InvocationHandler {
    private long unknownId = -1L;
    private final Class theInterface;
    private final ObjectFactory factory;
    private final IDispatch rawDispatch;

    public ProxyObject(Class clazz, IDispatch iDispatch, ObjectFactory objectFactory) {
        this.rawDispatch = iDispatch;
        this.theInterface = clazz;
        this.factory = objectFactory;
        int n2 = this.rawDispatch.AddRef();
        this.getUnknownId();
        objectFactory.register(this);
    }

    private long getUnknownId() {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (-1L == this.unknownId) {
            try {
                PointerByReference pointerByReference = new PointerByReference();
                Thread thread = Thread.currentThread();
                String string = thread.getName();
                Guid$IID guid$IID = com.sun.jna.platform.win32.COM.IUnknown.IID_IUNKNOWN;
                WinNT$HRESULT winNT$HRESULT = this.getRawDispatch().QueryInterface(new Guid$REFIID(guid$IID), pointerByReference);
                if (!WinNT.S_OK.equals(winNT$HRESULT)) {
                    String string2 = Kernel32Util.formatMessage(winNT$HRESULT);
                    throw new COMException("getUnknownId: " + string2, winNT$HRESULT);
                }
                Dispatch dispatch = new Dispatch(pointerByReference.getValue());
                this.unknownId = Pointer.nativeValue(dispatch.getPointer());
                int n2 = dispatch.Release();
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException instanceof COMException) {
                    throw runtimeException;
                }
                throw new COMException("Error occured when trying get Unknown Id ", runtimeException);
            }
        }
        return this.unknownId;
    }

    protected void finalize() {
        this.dispose();
        super.finalize();
    }

    public synchronized void dispose() {
        if (((Dispatch)this.rawDispatch).getPointer() != Pointer.NULL) {
            this.rawDispatch.Release();
            ((Dispatch)this.rawDispatch).setPointer(Pointer.NULL);
            this.factory.unregister(this);
        }
    }

    @Override
    public IDispatch getRawDispatch() {
        return this.rawDispatch;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof ProxyObject) {
            ProxyObject proxyObject = (ProxyObject)object;
            return this.getUnknownId() == proxyObject.getUnknownId();
        }
        if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            if (invocationHandler instanceof ProxyObject) {
                try {
                    ProxyObject proxyObject = (ProxyObject)invocationHandler;
                    return this.getUnknownId() == proxyObject.getUnknownId();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        long l2 = this.getUnknownId();
        return (int)(l2 >>> 32 & 0xFFFFFFFFFFFFFFFFL) + (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    public String toString() {
        return this.theInterface.getName() + "{unk=" + this.hashCode() + "}";
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        boolean bl2;
        boolean bl3 = bl2 = method.getAnnotation(ComMethod.class) != null || method.getAnnotation(ComProperty.class) != null;
        if (!bl2 && (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(IRawDispatchHandle.class) || method.getDeclaringClass().equals(IUnknown.class) || method.getDeclaringClass().equals(com.sun.jna.platform.win32.COM.util.IDispatch.class) || method.getDeclaringClass().equals(IConnectionPoint.class))) {
            try {
                return method.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
        Class<?> clazz = method.getReturnType();
        boolean bl4 = Void.TYPE.equals(clazz);
        ComProperty comProperty = method.getAnnotation(ComProperty.class);
        if (null != comProperty) {
            int n2 = comProperty.dispId();
            if (bl4) {
                if (n2 != -1) {
                    this.setProperty(new OaIdl$DISPID(n2), objectArray[0]);
                    return null;
                }
                String string = this.getMutatorName(method, comProperty);
                this.setProperty(string, objectArray[0]);
                return null;
            }
            if (n2 != -1) {
                return this.getProperty(clazz, new OaIdl$DISPID(n2), objectArray);
            }
            String string = this.getAccessorName(method, comProperty);
            return this.getProperty(clazz, string, objectArray);
        }
        ComMethod comMethod = method.getAnnotation(ComMethod.class);
        if (null != comMethod) {
            Object[] objectArray2 = this.unfoldWhenVarargs(method, objectArray);
            int n3 = comMethod.dispId();
            if (n3 != -1) {
                return this.invokeMethod(clazz, new OaIdl$DISPID(n3), objectArray2);
            }
            String string = this.getMethodName(method, comMethod);
            return this.invokeMethod(clazz, string, objectArray2);
        }
        return null;
    }

    private ConnectionPoint fetchRawConnectionPoint(Guid$IID guid$IID) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        IConnectionPointContainer iConnectionPointContainer = (IConnectionPointContainer)this.queryInterface(IConnectionPointContainer.class);
        Dispatch dispatch = (Dispatch)iConnectionPointContainer.getRawDispatch();
        ConnectionPointContainer connectionPointContainer = new ConnectionPointContainer(dispatch.getPointer());
        Guid$REFIID guid$REFIID = new Guid$REFIID(guid$IID.getPointer());
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = connectionPointContainer.FindConnectionPoint(guid$REFIID, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        ConnectionPoint connectionPoint = new ConnectionPoint(pointerByReference.getValue());
        return connectionPoint;
    }

    @Override
    public IComEventCallbackCookie advise(Class clazz, IComEventCallbackListener iComEventCallbackListener) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            ComInterface comInterface = clazz.getAnnotation(ComInterface.class);
            if (null == comInterface) {
                throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
            }
            Guid$IID guid$IID = this.getIID(comInterface);
            ConnectionPoint connectionPoint = this.fetchRawConnectionPoint(guid$IID);
            IDispatchCallback iDispatchCallback = this.factory.createDispatchCallback(clazz, iComEventCallbackListener);
            iComEventCallbackListener.setDispatchCallbackListener(iDispatchCallback);
            WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference();
            WinNT$HRESULT winNT$HRESULT = connectionPoint.Advise(iDispatchCallback, winDef$DWORDByReference);
            int n2 = connectionPoint.Release();
            COMUtils.checkRC(winNT$HRESULT);
            return new ComEventCallbackCookie(winDef$DWORDByReference.getValue());
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof COMException) {
                throw runtimeException;
            }
            throw new COMException("Error occured in advise when trying to connect the listener " + iComEventCallbackListener, runtimeException);
        }
    }

    @Override
    public void unadvise(Class clazz, IComEventCallbackCookie iComEventCallbackCookie) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            ComInterface comInterface = clazz.getAnnotation(ComInterface.class);
            if (null == comInterface) {
                throw new COMException("unadvise: Interface must define a value for iid via the ComInterface annotation");
            }
            Guid$IID guid$IID = this.getIID(comInterface);
            ConnectionPoint connectionPoint = this.fetchRawConnectionPoint(guid$IID);
            WinNT$HRESULT winNT$HRESULT = connectionPoint.Unadvise(((ComEventCallbackCookie)iComEventCallbackCookie).getValue());
            connectionPoint.Release();
            COMUtils.checkRC(winNT$HRESULT);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof COMException) {
                throw runtimeException;
            }
            throw new COMException("Error occured in unadvise when trying to disconnect the listener from " + this, runtimeException);
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        OaIdl$DISPID oaIdl$DISPID = this.resolveDispId(this.getRawDispatch(), string);
        this.setProperty(oaIdl$DISPID, object);
    }

    @Override
    public void setProperty(OaIdl$DISPID oaIdl$DISPID, Object object) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Variant$VARIANT variant$VARIANT = Convert.toVariant(object);
        WinNT$HRESULT winNT$HRESULT = this.oleMethod(4, null, this.getRawDispatch(), oaIdl$DISPID, variant$VARIANT);
        Convert.free(variant$VARIANT, object);
        COMUtils.checkRC(winNT$HRESULT);
    }

    @Override
    public Object getProperty(Class clazz, String string, Object ... objectArray) {
        OaIdl$DISPID oaIdl$DISPID = this.resolveDispId(this.getRawDispatch(), string);
        return this.getProperty(clazz, oaIdl$DISPID, objectArray);
    }

    @Override
    public Object getProperty(Class clazz, OaIdl$DISPID oaIdl$DISPID, Object ... objectArray) {
        Variant$VARIANT[] variant$VARIANTArray = null == objectArray ? new Variant$VARIANT[]{} : new Variant$VARIANT[objectArray.length];
        for (int i2 = 0; i2 < variant$VARIANTArray.length; ++i2) {
            variant$VARIANTArray[i2] = Convert.toVariant(objectArray[i2]);
        }
        Variant$VARIANT$ByReference variant$VARIANT$ByReference = new Variant$VARIANT$ByReference();
        WinNT$HRESULT winNT$HRESULT = this.oleMethod(2, variant$VARIANT$ByReference, this.getRawDispatch(), oaIdl$DISPID, variant$VARIANTArray);
        for (int i3 = 0; i3 < variant$VARIANTArray.length; ++i3) {
            Convert.free(variant$VARIANTArray[i3], objectArray[i3]);
        }
        COMUtils.checkRC(winNT$HRESULT);
        return Convert.toJavaObject(variant$VARIANT$ByReference, clazz, this.factory, false, true);
    }

    @Override
    public Object invokeMethod(Class clazz, String string, Object ... objectArray) {
        OaIdl$DISPID oaIdl$DISPID = this.resolveDispId(this.getRawDispatch(), string);
        return this.invokeMethod(clazz, oaIdl$DISPID, objectArray);
    }

    @Override
    public Object invokeMethod(Class clazz, OaIdl$DISPID oaIdl$DISPID, Object ... objectArray) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        Variant$VARIANT[] variant$VARIANTArray = null == objectArray ? new Variant$VARIANT[]{} : new Variant$VARIANT[objectArray.length];
        for (int i2 = 0; i2 < variant$VARIANTArray.length; ++i2) {
            variant$VARIANTArray[i2] = Convert.toVariant(objectArray[i2]);
        }
        Variant$VARIANT$ByReference variant$VARIANT$ByReference = new Variant$VARIANT$ByReference();
        WinNT$HRESULT winNT$HRESULT = this.oleMethod(1, variant$VARIANT$ByReference, this.getRawDispatch(), oaIdl$DISPID, variant$VARIANTArray);
        for (int i3 = 0; i3 < variant$VARIANTArray.length; ++i3) {
            Convert.free(variant$VARIANTArray[i3], objectArray[i3]);
        }
        COMUtils.checkRC(winNT$HRESULT);
        return Convert.toJavaObject(variant$VARIANT$ByReference, clazz, this.factory, false, true);
    }

    private Object[] unfoldWhenVarargs(Method method, Object[] objectArray) {
        if (null == objectArray) {
            return null;
        }
        if (objectArray.length == 0 || !method.isVarArgs() || !(objectArray[objectArray.length - 1] instanceof Object[])) {
            return objectArray;
        }
        Object[] objectArray2 = (Object[])objectArray[objectArray.length - 1];
        Object[] objectArray3 = new Object[objectArray.length - 1 + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length - 1);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length - 1, objectArray2.length);
        return objectArray3;
    }

    @Override
    public Object queryInterface(Class clazz) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        try {
            ComInterface comInterface = clazz.getAnnotation(ComInterface.class);
            if (null == comInterface) {
                throw new COMException("queryInterface: Interface must define a value for iid via the ComInterface annotation");
            }
            Guid$IID guid$IID = this.getIID(comInterface);
            PointerByReference pointerByReference = new PointerByReference();
            WinNT$HRESULT winNT$HRESULT = this.getRawDispatch().QueryInterface(new Guid$REFIID(guid$IID), pointerByReference);
            if (WinNT.S_OK.equals(winNT$HRESULT)) {
                Dispatch dispatch = new Dispatch(pointerByReference.getValue());
                Object object = this.factory.createProxy(clazz, dispatch);
                int n2 = dispatch.Release();
                return object;
            }
            String string = Kernel32Util.formatMessage(winNT$HRESULT);
            throw new COMException("queryInterface: " + string, winNT$HRESULT);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof COMException) {
                throw runtimeException;
            }
            throw new COMException("Error occured when trying to query for interface " + clazz.getName(), runtimeException);
        }
    }

    private Guid$IID getIID(ComInterface comInterface) {
        String string = comInterface.iid();
        if (null != string && !string.isEmpty()) {
            return new Guid$IID(string);
        }
        throw new COMException("ComInterface must define a value for iid");
    }

    private String getAccessorName(Method method, ComProperty comProperty) {
        if (comProperty.name().isEmpty()) {
            String string = method.getName();
            if (string.startsWith("get")) {
                return string.replaceFirst("get", "");
            }
            throw new RuntimeException("Property Accessor name must start with 'get', or set the anotation 'name' value");
        }
        return comProperty.name();
    }

    private String getMutatorName(Method method, ComProperty comProperty) {
        if (comProperty.name().isEmpty()) {
            String string = method.getName();
            if (string.startsWith("set")) {
                return string.replaceFirst("set", "");
            }
            throw new RuntimeException("Property Mutator name must start with 'set', or set the anotation 'name' value");
        }
        return comProperty.name();
    }

    private String getMethodName(Method method, ComMethod comMethod) {
        if (comMethod.name().isEmpty()) {
            String string = method.getName();
            return string;
        }
        return comMethod.name();
    }

    protected OaIdl$DISPID resolveDispId(String string) {
        return this.resolveDispId(this.getRawDispatch(), string);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, String string, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, string, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, oaIdl$DISPID, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, String string) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, string, (Variant$VARIANT[])null);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, OaIdl$DISPID oaIdl$DISPID) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, oaIdl$DISPID, (Variant$VARIANT[])null);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, String string, Variant$VARIANT[] variant$VARIANTArray) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, this.resolveDispId(string), variant$VARIANTArray);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT[] variant$VARIANTArray) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, this.getRawDispatch(), oaIdl$DISPID, variant$VARIANTArray);
    }

    protected OaIdl$DISPID resolveDispId(IDispatch iDispatch, String string) {
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        WString[] wStringArray = new WString[]{new WString(string)};
        OaIdl$DISPIDByReference oaIdl$DISPIDByReference = new OaIdl$DISPIDByReference();
        WinNT$HRESULT winNT$HRESULT = iDispatch.GetIDsOfNames(new Guid$REFIID(Guid.IID_NULL), wStringArray, 1, this.factory.getLCID(), oaIdl$DISPIDByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return oaIdl$DISPIDByReference.getValue();
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, String string, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, iDispatch, string, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT variant$VARIANT) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, iDispatch, oaIdl$DISPID, new Variant$VARIANT[]{variant$VARIANT});
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, String string) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, iDispatch, string, (Variant$VARIANT[])null);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, iDispatch, oaIdl$DISPID, (Variant$VARIANT[])null);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, String string, Variant$VARIANT[] variant$VARIANTArray) {
        return this.oleMethod(n2, variant$VARIANT$ByReference, iDispatch, this.resolveDispId(iDispatch, string), variant$VARIANTArray);
    }

    protected WinNT$HRESULT oleMethod(int n2, Variant$VARIANT$ByReference variant$VARIANT$ByReference, IDispatch iDispatch, OaIdl$DISPID oaIdl$DISPID, Variant$VARIANT[] variant$VARIANTArray) {
        int n3;
        assert (COMUtils.comIsInitialized()) : "COM not initialized";
        if (iDispatch == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        int n4 = 0;
        Variant$VARIANT[] variant$VARIANTArray2 = null;
        OleAuto$DISPPARAMS$ByReference oleAuto$DISPPARAMS$ByReference = new OleAuto$DISPPARAMS$ByReference();
        OaIdl$EXCEPINFO$ByReference oaIdl$EXCEPINFO$ByReference = new OaIdl$EXCEPINFO$ByReference();
        IntByReference intByReference = new IntByReference();
        if (variant$VARIANTArray != null && variant$VARIANTArray.length > 0) {
            n4 = variant$VARIANTArray.length;
            variant$VARIANTArray2 = new Variant$VARIANT[n4];
            n3 = n4;
            for (int i2 = 0; i2 < n4; ++i2) {
                variant$VARIANTArray2[i2] = variant$VARIANTArray[--n3];
            }
        }
        if (n2 == 4) {
            oleAuto$DISPPARAMS$ByReference.setRgdispidNamedArgs(new OaIdl$DISPID[]{OaIdl.DISPID_PROPERTYPUT});
        }
        n3 = n2 == 1 || n2 == 2 ? 3 : n2;
        if (n4 > 0) {
            oleAuto$DISPPARAMS$ByReference.setArgs(variant$VARIANTArray2);
            oleAuto$DISPPARAMS$ByReference.write();
        }
        WinNT$HRESULT winNT$HRESULT = iDispatch.Invoke(oaIdl$DISPID, new Guid$REFIID(Guid.IID_NULL), this.factory.getLCID(), new WinDef$WORD((long)n3), oleAuto$DISPPARAMS$ByReference, variant$VARIANT$ByReference, oaIdl$EXCEPINFO$ByReference, intByReference);
        COMUtils.checkRC(winNT$HRESULT, oaIdl$EXCEPINFO$ByReference, intByReference);
        return winNT$HRESULT;
    }
}

