/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.awt;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class AWTImageUtils {
    public static BufferedImage resizeProportional(BufferedImage bufferedImage, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        if (n2 == n4 && n3 == n5) {
            return bufferedImage;
        }
        double d2 = (double)n2 / (double)n4;
        double d3 = (double)n3 / (double)n5;
        double d4 = Math.min(d2, d3);
        int n6 = (int)((double)n4 * d4);
        int n7 = (int)((double)n5 * d4);
        return AWTImageUtils.resize(bufferedImage, n6, n7);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n2, int n3) {
        if (n2 == -1) {
            n2 = (int)((double)bufferedImage.getWidth() / (double)bufferedImage.getHeight() * (double)n3);
        }
        try {
            BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }
}

