/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics2D.awt;

import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.Graphics2DAWT;
import emulator.graphics2D.b;
import emulator.graphics2D.f;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ImageAWT
implements IImage {
    private BufferedImage a;
    private Graphics2DAWT a;
    private Graphics2D a;
    private int[] a;

    public ImageAWT(byte[] byArray) {
        block3: {
            try {
                this.a = f.b(new ImageData((InputStream)new ByteArrayInputStream(byArray)));
            }
            catch (SWTException sWTException) {
                if (!"Invalid image".equals(sWTException.getMessage()) && !"Unsupported or unrecognized format".equals(sWTException.getMessage())) {
                    throw sWTException;
                }
                this.a = ImageIO.read(new ByteArrayInputStream(byArray));
                if (this.a != null) break block3;
                throw new IOException();
            }
        }
    }

    public ImageAWT(BufferedImage bufferedImage) {
        this.a = bufferedImage;
    }

    public ImageAWT(int n2, int n3, boolean bl2, int n4) {
        this.a = new BufferedImage(n2, n3, bl2 ? 2 : 1);
        Graphics2D graphics2D = this.a = this.a.createGraphics();
        graphics2D.setColor(new Color(n4, bl2));
        graphics2D.fillRect(0, 0, n2, n3);
    }

    public final BufferedImage getBufferedImage() {
        return this.a;
    }

    @Override
    public final void copyToScreen(Object object, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GC gC = (GC)object;
        Image image = new Image(null, f.a(this.a));
        gC.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9);
        image.dispose();
    }

    @Override
    public boolean isTransparent() {
        return this.a.getType() == 2;
    }

    @Override
    public void fill(int n2) {
        Arrays.fill(this.a(), n2);
    }

    @Override
    public final void copyToScreen(Object object) {
        GC gC = (GC)object;
        Image image = new Image(null, f.a(this.a));
        gC.drawImage(image, 0, 0);
        image.dispose();
    }

    @Override
    public final b createGraphics() {
        this.a = new Graphics2DAWT(this.a);
        return this.a;
    }

    @Override
    public final b getGraphics() {
        return this.a;
    }

    @Override
    public final int getWidth() {
        return this.a.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.a.getHeight();
    }

    @Override
    public final int[] getData() {
        try {
            int[] nArray = this.a();
            if (!this.a.getColorModel().hasAlpha()) {
                int n2 = nArray.length - 1;
                while (n2 >= 0) {
                    int n3 = n2--;
                    nArray[n3] = nArray[n3] | 0xFF000000;
                }
            }
            return nArray;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            byte[] byArray = ((DataBufferByte)this.a.getRaster().getDataBuffer()).getData();
            int[] nArray = new int[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                nArray[i2] = ((byArray[i2++] & 0xFF) << 24) + ((byArray[i2++] & 0xFF) << 16) + ((byArray[i2++] & 0xFF) << 8) + (byArray[i2++] & 0xFF);
            }
            return nArray;
        }
    }

    @Override
    public final void setData(int[] nArray) {
        int[] nArray2 = this.a();
        if (nArray.length != nArray2.length) {
            return;
        }
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
    }

    @Override
    public final void setAlpha(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n6 == 0) {
            Graphics2D graphics2D = this.a;
            if (graphics2D == null) {
                graphics2D = this.a.createGraphics();
            }
            graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            graphics2D.fillRect(n2, n3, n4, n5);
            return;
        }
        int[] nArray = this.a != null ? this.a : ((DataBufferInt)this.a.getRaster().getDataBuffer()).getData();
        int[] nArray2 = new int[n4];
        for (n7 = 0; n7 < n4; ++n7) {
            nArray2[n7] = n6 << 24;
        }
        for (n7 = n3; n7 < n3 + n5; ++n7) {
            System.arraycopy(nArray2, 0, nArray, n2 + n7 * this.getWidth(), nArray2.length);
        }
    }

    @Override
    public final int getRGB(int n2, int n3) {
        return this.a.getRGB(n2, n3);
    }

    @Override
    public void setRGB(int n2, int n3, int n4) {
        this.a.setRGB(n2, n3, n4 | 0xFF000000);
    }

    @Override
    public void setRGB(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        this.a.setRGB(n2, n3, n4, n5, nArray, n6, n7);
    }

    @Override
    public final void getRGB(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.a.getRGB(n4, n5, n6, n7, nArray, n2, n3);
    }

    @Override
    public final void saveToFile(String string) {
        try {
            ImageIO.write((RenderedImage)this.a, "png", new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public final void copyToClipBoard() {
        f.a(this.a);
    }

    @Override
    public final void cloneImage(IImage iImage) {
        System.arraycopy(this.a(), 0, ((ImageAWT)iImage).a(), 0, this.a.length);
    }

    @Override
    public void cloneImage(IImage iImage, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = ((ImageAWT)iImage).a;
        if (graphics2D == null) {
            graphics2D = ((ImageAWT)iImage).a != null ? ((ImageAWT)iImage).a.a : (((ImageAWT)iImage).a = this.a.createGraphics());
        }
        graphics2D.drawImage(this.a, n2, n3, n2 + n4, n3 + n5, n2, n3, n2 + n4, n3 + n5, null);
    }

    @Override
    public void copyImage(b b2, int n2, int n3, int n4, int n5, int n6, int n7) {
        ((Graphics2DAWT)b2).g().drawImage(this.a, n6, n7, n6 + n4, n7 + n5, n2, n3, n2 + n4, n3 + n5, null);
    }

    private int[] a() {
        if (this.a == null) {
            this.a = ((DataBufferInt)this.a.getRaster().getDataBuffer()).getData();
        }
        return this.a;
    }

    @Override
    public int size() {
        DataBuffer dataBuffer = this.a.getRaster().getDataBuffer();
        int n2 = dataBuffer.getSize();
        if (dataBuffer instanceof DataBufferInt) {
            n2 *= 4;
        }
        return n2;
    }

    @Override
    public Object getNative() {
        return this.getBufferedImage();
    }
}

