/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.egl;

import emulator.graphics3D.egl.EGL10Impl;
import emulator.graphics3D.egl.GL10Impl;
import emulator.graphics3D.egl.GLConfiguration;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL11Ext;
import javax.microedition.khronos.opengles.GL11ExtensionPack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBMatrixPalette;
import org.lwjgl.opengl.ARBVertexBlend;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public final class GL11Impl
extends GL10Impl
implements javax.microedition.khronos.opengles.GL11,
GL11Ext,
GL11ExtensionPack {
    @Override
    public final synchronized boolean glIsBuffer(int n2) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL15.glIsBuffer(n2);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized boolean glIsEnabled(int n2) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glIsEnabled(n2);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized boolean glIsTexture(int n2) {
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL11.glIsTexture(n2);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glGenBuffers(int n2, int[] nArray, int n3) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        EGL10Impl.g3d.sync(() -> GL15.glGenBuffers(intBuffer));
        intBuffer.get(nArray, n3, n2);
    }

    @Override
    public final synchronized void glGenBuffers(int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glGenBuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteBuffers(int n2, int[] nArray, int n3) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        intBuffer.put(nArray, n3, n2);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL15.glDeleteBuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteBuffers(int n2, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glDeleteBuffers(intBuffer));
    }

    @Override
    public final synchronized void glBindBuffer(int n2, int n3) {
        EGL10Impl.g3d.sync(() -> GL15.glBindBuffer(n2, n3));
    }

    @Override
    public final synchronized void glBufferData(int n2, int n3, Buffer buffer, int n4) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n2, (ByteBuffer)buffer, n4));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n2, (ShortBuffer)buffer, n4));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n2, (IntBuffer)buffer, n4));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferData(n2, (FloatBuffer)buffer, n4));
        }
    }

    @Override
    public final synchronized void glBufferSubData(int n2, int n3, int n4, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n2, (long)n3, (ByteBuffer)buffer));
            return;
        }
        if (buffer instanceof ShortBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n2, (long)n3, (ShortBuffer)buffer));
            return;
        }
        if (buffer instanceof IntBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n2, (long)n3, (IntBuffer)buffer));
            return;
        }
        if (buffer instanceof FloatBuffer) {
            EGL10Impl.g3d.sync(() -> GL15.glBufferSubData(n2, (long)n3, (FloatBuffer)buffer));
        }
    }

    @Override
    public final synchronized void glGetBufferParameteriv(int n2, int n3, int[] nArray, int n4) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n3);
        intBuffer.put(nArray, n4, GLConfiguration.method769());
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL15.glGetBufferParameteriv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glGetBufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL15.glGetBufferParameteriv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glColorPointer(int n2, int n3, int n4, int n5) {
        EGL10Impl.g3d.sync(() -> GL11.glColorPointer(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glNormalPointer(int n2, int n3, int n4) {
        EGL10Impl.g3d.sync(() -> GL11.glNormalPointer(n2, n3, n4));
    }

    @Override
    public final synchronized void glTexCoordPointer(int n2, int n3, int n4, int n5) {
        EGL10Impl.g3d.sync(() -> GL11.glTexCoordPointer(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glVertexPointer(int n2, int n3, int n4, int n5) {
        EGL10Impl.g3d.sync(() -> GL11.glVertexPointer(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glDrawElements(int n2, int n3, int n4, int n5) {
        EGL10Impl.g3d.sync(() -> GL11.glDrawElements(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glClipPlanef(int n2, float[] fArray, int n3) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put(fArray[n3]);
        doubleBuffer.put(fArray[n3 + 1]);
        doubleBuffer.put(fArray[n3 + 2]);
        doubleBuffer.put(fArray[n3 + 3]);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n2, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanef(int n2, FloatBuffer floatBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.put(floatBuffer.get());
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n2, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanex(int n2, int[] nArray, int n3) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put((float)nArray[n3] / 65536.0f);
        doubleBuffer.put((float)nArray[n3 + 1] / 65536.0f);
        doubleBuffer.put((float)nArray[n3 + 2] / 65536.0f);
        doubleBuffer.put((float)nArray[n3 + 3] / 65536.0f);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n2, doubleBuffer));
    }

    @Override
    public final synchronized void glClipPlanex(int n2, IntBuffer intBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.put((float)intBuffer.get() / 65536.0f);
        doubleBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glClipPlane(n2, doubleBuffer));
    }

    @Override
    public final synchronized void glGetClipPlanef(int n2, float[] fArray, int n3) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n2, doubleBuffer));
        fArray[n3] = (float)doubleBuffer.get(0);
        fArray[n3 + 1] = (float)doubleBuffer.get(1);
        fArray[n3 + 2] = (float)doubleBuffer.get(2);
        fArray[n3 + 3] = (float)doubleBuffer.get(3);
    }

    @Override
    public final synchronized void glGetClipPlanef(int n2, FloatBuffer floatBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n2, doubleBuffer));
        floatBuffer.put((float)doubleBuffer.get(0));
        floatBuffer.put((float)doubleBuffer.get(1));
        floatBuffer.put((float)doubleBuffer.get(2));
        floatBuffer.put((float)doubleBuffer.get(3));
    }

    @Override
    public final synchronized void glGetClipPlanex(int n2, int[] nArray, int n3) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n2, doubleBuffer));
        nArray[n3] = (int)(doubleBuffer.get(0) * 65536.0);
        nArray[n3 + 1] = (int)(doubleBuffer.get(1) * 65536.0);
        nArray[n3 + 2] = (int)(doubleBuffer.get(2) * 65536.0);
        nArray[n3 + 3] = (int)(doubleBuffer.get(3) * 65536.0);
    }

    @Override
    public final synchronized void glGetClipPlanex(int n2, IntBuffer intBuffer) {
        DoubleBuffer doubleBuffer = BufferUtils.createDoubleBuffer(4);
        EGL10Impl.g3d.sync(() -> GL11.glGetClipPlane(n2, doubleBuffer));
        intBuffer.put((int)(doubleBuffer.get(0) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(1) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(2) * 65536.0));
        intBuffer.put((int)(doubleBuffer.get(3) * 65536.0));
    }

    @Override
    public final synchronized void glGetFixedv(int n2, int[] nArray, int n3) {
        int n4 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n2, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetFixedv(int n2, IntBuffer intBuffer) {
        int n3 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n2, floatBuffer));
        for (int i2 = 0; i2 < n3; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetFloatv(int n2, float[] fArray, int n3) {
        int n4 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n2, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            fArray[n3 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetFloatv(int n2, FloatBuffer floatBuffer) {
        int n3 = GLConfiguration.method768(n2);
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(16);
        EGL10Impl.g3d.sync(() -> GL11.glGetFloatv(n2, floatBuffer2));
        for (int i2 = 0; i2 < n3; ++i2) {
            floatBuffer.put(floatBuffer2.get(i2));
        }
    }

    @Override
    public final synchronized void glGetLightfv(int n2, int n3, float[] fArray, int n4) {
        int n5 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            fArray[n4 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetLightxv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[n4 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetLightxv(int n2, int n3, IntBuffer intBuffer) {
        int n4 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        EGL10Impl.g3d.sync(() -> GL11.glGetLightfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetMaterialfv(int n2, int n3, float[] fArray, int n4) {
        int n5 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            fArray[n4 + i2] = floatBuffer.get(i2);
        }
    }

    @Override
    public final synchronized void glGetMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetMaterialxv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[n4 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetMaterialxv(int n2, int n3, IntBuffer intBuffer) {
        int n4 = GLConfiguration.method768(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        EGL10Impl.g3d.sync(() -> GL11.glGetMaterialfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetPointerv(int n2, Buffer[] bufferArray) {
        if (bufferArray == null || bufferArray.length < 1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final synchronized void glGetTexEnvfv(int n2, int n3, float[] fArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n2, n3, floatBuffer));
        floatBuffer.get(fArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexEnvfv(int n2, int n3, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexEnviv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnviv(n2, n3, intBuffer));
        intBuffer.get(nArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnviv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glGetTexEnvxv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[n4 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexEnvxv(int n2, int n3, IntBuffer intBuffer) {
        int n4 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexEnvfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glGetTexParameterfv(int n2, int n3, float[] fArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n2, n3, floatBuffer));
        floatBuffer.get(fArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexParameteriv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameteriv(n2, n3, intBuffer));
        intBuffer.get(nArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameteriv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glGetTexParameterxv(int n2, int n3, int[] nArray, int n4) {
        int n5 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[n4 + i2] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexParameterxv(int n2, int n3, IntBuffer intBuffer) {
        int n4 = GLConfiguration.method775(n3);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexParameterfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glDrawTexsOES(short s2, short s3, short s4, short s5, short s6) {
        this.glDrawTexfOES(s2, s3, s4, s5, s6);
    }

    @Override
    public final synchronized void glDrawTexiOES(int n2, int n3, int n4, int n5, int n6) {
        this.glDrawTexfOES(n2, n3, n4, n5, n6);
    }

    @Override
    public final synchronized void glDrawTexfOES(float f2, float f3, float f4, float f5, float f6) {
        if (!GLConfiguration.OES_draw_texture) {
            throw new UnsupportedOperationException("OES_draw_texture extension not available");
        }
    }

    @Override
    public final synchronized void glDrawTexxOES(int n2, int n3, int n4, int n5, int n6) {
        this.glDrawTexfOES((float)n2 / 65536.0f, (float)n3 / 65536.0f, (float)n4 / 65536.0f, (float)n5 / 65536.0f, (float)n6 / 65536.0f);
    }

    @Override
    public final synchronized void glDrawTexsvOES(short[] sArray, int n2) {
        this.glDrawTexfOES(sArray[n2], sArray[n2 + 1], sArray[n2 + 2], sArray[n2 + 3], sArray[n2 + 4]);
    }

    @Override
    public final synchronized void glDrawTexsvOES(ShortBuffer shortBuffer) {
        short[] sArray = new short[5];
        shortBuffer.get(sArray);
        this.glDrawTexsvOES(sArray, 0);
    }

    @Override
    public final synchronized void glDrawTexivOES(int[] nArray, int n2) {
        this.glDrawTexfOES(nArray[n2], nArray[n2 + 1], nArray[n2 + 2], nArray[n2 + 3], nArray[n2 + 4]);
    }

    @Override
    public final synchronized void glDrawTexivOES(IntBuffer intBuffer) {
        int[] nArray = new int[5];
        intBuffer.get(nArray);
        this.glDrawTexivOES(nArray, 0);
    }

    @Override
    public final synchronized void glDrawTexxvOES(int[] nArray, int n2) {
        this.glDrawTexfOES((float)nArray[n2] / 65536.0f, (float)nArray[n2 + 1] / 65536.0f, (float)nArray[n2 + 2] / 65536.0f, (float)nArray[n2 + 3] / 65536.0f, (float)nArray[n2 + 4] / 65536.0f);
    }

    @Override
    public final synchronized void glDrawTexxvOES(IntBuffer intBuffer) {
        int[] nArray = new int[5];
        intBuffer.get(nArray);
        this.glDrawTexxvOES(nArray, 0);
    }

    @Override
    public final synchronized void glDrawTexfvOES(float[] fArray, int n2) {
        this.glDrawTexfOES(fArray[n2], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4]);
    }

    @Override
    public final synchronized void glDrawTexfvOES(FloatBuffer floatBuffer) {
        float[] fArray = new float[5];
        floatBuffer.get(fArray);
        this.glDrawTexfvOES(fArray, 0);
    }

    @Override
    public final synchronized void glCurrentPaletteMatrixOES(int n2) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        EGL10Impl.g3d.sync(() -> ARBMatrixPalette.glCurrentPaletteMatrixARB(n2));
    }

    @Override
    public final synchronized void glLoadPaletteFromModelViewMatrixOES() {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
    }

    @Override
    public final synchronized void glMatrixIndexPointerOES(int n2, int n3, int n4, Buffer buffer) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        EGL10Impl.g3d.sync(() -> ARBMatrixPalette.glMatrixIndexPointerARB(n2, n3, n4, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public final synchronized void glMatrixIndexPointerOES(int n2, int n3, int n4, int n5) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        EGL10Impl.g3d.sync(() -> ARBMatrixPalette.glMatrixIndexPointerARB(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glWeightPointerOES(int n2, int n3, int n4, Buffer buffer) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        EGL10Impl.g3d.sync(() -> ARBVertexBlend.glWeightPointerARB(n2, n3, n4, MemoryUtil.memAddress(buffer)));
    }

    @Override
    public final synchronized void glWeightPointerOES(int n2, int n3, int n4, int n5) {
        if (!GLConfiguration.OES_matrix_pallete) {
            throw new UnsupportedOperationException("OES_matrix_palette extension not available");
        }
        EGL10Impl.g3d.sync(() -> ARBVertexBlend.glWeightPointerARB(n2, n3, n4, n5));
    }

    private static void a() {
        if (!GLConfiguration.OES_texture_cube_map) {
            throw new UnsupportedOperationException("OES_texture_cube_map extension not available");
        }
    }

    @Override
    public final synchronized void glTexGenf(int n2, int n3, float f2) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenf(n2, n3, f2));
    }

    @Override
    public final synchronized void glTexGeni(int n2, int n3, int n4) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glTexGeni(n2, n3, n4));
    }

    @Override
    public final synchronized void glTexGenx(int n2, int n3, int n4) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenf(n2, n3, (float)n4 / 65536.0f));
    }

    @Override
    public final synchronized void glTexGenfv(int n2, int n3, float[] fArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        floatBuffer.put(fArray, n4, n5);
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glTexGenfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glTexGeniv(int n2, int n3, int[] nArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5);
        intBuffer.put(nArray, n4, n5);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGeniv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glTexGeniv(int n2, int n3, IntBuffer intBuffer) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glTexGeniv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glTexGenxv(int n2, int n3, int[] nArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        for (int i2 = 0; i2 < n5; ++i2) {
            floatBuffer.put((float)nArray[i2] / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glTexGenxv(int n2, int n3, IntBuffer intBuffer) {
        GL11Impl.a();
        int n4 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            floatBuffer.put((float)intBuffer.get() / 65536.0f);
        }
        floatBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL11.glTexGenfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexGenfv(int n2, int n3, float[] fArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n2, n3, floatBuffer));
        floatBuffer.get(fArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexGenfv(int n2, int n3, FloatBuffer floatBuffer) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n2, n3, floatBuffer));
    }

    @Override
    public final synchronized void glGetTexGeniv(int n2, int n3, int[] nArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGeniv(n2, n3, intBuffer));
        intBuffer.get(nArray, n4, n5);
    }

    @Override
    public final synchronized void glGetTexGeniv(int n2, int n3, IntBuffer intBuffer) {
        GL11Impl.a();
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGeniv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized void glGetTexGenxv(int n2, int n3, int[] nArray, int n4) {
        GL11Impl.a();
        int n5 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2 + n4] = (int)(floatBuffer.get(i2) * 65536.0f);
        }
    }

    @Override
    public final synchronized void glGetTexGenxv(int n2, int n3, IntBuffer intBuffer) {
        GL11Impl.a();
        int n4 = GLConfiguration.method771();
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(n4);
        EGL10Impl.g3d.sync(() -> GL11.glGetTexGenfv(n2, n3, floatBuffer));
        for (int i2 = 0; i2 < n4; ++i2) {
            intBuffer.put((int)(floatBuffer.get(i2) * 65536.0f));
        }
    }

    @Override
    public final synchronized void glBlendEquation(int n2) {
        if (!GLConfiguration.OES_blend_subtract) {
            throw new UnsupportedOperationException("OES_blend_subtract extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL14.glBlendEquation(n2));
    }

    @Override
    public final synchronized void glBlendFuncSeparate(int n2, int n3, int n4, int n5) {
        if (!GLConfiguration.OES_blend_func_separate) {
            throw new UnsupportedOperationException("OES_blend_func_separate extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL14.glBlendFuncSeparate(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glBlendEquationSeparate(int n2, int n3) {
        if (!GLConfiguration.OES_blend_equations_separate) {
            throw new UnsupportedOperationException("OES_blend_equations_separate extension not available");
        }
        EGL10Impl.g3d.sync(() -> GL20.glBlendEquationSeparate(n2, n3));
    }

    private void b() {
        if (!GLConfiguration.OES_framebuffer_object) {
            throw new UnsupportedOperationException("OES_framebuffer_object extension not available");
        }
    }

    @Override
    public final synchronized boolean glIsRenderbufferOES(int n2) {
        this.b();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glIsRenderbuffer(n2);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glBindRenderbufferOES(int n2, int n3) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glBindRenderbuffer(n2, n3));
    }

    @Override
    public final synchronized void glDeleteRenderbuffersOES(int n2, int[] nArray, int n3) {
        this.b();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        intBuffer.put(nArray, n3, n2);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL30.glDeleteRenderbuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteRenderbuffersOES(int n2, IntBuffer intBuffer) {
        this.b();
        int n3 = intBuffer.limit();
        intBuffer.limit(n2 + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glDeleteRenderbuffers(intBuffer));
        intBuffer.limit(n3);
    }

    @Override
    public final synchronized void glGenRenderbuffersOES(int n2, int[] nArray, int n3) {
        this.b();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        EGL10Impl.g3d.sync(() -> GL30.glGenRenderbuffers(intBuffer));
        intBuffer.get(nArray, n3, n2);
    }

    @Override
    public final synchronized void glGenRenderbuffersOES(int n2, IntBuffer intBuffer) {
        this.b();
        int n3 = intBuffer.limit();
        intBuffer.limit(n2 + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glGenRenderbuffers(intBuffer));
        intBuffer.limit(n3);
    }

    @Override
    public final synchronized void glRenderbufferStorageOES(int n2, int n3, int n4, int n5) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glRenderbufferStorage(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glGetRenderbufferParameterivOES(int n2, int n3, int[] nArray, int n4) {
        this.b();
        int n5 = 1;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n5);
        EGL10Impl.g3d.sync(() -> GL30.glGetRenderbufferParameteriv(n2, n3, intBuffer));
        intBuffer.get(nArray, n2, n5);
    }

    @Override
    public final synchronized void glGetRenderbufferParameterivOES(int n2, int n3, IntBuffer intBuffer) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glGetRenderbufferParameteriv(n2, n3, intBuffer));
    }

    @Override
    public final synchronized boolean glIsFramebufferOES(int n2) {
        this.b();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glIsFramebuffer(n2);
        });
        return (Boolean)this.temp;
    }

    @Override
    public final synchronized void glBindFramebufferOES(int n2, int n3) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glBindFramebuffer(n2, n3));
    }

    @Override
    public final synchronized void glDeleteFramebuffersOES(int n2, int[] nArray, int n3) {
        this.b();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        intBuffer.put(nArray, n3, n2);
        intBuffer.position(0);
        EGL10Impl.g3d.sync(() -> GL30.glDeleteFramebuffers(intBuffer));
    }

    @Override
    public final synchronized void glDeleteFramebuffersOES(int n2, IntBuffer intBuffer) {
        this.b();
        int n3 = intBuffer.limit();
        intBuffer.limit(n2 + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glDeleteFramebuffers(intBuffer));
        intBuffer.limit(n3);
    }

    @Override
    public final synchronized void glGenFramebuffersOES(int n2, int[] nArray, int n3) {
        this.b();
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n2);
        EGL10Impl.g3d.sync(() -> GL30.glGenFramebuffers(intBuffer));
        intBuffer.get(nArray, n3, n2);
    }

    @Override
    public final synchronized void glGenFramebuffersOES(int n2, IntBuffer intBuffer) {
        this.b();
        int n3 = intBuffer.limit();
        intBuffer.limit(n2 + intBuffer.position());
        EGL10Impl.g3d.sync(() -> GL30.glGenFramebuffers(intBuffer));
        intBuffer.limit(n3);
    }

    @Override
    public final synchronized int glCheckFramebufferStatusOES(int n2) {
        this.b();
        EGL10Impl.g3d.sync(() -> {
            this.temp = GL30.glCheckFramebufferStatus(n2);
        });
        return (Integer)this.temp;
    }

    @Override
    public final synchronized void glFramebufferTexture2DOES(int n2, int n3, int n4, int n5, int n6) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glFramebufferTexture2D(n2, n3, n4, n5, n6));
    }

    @Override
    public final synchronized void glFramebufferRenderbufferOES(int n2, int n3, int n4, int n5) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glFramebufferRenderbuffer(n2, n3, n4, n5));
    }

    @Override
    public final synchronized void glGetFramebufferAttachmentParameterivOES(int n2, int n3, int n4, int[] nArray, int n5) {
        this.b();
        int n6 = 1;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(n6);
        EGL10Impl.g3d.sync(() -> GL30.glGetFramebufferAttachmentParameteriv(n2, n3, n4, intBuffer));
        intBuffer.get(nArray, n2, n6);
    }

    @Override
    public final synchronized void glGetFramebufferAttachmentParameterivOES(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glGetFramebufferAttachmentParameteriv(n2, n3, n4, intBuffer));
    }

    @Override
    public final synchronized void glGenerateMipmapOES(int n2) {
        this.b();
        EGL10Impl.g3d.sync(() -> GL30.glGenerateMipmap(n2));
    }

    @Override
    public final synchronized void glPointSizePointerOES(int n2, int n3, Buffer buffer) {
        System.out.println("OES is not implemented.");
    }

    @Override
    public final synchronized void glPointSizePointerOES(int n2, int n3, int n4) {
        System.out.println("OES is not implemented.");
    }

    public GL11Impl(EGLContext eGLContext) {
        super(eGLContext);
    }
}

