/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Object3D;

public class Background
extends Object3D {
    public static final int BORDER = 32;
    public static final int REPEAT = 33;
    private boolean colorClear = true;
    private boolean depthClear = true;
    private int color = 0;
    private Image2D image = null;
    private int imageModeX = 32;
    private int imageModeY = 32;
    private int cropX;
    private int cropY;
    private int cropWidth;
    private int cropHeight;

    public void setColorClearEnable(boolean bl2) {
        this.colorClear = bl2;
    }

    public boolean isColorClearEnabled() {
        return this.colorClear;
    }

    public void setDepthClearEnable(boolean bl2) {
        this.depthClear = bl2;
    }

    public boolean isDepthClearEnabled() {
        return this.depthClear;
    }

    public void setColor(int n2) {
        this.color = n2;
    }

    public int getColor() {
        return this.color;
    }

    public void setImage(Image2D image2D) {
        if (image2D != null && image2D.getFormat() != 99 && image2D.getFormat() != 100) {
            throw new IllegalArgumentException();
        }
        this.removeReference(this.image);
        this.image = image2D;
        this.addReference(this.image);
        if (image2D != null) {
            this.cropX = 0;
            this.cropY = 0;
            this.cropWidth = image2D.getWidth();
            this.cropHeight = image2D.getHeight();
        }
    }

    public Image2D getImage() {
        return this.image;
    }

    public void setImageMode(int n2, int n3) {
        if (n2 != 32 && n2 != 33) {
            throw new IllegalArgumentException();
        }
        if (n3 != 32 && n3 != 33) {
            throw new IllegalArgumentException();
        }
        this.imageModeX = n2;
        this.imageModeY = n3;
    }

    public int getImageModeX() {
        return this.imageModeX;
    }

    public int getImageModeY() {
        return this.imageModeY;
    }

    public void setCrop(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.cropX = n2;
        this.cropY = n3;
        this.cropWidth = n4;
        this.cropHeight = n5;
    }

    public int getCropX() {
        return this.cropX;
    }

    public int getCropY() {
        return this.cropY;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 256: {
                this.color = this.color & 0xFFFFFF | G3DUtils.getIntColor(fArray) & 0xFF000000;
                return;
            }
            default: {
                super.updateProperty(n2, fArray);
                break;
            }
            case 258: {
                this.color = this.color & 0xFF000000 | G3DUtils.getIntColor(fArray) & 0xFFFFFF;
                return;
            }
            case 259: {
                this.cropX = G3DUtils.round(fArray[0]);
                this.cropY = G3DUtils.round(fArray[1]);
                if (fArray.length <= 2) break;
                this.cropWidth = Math.max(G3DUtils.round(fArray[2]), 0);
                this.cropHeight = Math.max(G3DUtils.round(fArray[3]), 0);
                return;
            }
        }
    }
}

