/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.Emulator;
import emulator.Settings;
import emulator.debug.Profiler3D;
import emulator.graphics3D.IGraphics3D;
import emulator.graphics3D.m3g.CameraCache;
import emulator.graphics3D.m3g.LightsCache;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class Graphics3D {
    public static final int ANTIALIAS = 2;
    public static final int DITHER = 4;
    public static final int OVERWRITE = 16;
    public static final int TRUE_COLOR = 8;
    private static Object target = null;
    private static IGraphics3D impl;
    private static Graphics3D inst;
    private int viewportX;
    private int viewportY;
    private int viewportWidth;
    private int viewportHeight;
    private float depthRangeNear;
    private float depthRangeFar;
    private Image2D tempBgImage;

    private Graphics3D() {
        impl = Emulator.getGraphics3D();
        this.depthRangeNear = 0.0f;
        this.depthRangeFar = 1.0f;
    }

    public static final Graphics3D getInstance() {
        return inst;
    }

    public static final IGraphics3D getImpl() {
        return impl;
    }

    public static final Hashtable getProperties() {
        return impl.getProperties();
    }

    public void bindTarget(Object object) {
        this.bindTarget(object, true, 0);
    }

    public void bindTarget(Object object, boolean bl2, int n2) {
        impl.enableDepthBuffer(bl2);
        if (target != null) {
            throw new IllegalStateException("Target already bound");
        }
        if (object == null) {
            throw new NullPointerException("target");
        }
        if (n2 != 0 && (n2 & 0x1E) == 0) {
            throw new IllegalArgumentException("hints");
        }
        boolean bl3 = !Settings.m3gIgnoreOverwrite && (n2 & 0x10) != 0;
        Background background = new Background();
        background.setColorClearEnable(!bl3);
        background.setDepthClearEnable(bl2);
        if (object instanceof Graphics) {
            Graphics graphics = (Graphics)object;
            int n3 = graphics.getImage().getWidth();
            int n4 = graphics.getImage().getHeight();
            if (n3 > 2048 || n4 > 2048) {
                throw new IllegalArgumentException();
            }
            target = object;
            impl.bindTarget(graphics);
            this.setViewport(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
            if (!bl3) {
                if (this.tempBgImage == null || this.tempBgImage.getWidth() != n3 || this.tempBgImage.getHeight() != n4) {
                    this.tempBgImage = new Image2D(99, new Image(graphics.getImage()));
                }
                this.tempBgImage.setRGB(graphics.getImage());
                background.setImage(this.tempBgImage);
                background.setCrop(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
            }
        } else if (object instanceof Image2D) {
            Image2D image2D = (Image2D)object;
            int n5 = image2D.getWidth();
            int n6 = image2D.getHeight();
            if (n5 > 2048 || n6 > 2048) {
                throw new IllegalArgumentException();
            }
            int n7 = image2D.getFormat();
            if (!image2D.isMutable() || n7 != 99 && n7 != 100) {
                throw new IllegalArgumentException();
            }
            target = object;
            impl.bindTarget(image2D);
            this.setViewport(0, 0, n5, n6);
            if (!bl3) {
                background.setImage(image2D);
                background.setCrop(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
            }
        } else {
            throw new IllegalArgumentException("Unsupported target type");
        }
        if (target != null) {
            impl.setHints(n2);
            this.setDepthRange(this.depthRangeNear, this.depthRangeFar);
            this.clear(background);
        }
    }

    public void releaseTarget() {
        if (target != null) {
            impl.releaseTarget();
            target = null;
        }
    }

    public Object getTarget() {
        return target;
    }

    public int getHints() {
        return impl.getHints();
    }

    public boolean isDepthBufferEnabled() {
        return impl.isDepthBufferEnabled();
    }

    public void setViewport(int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0 || n4 > 2048 || n5 > 2048) {
            throw new IllegalArgumentException();
        }
        this.viewportX = n2;
        this.viewportY = n3;
        this.viewportWidth = n4;
        this.viewportHeight = n5;
        impl.setViewport(n2, n3, n4, n5);
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public void setDepthRange(float f2, float f3) {
        if (!(f2 >= 0.0f && f2 <= 1.0f && f3 >= 0.0f && f3 <= 1.0f)) {
            throw new IllegalArgumentException();
        }
        this.depthRangeNear = f2;
        this.depthRangeFar = f3;
        impl.setDepthRange(f2, f3);
    }

    public float getDepthRangeNear() {
        return this.depthRangeNear;
    }

    public float getDepthRangeFar() {
        return this.depthRangeFar;
    }

    public void clear(Background background) {
        if (target == null) {
            throw new IllegalStateException();
        }
        impl.clearBackgound(background);
    }

    public void render(World world) {
        ++Profiler3D.M3G_renderWorldCallCount;
        if (world == null) {
            throw new NullPointerException();
        }
        if (target == null || world.getActiveCamera() == null || !world.getActiveCamera().isDescendantOf(world)) {
            throw new IllegalStateException();
        }
        impl.render(world);
    }

    public void render(Node node, Transform transform) {
        ++Profiler3D.M3G_renderNodeCallCount;
        if (node == null) {
            throw new NullPointerException();
        }
        if (!(node instanceof Sprite3D || node instanceof Mesh || node instanceof Group)) {
            throw new IllegalArgumentException();
        }
        if (target == null || CameraCache.camera == null) {
            throw new IllegalStateException();
        }
        impl.render(node, transform);
    }

    public void render(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform, int n2) {
        ++Profiler3D.M3G_renderVertexCallCount;
        if (vertexBuffer != null && indexBuffer != null && appearance != null) {
            if (target == null || CameraCache.camera == null) {
                throw new IllegalStateException();
            }
        } else {
            throw new NullPointerException();
        }
        impl.render(vertexBuffer, indexBuffer, appearance, transform, n2);
    }

    public void render(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform) {
        this.render(vertexBuffer, indexBuffer, appearance, transform, -1);
    }

    public void setCamera(Camera camera, Transform transform) {
        CameraCache.setCamera(camera, transform);
    }

    public Camera getCamera(Transform transform) {
        return CameraCache.getCamera(transform);
    }

    public int addLight(Light light, Transform transform) {
        return LightsCache.addLight(light, transform);
    }

    public void setLight(int n2, Light light, Transform transform) {
        LightsCache.setLight(n2, light, transform);
    }

    public void resetLights() {
        LightsCache.resetLights();
    }

    public int getLightCount() {
        return LightsCache.getLightCount();
    }

    public Light getLight(int n2, Transform transform) {
        return LightsCache.getLight(n2, transform);
    }

    static {
        inst = new Graphics3D();
    }
}

