/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics2D.IImage;
import emulator.graphics3D.lwjgl.Emulator3D;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Object3D;

public class Image2D
extends Object3D {
    public static final int ALPHA = 96;
    public static final int LUMINANCE = 97;
    public static final int LUMINANCE_ALPHA = 98;
    public static final int RGB = 99;
    public static final int RGBA = 100;
    private int type;
    private int width;
    private int height;
    private byte[] imageData;
    private boolean mutable;
    private static byte[] tmp;
    public boolean loaded;
    private int id;

    public Image2D(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!Image2D.checkType(n2)) {
            throw new IllegalArgumentException();
        }
        if (!(object instanceof Image)) {
            throw new IllegalArgumentException();
        }
        Image image = (Image)object;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.mutable = false;
        this.type = n2;
        this.imageData = Image2D.convert(n2, image.getImpl().getData(), image.isMutable());
    }

    public Image2D(int n2, int n3, int n4, byte[] byArray) {
        int n5;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n3 > 0 && n4 > 0 && Image2D.checkType(n2)) {
            n5 = n3 * n4 * Image2D.bytesPerPixel(n2);
            if (byArray.length < n5) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.width = n3;
        this.height = n4;
        this.mutable = false;
        this.type = n2;
        this.imageData = new byte[n5];
        System.arraycopy(byArray, 0, this.imageData, 0, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image2D(int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) throw new NullPointerException();
        int n5 = n3 * n4;
        if (n3 <= 0 || n4 <= 0 || !Image2D.checkType(n2) || byArray.length < n5) throw new IllegalArgumentException();
        int n6 = Image2D.bytesPerPixel(n2);
        if (byArray2.length < 256 * n6 && byArray2.length % n6 != 0) {
            throw new IllegalArgumentException();
        }
        this.width = n3;
        this.height = n4;
        this.mutable = false;
        this.type = n2;
        this.imageData = new byte[n5 * n6];
        for (int i2 = 0; i2 < n5; ++i2) {
            System.arraycopy(byArray2, (byArray[i2] & 0xFF) * n6, this.imageData, i2 * n6, n6);
        }
    }

    public Image2D(int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0 && Image2D.checkType(n2)) {
            int n5;
            this.width = n3;
            this.height = n4;
            this.mutable = true;
            this.type = n2;
            int n6 = n3 * Image2D.bytesPerPixel(n2);
            this.imageData = new byte[n6 * n4];
            if (tmp == null || tmp.length < n6) {
                tmp = new byte[n6];
                for (n5 = n6 - 1; n5 >= 0; --n5) {
                    Image2D.tmp[n5] = -1;
                }
            }
            for (n5 = 0; n5 < n4; ++n5) {
                System.arraycopy(tmp, 0, this.imageData, n5 * n6, n6);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void set(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.mutable && n2 >= 0 && n3 >= 0 && n4 > 0 && n5 > 0 && n2 + n4 <= this.width && n3 + n5 <= this.height) {
            int n6 = this.getBitsPerColor();
            if (byArray.length < n4 * n5 * n6) {
                throw new IllegalArgumentException();
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                System.arraycopy(byArray, i2 * n4 * n6, this.imageData, ((n3 + i2) * this.width + n2) * n6, n4 * n6);
            }
        } else {
            throw new IllegalArgumentException();
        }
        ((Emulator3D)Graphics3D.getImpl()).invalidateTexture(this);
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int getFormat() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitsPerColor() {
        return Image2D.bytesPerPixel(this.type);
    }

    private static int bytesPerPixel(int n2) {
        switch (n2) {
            case 96: 
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 99: {
                return 3;
            }
            case 100: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean checkType(int n2) {
        return n2 >= 96 && n2 <= 100;
    }

    public final byte[] getImageData() {
        return this.imageData;
    }

    private static byte[] convert(int n2, int[] nArray, boolean bl2) {
        byte[] byArray = null;
        int n3 = nArray.length;
        if (bl2) {
            switch (n2) {
                case 96: 
                case 97: {
                    byArray = new byte[n3];
                    for (int i2 = n3 - 1; i2 >= 0; --i2) {
                        byArray[i2] = (byte)(((nArray[i2] >> 16 & 0xFF) + (nArray[i2] >> 8 & 0xFF) + (nArray[i2] & 0xFF)) / 3 & 0xFF);
                    }
                    return byArray;
                }
                case 98: {
                    byArray = new byte[n3 * 2];
                    for (int i3 = n3 - 1; i3 >= 0; --i3) {
                        byArray[i3 * 2] = (byte)(((nArray[i3] >> 16 & 0xFF) + (nArray[i3] >> 8 & 0xFF) + (nArray[i3] & 0xFF)) / 3 & 0xFF);
                        byArray[i3 * 2 + 1] = -1;
                    }
                    return byArray;
                }
                case 99: {
                    byArray = new byte[n3 * 3];
                    for (int i4 = n3 - 1; i4 >= 0; --i4) {
                        byArray[i4 * 3] = (byte)(nArray[i4] >> 16 & 0xFF);
                        byArray[i4 * 3 + 1] = (byte)(nArray[i4] >> 8 & 0xFF);
                        byArray[i4 * 3 + 2] = (byte)(nArray[i4] & 0xFF);
                    }
                    return byArray;
                }
                case 100: {
                    byArray = new byte[n3 * 4];
                    for (int i5 = n3 - 1; i5 >= 0; --i5) {
                        byArray[i5 * 4] = (byte)(nArray[i5] >> 16 & 0xFF);
                        byArray[i5 * 4 + 1] = (byte)(nArray[i5] >> 8 & 0xFF);
                        byArray[i5 * 4 + 2] = (byte)(nArray[i5] & 0xFF);
                        byArray[i5 * 4 + 3] = -1;
                    }
                    break;
                }
            }
        } else {
            switch (n2) {
                case 96: {
                    byArray = new byte[n3];
                    for (int i6 = n3 - 1; i6 >= 0; --i6) {
                        byArray[i6] = (byte)(nArray[i6] >> 24 & 0xFF);
                    }
                    return byArray;
                }
                case 97: {
                    byArray = new byte[n3];
                    for (int i7 = n3 - 1; i7 >= 0; --i7) {
                        byArray[i7] = (byte)(((nArray[i7] >> 16 & 0xFF) + (nArray[i7] >> 8 & 0xFF) + (nArray[i7] & 0xFF)) / 3 & 0xFF);
                    }
                    return byArray;
                }
                case 98: {
                    byArray = new byte[n3 * 2];
                    for (int i8 = n3 - 1; i8 >= 0; --i8) {
                        byArray[i8 * 2] = (byte)(((nArray[i8] >> 16 & 0xFF) + (nArray[i8] >> 8 & 0xFF) + (nArray[i8] & 0xFF)) / 3 & 0xFF);
                        byArray[i8 * 2 + 1] = (byte)(nArray[i8] >> 24 & 0xFF);
                    }
                    return byArray;
                }
                case 99: {
                    byArray = new byte[n3 * 3];
                    for (int i9 = n3 - 1; i9 >= 0; --i9) {
                        byArray[i9 * 3] = (byte)(nArray[i9] >> 16 & 0xFF);
                        byArray[i9 * 3 + 1] = (byte)(nArray[i9] >> 8 & 0xFF);
                        byArray[i9 * 3 + 2] = (byte)(nArray[i9] & 0xFF);
                    }
                    return byArray;
                }
                case 100: {
                    byArray = new byte[n3 * 4];
                    for (int i10 = n3 - 1; i10 >= 0; --i10) {
                        byArray[i10 * 4] = (byte)(nArray[i10] >> 16 & 0xFF);
                        byArray[i10 * 4 + 1] = (byte)(nArray[i10] >> 8 & 0xFF);
                        byArray[i10 * 4 + 2] = (byte)(nArray[i10] & 0xFF);
                        byArray[i10 * 4 + 3] = (byte)(nArray[i10] >> 24 & 0xFF);
                    }
                    break;
                }
            }
        }
        return byArray;
    }

    @Override
    protected Object3D duplicateObject() {
        Image2D image2D = (Image2D)super.duplicateObject();
        image2D.imageData = (byte[])this.imageData.clone();
        return image2D;
    }

    public void finalize() {
        if (this.id == 0) {
            return;
        }
        ((Emulator3D)Graphics3D.getImpl()).finalizeTexture(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl2) {
        this.loaded = bl2;
    }

    public void setId(int n2) {
        this.id = n2;
        this.loaded = false;
    }

    public int getId() {
        return this.id;
    }

    public int size() {
        return this.imageData.length;
    }

    public void getPixels(byte[] byArray) {
        byte[] byArray2 = this.getImageData();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    public boolean isPalettized() {
        return false;
    }

    public void getPalette(byte[] byArray) {
    }

    void setRGB(IImage iImage) {
        int[] nArray = iImage.getData();
        int n2 = nArray.length;
        if (this.imageData == null || this.imageData.length != n2 * 3) {
            this.imageData = new byte[n2 * 3];
        }
        byte[] byArray = this.imageData;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            byArray[i2 * 3] = (byte)(nArray[i2] >> 16 & 0xFF);
            byArray[i2 * 3 + 1] = (byte)(nArray[i2] >> 8 & 0xFF);
            byArray[i2 * 3 + 2] = (byte)(nArray[i2] & 0xFF);
        }
        ((Emulator3D)Graphics3D.getImpl()).invalidateTexture(this);
    }
}

