/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Quaternion;
import javax.microedition.m3g.Object3D;

public class KeyframeSequence
extends Object3D {
    public static final int CONSTANT = 192;
    public static final int LOOP = 193;
    public static final int LINEAR = 176;
    public static final int SLERP = 177;
    public static final int SPLINE = 178;
    public static final int SQUAD = 179;
    public static final int STEP = 180;
    private int keyframeCount;
    private int componentCount;
    private int interpolationType;
    private float[][] aFloatArrayArray144;
    private int[] keyframes;
    private int validRangeFirst;
    private int validRangeLast;
    private int duration;
    private int repeatMode;
    private boolean dirty;
    private float[][] inTangent;
    private float[][] outTangent;
    private Quaternion[] a;
    private Quaternion[] b;

    @Override
    protected Object3D duplicateObject() {
        KeyframeSequence keyframeSequence;
        block4: {
            block3: {
                int n2;
                keyframeSequence = (KeyframeSequence)super.duplicateObject();
                ((KeyframeSequence)super.duplicateObject()).keyframes = (int[])this.keyframes.clone();
                keyframeSequence.aFloatArrayArray144 = new float[this.keyframeCount][this.componentCount];
                if (this.interpolationType != 179) break block3;
                for (n2 = 0; n2 < this.a.length; ++n2) {
                    keyframeSequence.a[n2] = new Quaternion(this.a[n2]);
                    keyframeSequence.b[n2] = new Quaternion(this.b[n2]);
                }
                for (n2 = 0; n2 < this.keyframeCount; ++n2) {
                    keyframeSequence.aFloatArrayArray144[n2] = (float[])this.aFloatArrayArray144[n2].clone();
                }
                break block4;
            }
            if (this.interpolationType != 178) break block4;
            keyframeSequence.inTangent = new float[this.keyframeCount][this.componentCount];
            keyframeSequence.outTangent = new float[this.keyframeCount][this.componentCount];
            for (int i2 = 0; i2 < this.keyframeCount; ++i2) {
                keyframeSequence.inTangent[i2] = (float[])this.inTangent[i2].clone();
                keyframeSequence.outTangent[i2] = (float[])this.outTangent[i2].clone();
                keyframeSequence.aFloatArrayArray144[i2] = (float[])this.aFloatArrayArray144[i2].clone();
            }
        }
        return keyframeSequence;
    }

    public KeyframeSequence(int n2, int n3, int n4) {
        if (n2 >= 1 && n3 >= 1 && KeyframeSequence.checkInterpolation(n4)) {
            if ((n4 == 177 || n4 == 179) && n3 != 4) {
                throw new IllegalArgumentException();
            }
            this.keyframeCount = n2;
            this.componentCount = n3;
            this.interpolationType = n4;
            this.aFloatArrayArray144 = new float[n2][n3];
            this.keyframes = new int[n2];
            this.repeatMode = 192;
            this.validRangeFirst = 0;
            this.validRangeLast = this.keyframeCount - 1;
            this.duration = 0;
            this.dirty = false;
            if (this.interpolationType == 178) {
                this.inTangent = new float[n2][n3];
                this.outTangent = new float[n2][n3];
            } else if (this.interpolationType == 179) {
                this.a = new Quaternion[n2];
                this.b = new Quaternion[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.a[i2] = new Quaternion();
                    this.b[i2] = new Quaternion();
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static boolean checkInterpolation(int n2) {
        return n2 >= 176 && n2 <= 180;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public int getKeyframeCount() {
        return this.keyframeCount;
    }

    public int getInterpolationType() {
        return this.interpolationType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setKeyframe(int n2, int n3, float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 >= this.keyframeCount) throw new IndexOutOfBoundsException();
        if (n3 < 0 || fArray.length < this.componentCount) throw new IllegalArgumentException();
        this.keyframes[n2] = n3;
        float[] fArray2 = this.aFloatArrayArray144[n2];
        if (this.interpolationType != 177 && this.interpolationType != 179) {
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        } else {
            Quaternion quaternion = new Quaternion(fArray[0], fArray[1], fArray[2], fArray[3]);
            quaternion.normalize();
            fArray2[0] = quaternion.x;
            fArray2[1] = quaternion.y;
            fArray2[2] = quaternion.z;
            fArray2[3] = quaternion.w;
        }
        this.dirty = false;
    }

    public int getKeyframe(int n2, float[] fArray) {
        if (n2 >= 0 && n2 < this.keyframeCount) {
            if (fArray != null && fArray.length < this.componentCount) {
                throw new IllegalArgumentException();
            }
            if (fArray != null) {
                System.arraycopy(this.aFloatArrayArray144[n2], 0, fArray, 0, this.componentCount);
            }
            return this.keyframes[n2];
        }
        throw new IndexOutOfBoundsException();
    }

    public void setValidRange(int n2, int n3) {
        if (n2 < 0 || n2 >= this.keyframeCount || n3 < 0 || n3 >= this.keyframeCount) {
            throw new IndexOutOfBoundsException();
        }
        this.validRangeFirst = n2;
        this.validRangeLast = n3;
        this.dirty = false;
    }

    public int getValidRangeFirst() {
        return this.validRangeFirst;
    }

    public int getValidRangeLast() {
        return this.validRangeLast;
    }

    public void setDuration(int n2) {
        this.duration = n2;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setRepeatMode(int n2) {
        if (n2 != 192 && n2 != 193) {
            throw new IllegalArgumentException();
        }
        this.repeatMode = n2;
        if (this.dirty) {
            this.updateTangents();
        }
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    protected int getSampleFrame(float f2, float[] fArray) {
        if (!this.dirty) {
            this.validate();
        }
        if (this.repeatMode == 193) {
            float f3 = f2 = f2 < 0.0f ? f2 % (float)this.duration + (float)this.duration : f2 % (float)this.duration;
            if (f3 < (float)this.keyframes[this.validRangeFirst]) {
                f2 += (float)this.duration;
            }
        } else {
            if (f2 < (float)this.keyframes[this.validRangeFirst]) {
                float f4;
                float[] fArray2 = this.aFloatArrayArray144[this.validRangeFirst];
                System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
                float f5 = (float)this.keyframes[this.validRangeFirst] - f2;
                if (f4 <= 2.1474836E9f) {
                    return (int)f5;
                }
                return Integer.MAX_VALUE;
            }
            if (f2 >= (float)this.keyframes[this.validRangeLast]) {
                float[] fArray3 = this.aFloatArrayArray144[this.validRangeLast];
                System.arraycopy(fArray3, 0, fArray, 0, fArray3.length);
                return Integer.MAX_VALUE;
            }
        }
        int n2 = this.validRangeFirst;
        while (true) {
            int n3 = n2;
            if (n2 == this.validRangeLast || (float)this.keyframes[this.keyframeAfter(n3)] > f2) {
                if (f2 - (float)this.keyframes[n3] >= 1.0E-5f && this.interpolationType != 180) {
                    float f6 = (f2 - (float)this.keyframes[n3]) / (float)this.timeDelta(n3);
                    int n4 = this.keyframeAfter(n3);
                    switch (this.interpolationType) {
                        case 176: {
                            this.linearInterp(fArray, f6, n3, n4);
                            break;
                        }
                        case 177: {
                            this.slerpInterp(fArray, f6, n3, n4);
                            break;
                        }
                        case 178: {
                            this.splineInterp(fArray, f6, n3, n4);
                            break;
                        }
                        case 179: {
                            this.squadInterp(fArray, f6, n3, n4);
                            break;
                        }
                        default: {
                            throw new Error("Invalid type for interpolation!");
                        }
                    }
                    return 1;
                }
                System.arraycopy(this.aFloatArrayArray144[n3], 0, fArray, 0, this.componentCount);
                return this.interpolationType != 180 ? 1 : (int)((float)this.timeDelta(n3) - (f2 - (float)this.keyframes[n3]));
            }
            n2 = this.keyframeAfter(n3);
        }
    }

    private void validate() {
        if (this.duration <= 0) {
            throw new IllegalStateException();
        }
        int n2 = this.validRangeFirst;
        while (true) {
            int n3;
            int n4 = n2;
            if (n2 == this.validRangeLast) {
                this.dirty = true;
                this.updateTangents();
                return;
            }
            int n5 = n3 = n4 >= this.keyframes.length - 1 ? 0 : n4 + 1;
            if (this.keyframes[n3] < this.keyframes[n4] || this.keyframes[n3] > this.duration) {
                throw new IllegalStateException();
            }
            n2 = n3;
        }
    }

    private final void linearInterp(float[] fArray, float f2, int n2, int n3) {
        float[] fArray2 = this.aFloatArrayArray144[n2];
        float[] fArray3 = this.aFloatArrayArray144[n3];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = fArray2[i2] + f2 * (fArray3[i2] - fArray2[i2]);
        }
    }

    private final void splineInterp(float[] fArray, float f2, int n2, int n3) {
        float[] fArray2 = this.aFloatArrayArray144[n2];
        float[] fArray3 = this.aFloatArrayArray144[n3];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = this.outTangent[n2][i2];
            float f4 = this.inTangent[n3][i2];
            fArray[i2] = KeyframeSequence.spline(f2, fArray2[i2], fArray3[i2], f3, f4);
        }
    }

    private static float spline(float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2 * f2;
        float f8 = f7 * f2;
        return (2.0f * f8 - 3.0f * f7 + 1.0f) * f3 + (-2.0f * f8 + 3.0f * f7) * f4 + (f8 - 2.0f * f7 + f2) * f5 + (f8 - f7) * f6;
    }

    private final void precalculateTangents() {
        int n2 = this.validRangeFirst;
        do {
            float[] fArray = this.aFloatArrayArray144[this.keyframeBefore(n2)];
            float[] fArray2 = this.aFloatArrayArray144[this.keyframeAfter(n2)];
            float f2 = this.incomingTangentScale(n2);
            float f3 = this.outgoingTangentScale(n2);
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                this.inTangent[n2][i2] = 0.5f * (fArray2[i2] - fArray[i2]) * f2;
                this.outTangent[n2][i2] = 0.5f * (fArray2[i2] - fArray[i2]) * f3;
            }
        } while ((n2 = this.keyframeAfter(n2)) != this.validRangeFirst);
    }

    private final void slerpInterp(float[] fArray, float f2, int n2, int n3) {
        if (fArray.length != 4) {
            throw new Error("Invalid keyframe type");
        }
        Quaternion quaternion = new Quaternion(this.aFloatArrayArray144[n2]);
        Quaternion quaternion2 = new Quaternion(this.aFloatArrayArray144[n3]);
        Quaternion quaternion3 = new Quaternion();
        quaternion3.slerp(f2, quaternion, quaternion2);
        fArray[0] = quaternion3.x;
        fArray[1] = quaternion3.y;
        fArray[2] = quaternion3.z;
        fArray[3] = quaternion3.w;
    }

    private final void squadInterp(float[] fArray, float f2, int n2, int n3) {
        if (fArray.length != 4) {
            throw new Error("Invalid keyframe type");
        }
        Quaternion quaternion = new Quaternion(this.aFloatArrayArray144[n2]);
        Quaternion quaternion2 = new Quaternion(this.aFloatArrayArray144[n3]);
        Quaternion quaternion3 = new Quaternion();
        quaternion3.squad(f2, quaternion, this.a[n2], this.b[n3], quaternion2);
        fArray[0] = quaternion3.x;
        fArray[1] = quaternion3.y;
        fArray[2] = quaternion3.z;
        fArray[3] = quaternion3.w;
    }

    private final void precalculateAB() {
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        Quaternion quaternion3 = new Quaternion();
        Quaternion quaternion4 = new Quaternion();
        Quaternion quaternion5 = new Quaternion();
        Quaternion quaternion6 = new Quaternion();
        Quaternion quaternion7 = new Quaternion();
        int n2 = this.validRangeFirst;
        do {
            quaternion3.set(this.aFloatArrayArray144[this.keyframeBefore(n2)]);
            quaternion.set(this.aFloatArrayArray144[n2]);
            quaternion2.set(this.aFloatArrayArray144[this.keyframeAfter(n2)]);
            quaternion4.set(this.aFloatArrayArray144[this.keyframeAfter(this.keyframeAfter(n2))]);
            quaternion7.logDiff(quaternion, quaternion2);
            quaternion6.logDiff(quaternion3, quaternion);
            quaternion7.add(quaternion6);
            quaternion7.mul(0.5f);
            quaternion5.set(quaternion7);
            quaternion5.mul(this.outgoingTangentScale(n2));
            quaternion6.logDiff(quaternion, quaternion2);
            quaternion5.sub(quaternion6);
            quaternion5.mul(0.5f);
            quaternion6.exp(quaternion5);
            this.a[n2].set(quaternion);
            this.a[n2].mul(quaternion6);
            quaternion5.set(quaternion7);
            quaternion5.mul(this.incomingTangentScale(n2));
            quaternion6.logDiff(quaternion3, quaternion);
            quaternion6.sub(quaternion5);
            quaternion6.mul(0.5f);
            quaternion6.exp(quaternion6);
            this.b[n2].set(quaternion);
            this.b[n2].mul(quaternion6);
        } while ((n2 = this.keyframeAfter(n2)) != this.validRangeFirst);
    }

    private float incomingTangentScale(int n2) {
        if (this.repeatMode != 192 || n2 != this.validRangeFirst && n2 != this.validRangeLast) {
            int n3 = this.keyframeBefore(n2);
            return 2.0f * (float)this.timeDelta(n3) / (float)(this.timeDelta(n2) + this.timeDelta(n3));
        }
        return 0.0f;
    }

    private float outgoingTangentScale(int n2) {
        if (this.repeatMode != 192 || n2 != this.validRangeFirst && n2 != this.validRangeLast) {
            int n3 = this.keyframeBefore(n2);
            return 2.0f * (float)this.timeDelta(n2) / (float)(this.timeDelta(n3) + this.timeDelta(n2));
        }
        return 0.0f;
    }

    private void updateTangents() {
        if (!this.dirty) {
            throw new Error();
        }
        if (this.interpolationType == 178) {
            this.precalculateTangents();
        } else if (this.interpolationType == 179) {
            this.precalculateAB();
        }
    }

    private int keyframeAfter(int n2) {
        return n2 == this.validRangeLast ? this.validRangeFirst : (n2 == this.keyframes.length - 1 ? 0 : n2 + 1);
    }

    private int keyframeBefore(int n2) {
        return n2 == this.validRangeFirst ? this.validRangeLast : (n2 == 0 ? this.keyframes.length - 1 : n2 - 1);
    }

    private int timeDelta(int n2) {
        return n2 == this.validRangeLast ? this.duration - this.keyframes[this.validRangeLast] + this.keyframes[this.validRangeFirst] : this.keyframes[this.keyframeAfter(n2)] - this.keyframes[n2];
    }
}

