/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexBuffer;

public class Mesh
extends Node {
    protected VertexBuffer vertices;
    private IndexBuffer[] submeshes;
    private Appearance[] appearances;

    public Mesh(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance) {
        if (vertexBuffer == null || indexBuffer == null) {
            throw new NullPointerException();
        }
        this.vertices = vertexBuffer;
        this.submeshes = new IndexBuffer[1];
        this.submeshes[0] = indexBuffer;
        this.appearances = new Appearance[1];
        if (appearance != null) {
            this.appearances[0] = appearance;
            this.addReference(this.appearances[0]);
        }
        this.addReference(this.vertices);
        this.addReference(this.submeshes[0]);
    }

    public Mesh(VertexBuffer vertexBuffer, IndexBuffer[] indexBufferArray, Appearance[] appearanceArray) {
        if (vertexBuffer == null || indexBufferArray == null) {
            throw new NullPointerException();
        }
        if (indexBufferArray.length == 0 || appearanceArray != null && appearanceArray.length < indexBufferArray.length) {
            throw new IllegalArgumentException();
        }
        this.vertices = vertexBuffer;
        this.submeshes = new IndexBuffer[indexBufferArray.length];
        this.appearances = new Appearance[indexBufferArray.length];
        for (int i2 = 0; i2 < indexBufferArray.length; ++i2) {
            if (indexBufferArray[i2] == null) {
                throw new NullPointerException();
            }
            this.submeshes[i2] = indexBufferArray[i2];
            this.addReference(this.submeshes[i2]);
            if (appearanceArray == null) continue;
            this.appearances[i2] = appearanceArray[i2];
            this.addReference(this.appearances[i2]);
        }
        this.addReference(this.vertices);
    }

    @Override
    protected Object3D duplicateObject() {
        Mesh mesh = (Mesh)super.duplicateObject();
        mesh.submeshes = (IndexBuffer[])this.submeshes.clone();
        mesh.appearances = (Appearance[])this.appearances.clone();
        return mesh;
    }

    public void setAppearance(int n2, Appearance appearance) {
        if (n2 < 0 || n2 >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        this.removeReference(this.appearances[n2]);
        this.appearances[n2] = appearance;
        this.addReference(this.appearances[n2]);
    }

    public Appearance getAppearance(int n2) {
        if (n2 < 0 || n2 >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.appearances[n2];
    }

    public IndexBuffer getIndexBuffer(int n2) {
        if (n2 < 0 || n2 >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.submeshes[n2];
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertices;
    }

    public int getSubmeshCount() {
        return this.submeshes.length;
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        return this.rayIntersect(n2, fArray, rayIntersection, transform, this.vertices);
    }

    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform, VertexBuffer vertexBuffer) {
        block17: {
            if ((n2 & this.getScope()) == 0) {
                return false;
            }
            if (vertexBuffer == null || this.appearances == null || this.submeshes == null) break block17;
            if (vertexBuffer.getPositions(null) == null) {
                throw new IllegalStateException("No vertex positions");
            }
            boolean bl2 = false;
            Vector4f vector4f = new Vector4f(fArray[0], fArray[1], fArray[2], 1.0f);
            Vector4f vector4f2 = new Vector4f(fArray[3], fArray[4], fArray[5], 1.0f);
            Transform transform2 = new Transform();
            transform2.set(transform);
            transform2.getImpl_().invert();
            transform2.getImpl_().transform(vector4f);
            transform2.getImpl_().transform(vector4f2);
            vector4f.mul(1.0f / vector4f.w);
            vector4f2.mul(1.0f / vector4f2.w);
            vector4f2.sub(vector4f);
            Vector4f vector4f3 = new Vector4f();
            Vector4f vector4f4 = new Vector4f();
            Vector4f vector4f5 = new Vector4f();
            Vector4f vector4f6 = new Vector4f();
            Vector4f vector4f7 = new Vector4f();
            Transform transform3 = new Transform();
            int[] nArray = new int[4];
            float[] fArray2 = new float[10];
            float[] fArray3 = new float[10];
            float[] fArray4 = null;
            for (int i2 = 0; i2 < this.submeshes.length; ++i2) {
                int n3;
                block19: {
                    block18: {
                        int n4;
                        if (this.appearances[i2] == null || this.submeshes[i2] == null) continue;
                        if (this.appearances[i2].getPolygonMode() == null) break block18;
                        n3 = this.appearances[i2].getPolygonMode().getWinding() != 168 ? 1 : 0;
                        switch (this.appearances[i2].getPolygonMode().getCulling()) {
                            case 161: {
                                n4 = n3 ^ 1;
                                break;
                            }
                            case 162: {
                                n4 = 2;
                                break;
                            }
                            default: {
                                break block19;
                            }
                        }
                        n3 = n4;
                        break block19;
                    }
                    n3 = 0;
                }
                TriangleStripArray triangleStripArray = (TriangleStripArray)this.submeshes[i2];
                int n5 = 0;
                while (triangleStripArray.getIndices(n5, nArray)) {
                    int n6 = vertexBuffer.getVertexCount();
                    if (nArray[0] >= n6 || nArray[1] >= n6 || nArray[2] >= n6) {
                        throw new IllegalStateException("Index overflow: (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ") >=" + n6);
                    }
                    if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                        throw new IllegalStateException("Index underflow");
                    }
                    vertexBuffer.getVertex(nArray[0], vector4f3);
                    vertexBuffer.getVertex(nArray[1], vector4f4);
                    vertexBuffer.getVertex(nArray[2], vector4f5);
                    if (G3DUtils.intersectTriangle(vector4f, vector4f2, vector4f3, vector4f4, vector4f5, vector4f7, nArray[3] ^ n3) && rayIntersection.testDistance(vector4f7.x)) {
                        if (vertexBuffer.getNormalVertex(nArray[0], vector4f3)) {
                            vertexBuffer.getNormalVertex(nArray[1], vector4f4);
                            vertexBuffer.getNormalVertex(nArray[2], vector4f5);
                            fArray4 = new float[]{vector4f3.x * (1.0f - (vector4f7.y + vector4f7.z)) + vector4f4.x * vector4f7.y + vector4f5.x * vector4f7.z, vector4f3.y * (1.0f - (vector4f7.y + vector4f7.z)) + vector4f4.y * vector4f7.y + vector4f5.y * vector4f7.z, vector4f3.z * (1.0f - (vector4f7.y + vector4f7.z)) + vector4f4.z * vector4f7.y + vector4f5.z * vector4f7.z};
                        }
                        for (int i3 = 0; i3 < fArray2.length; ++i3) {
                            float f2;
                            int n7;
                            float[] fArray5;
                            if (vertexBuffer.getTexVertex(nArray[0], i3, vector4f3)) {
                                vertexBuffer.getTexVertex(nArray[1], i3, vector4f4);
                                vertexBuffer.getTexVertex(nArray[2], i3, vector4f5);
                                vector4f6.x = vector4f3.x * (1.0f - (vector4f7.y + vector4f7.z)) + vector4f4.x * vector4f7.y + vector4f5.x * vector4f7.z;
                                vector4f6.y = vector4f3.y * (1.0f - (vector4f7.y + vector4f7.z)) + vector4f4.y * vector4f7.y + vector4f5.y * vector4f7.z;
                                vector4f6.z = 0.0f;
                                vector4f6.w = 1.0f;
                                if (this.appearances[i2] != null && this.appearances[i2].getTexture(i3) != null) {
                                    this.appearances[i2].getTexture(i3).getCompositeTransform(transform3);
                                    transform3.getImpl_().transform(vector4f6);
                                    vector4f6.mul(1.0f / vector4f6.w);
                                }
                                fArray3[i3] = vector4f6.x;
                                fArray5 = fArray2;
                                n7 = i3;
                                f2 = vector4f6.y;
                            } else {
                                fArray3[i3] = 0.0f;
                                fArray5 = fArray2;
                                n7 = i3;
                                f2 = 0.0f;
                            }
                            fArray5[n7] = f2;
                        }
                        if (rayIntersection.endPick(vector4f7.x, fArray3, fArray2, i2, this, fArray4)) {
                            bl2 = true;
                        }
                    }
                    ++n5;
                }
            }
            return bl2;
        }
        return false;
    }
}

