/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Object3D;

public class TriangleStripArray
extends IndexBuffer {
    private int[] stripLengths;
    private IntBuffer buffer;

    public TriangleStripArray(int n2, int[] nArray) {
        int n3;
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        for (n3 = nArray.length - 1; n3 >= 0; --n3) {
            if (nArray[n3] < 3) {
                throw new IllegalArgumentException();
            }
            n4 += nArray[n3];
        }
        if (n2 + n4 > 65535) {
            throw new IllegalArgumentException();
        }
        this.indices = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.indices[n3] = n2 + n3;
        }
        this.stripLengths = new int[nArray.length];
        System.arraycopy(nArray, 0, this.stripLengths, 0, nArray.length);
        this.copyToNative();
    }

    public TriangleStripArray(int[] nArray, int[] nArray2) {
        int n2;
        if (nArray == null || nArray2 == null) {
            throw new NullPointerException();
        }
        if (nArray2.length == 0) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        for (n2 = nArray2.length - 1; n2 >= 0; --n2) {
            if (nArray2[n2] < 3) {
                throw new IllegalArgumentException();
            }
            n3 += nArray2[n2];
        }
        if (nArray.length < n3) {
            throw new IllegalArgumentException();
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (nArray[n2] >= 0 && nArray[n2] <= 65535) continue;
            throw new IllegalArgumentException();
        }
        this.indices = new int[n3];
        System.arraycopy(nArray, 0, this.indices, 0, n3);
        this.stripLengths = new int[nArray2.length];
        System.arraycopy(nArray2, 0, this.stripLengths, 0, nArray2.length);
        this.copyToNative();
    }

    @Override
    protected Object3D duplicateObject() {
        TriangleStripArray triangleStripArray = (TriangleStripArray)super.duplicateObject();
        triangleStripArray.indices = (int[])this.indices.clone();
        triangleStripArray.stripLengths = (int[])this.stripLengths.clone();
        return triangleStripArray;
    }

    public int getStripCount() {
        return this.stripLengths.length;
    }

    public int[] getIndexStrip(int n2) {
        if (n2 >= 0 && n2 < this.stripLengths.length) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += this.stripLengths[i2];
            }
            int[] nArray = new int[this.stripLengths[n2]];
            if (this.stripLengths != null) {
                System.arraycopy(this.indices, n3, nArray, 0, this.stripLengths[n2]);
            }
            return nArray;
        }
        return null;
    }

    public IntBuffer getBuffer() {
        this.buffer.position(0);
        return this.buffer;
    }

    protected boolean getIndices(int n2, int[] nArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.stripLengths.length; ++i2) {
            if (n2 < this.stripLengths[i2] - 2) {
                nArray[0] = this.indices[n3 + n2 + 0];
                nArray[1] = this.indices[n3 + n2 + 1];
                nArray[2] = this.indices[n3 + n2 + 2];
                nArray[3] = n2 & 1;
                return true;
            }
            n2 -= this.stripLengths[i2] - 2;
            n3 += this.stripLengths[i2];
        }
        return false;
    }

    private void copyToNative() {
        int n2;
        int n3 = 0;
        int n4 = this.stripLengths.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 != 0) {
                n3 += (n3 & 1) != 0 ? 3 : 2;
            }
            n3 += this.stripLengths[n2];
        }
        this.allocateBuffer(n3);
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 != 0) {
                this.buffer.put(this.indices[n5 - 1]);
                this.buffer.put(this.indices[n5]);
                if ((this.stripLengths[n2 - 1] & 1) != 0) {
                    this.buffer.put(this.indices[n5]);
                }
            }
            for (int i2 = 0; i2 < this.stripLengths[n2]; ++i2) {
                this.buffer.put(this.indices[n5++]);
            }
        }
    }

    private IntBuffer allocateBuffer(int n2) {
        this.buffer = ByteBuffer.allocateDirect(n2 << 2).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.buffer.position(0);
        return this.buffer;
    }

    public int profilerCount() {
        return this.indices.length - this.stripLengths.length * 2;
    }
}

