/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.LinuxDevice;
import net.java.games.input.LinuxJoystickAxis;
import net.java.games.input.LinuxJoystickButton;
import net.java.games.input.LinuxJoystickEvent;
import net.java.games.input.LinuxJoystickPOV;

final class LinuxJoystickDevice
implements LinuxDevice {
    public static final int JS_EVENT_BUTTON = 1;
    public static final int JS_EVENT_AXIS = 2;
    public static final int JS_EVENT_INIT = 128;
    public static final int AXIS_MAX_VALUE = Short.MAX_VALUE;
    private final long fd;
    private final String name;
    private final LinuxJoystickEvent joystick_event = new LinuxJoystickEvent();
    private final Event event = new Event();
    private final LinuxJoystickButton[] buttons;
    private final LinuxJoystickAxis[] axes;
    private final Map povXs = new HashMap();
    private final Map povYs = new HashMap();
    private final byte[] axisMap;
    private final char[] buttonMap;
    private EventQueue event_queue;
    private boolean closed;

    public LinuxJoystickDevice(String string) {
        this.fd = LinuxJoystickDevice.nOpen(string);
        try {
            this.name = this.getDeviceName();
            this.setBufferSize(32);
            this.buttons = new LinuxJoystickButton[this.getNumDeviceButtons()];
            this.axes = new LinuxJoystickAxis[this.getNumDeviceAxes()];
            this.axisMap = this.getDeviceAxisMap();
            this.buttonMap = this.getDeviceButtonMap();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private static final native long nOpen(String var0);

    public final synchronized void setBufferSize(int n2) {
        this.event_queue = new EventQueue(n2);
    }

    private final void processEvent(LinuxJoystickEvent linuxJoystickEvent) {
        int n2 = linuxJoystickEvent.getNumber();
        int n3 = linuxJoystickEvent.getType() & 0xFFFFFF7F;
        switch (n3) {
            case 1: {
                LinuxJoystickButton linuxJoystickButton;
                if (n2 < this.getNumButtons() && (linuxJoystickButton = this.buttons[n2]) != null) {
                    float f2 = linuxJoystickEvent.getValue();
                    linuxJoystickButton.setValue(f2);
                    this.event.set(linuxJoystickButton, f2, linuxJoystickEvent.getNanos());
                    break;
                }
                return;
            }
            case 2: {
                LinuxJoystickAxis linuxJoystickAxis;
                if (n2 < this.getNumAxes() && (linuxJoystickAxis = this.axes[n2]) != null) {
                    float f3 = (float)linuxJoystickEvent.getValue() / 32767.0f;
                    linuxJoystickAxis.setValue(f3);
                    if (this.povXs.containsKey(new Integer(n2))) {
                        LinuxJoystickPOV linuxJoystickPOV = (LinuxJoystickPOV)this.povXs.get(new Integer(n2));
                        linuxJoystickPOV.updateValue();
                        this.event.set(linuxJoystickPOV, linuxJoystickPOV.getPollData(), linuxJoystickEvent.getNanos());
                        break;
                    }
                    if (this.povYs.containsKey(new Integer(n2))) {
                        LinuxJoystickPOV linuxJoystickPOV = (LinuxJoystickPOV)this.povYs.get(new Integer(n2));
                        linuxJoystickPOV.updateValue();
                        this.event.set(linuxJoystickPOV, linuxJoystickPOV.getPollData(), linuxJoystickEvent.getNanos());
                        break;
                    }
                    this.event.set(linuxJoystickAxis, f3, linuxJoystickEvent.getNanos());
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        if (!this.event_queue.isFull()) {
            this.event_queue.add(this.event);
        }
    }

    public final void registerAxis(int n2, LinuxJoystickAxis linuxJoystickAxis) {
        this.axes[n2] = linuxJoystickAxis;
    }

    public final void registerButton(int n2, LinuxJoystickButton linuxJoystickButton) {
        this.buttons[n2] = linuxJoystickButton;
    }

    public final void registerPOV(LinuxJoystickPOV linuxJoystickPOV) {
        int n2;
        int n3;
        LinuxJoystickAxis linuxJoystickAxis = linuxJoystickPOV.getYAxis();
        LinuxJoystickAxis linuxJoystickAxis2 = linuxJoystickPOV.getXAxis();
        for (n3 = 0; n3 < this.axes.length && this.axes[n3] != linuxJoystickAxis; ++n3) {
        }
        for (n2 = 0; n2 < this.axes.length && this.axes[n2] != linuxJoystickAxis2; ++n2) {
        }
        this.povXs.put(new Integer(n3), linuxJoystickPOV);
        this.povYs.put(new Integer(n2), linuxJoystickPOV);
    }

    public final synchronized boolean getNextEvent(Event event) {
        return this.event_queue.getNextEvent(event);
    }

    public final synchronized void poll() {
        this.checkClosed();
        while (this.getNextDeviceEvent(this.joystick_event)) {
            this.processEvent(this.joystick_event);
        }
    }

    private final boolean getNextDeviceEvent(LinuxJoystickEvent linuxJoystickEvent) {
        return LinuxJoystickDevice.nGetNextEvent(this.fd, linuxJoystickEvent);
    }

    private static final native boolean nGetNextEvent(long var0, LinuxJoystickEvent var2);

    public final int getNumAxes() {
        return this.axes.length;
    }

    public final int getNumButtons() {
        return this.buttons.length;
    }

    public final byte[] getAxisMap() {
        return this.axisMap;
    }

    public final char[] getButtonMap() {
        return this.buttonMap;
    }

    private final int getNumDeviceButtons() {
        return LinuxJoystickDevice.nGetNumButtons(this.fd);
    }

    private static final native int nGetNumButtons(long var0);

    private final int getNumDeviceAxes() {
        return LinuxJoystickDevice.nGetNumAxes(this.fd);
    }

    private static final native int nGetNumAxes(long var0);

    private final byte[] getDeviceAxisMap() {
        return LinuxJoystickDevice.nGetAxisMap(this.fd);
    }

    private static final native byte[] nGetAxisMap(long var0);

    private final char[] getDeviceButtonMap() {
        return LinuxJoystickDevice.nGetButtonMap(this.fd);
    }

    private static final native char[] nGetButtonMap(long var0);

    private final int getVersion() {
        return LinuxJoystickDevice.nGetVersion(this.fd);
    }

    private static final native int nGetVersion(long var0);

    public final String getName() {
        return this.name;
    }

    private final String getDeviceName() {
        return LinuxJoystickDevice.nGetName(this.fd);
    }

    private static final native String nGetName(long var0);

    @Override
    public final synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            LinuxJoystickDevice.nClose(this.fd);
        }
    }

    private static final native void nClose(long var0);

    private final void checkClosed() {
        if (this.closed) {
            throw new IOException("Device is closed");
        }
    }

    protected void finalize() {
        this.close();
    }
}

