/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL20C
extends GL15C {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;

    protected GL20C() {
        throw new UnsupportedOperationException();
    }

    public static native int glCreateProgram();

    public static native void glDeleteProgram(int var0);

    public static native boolean glIsProgram(int var0);

    public static native int glCreateShader(int var0);

    public static native void glDeleteShader(int var0);

    public static native boolean glIsShader(int var0);

    public static native void glAttachShader(int var0, int var1);

    public static native void glDetachShader(int var0, int var1);

    public static native void nglShaderSource(int var0, int var1, long var2, long var4);

    public static void glShaderSource(int n2, PointerBuffer pointerBuffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, pointerBuffer.remaining());
        }
        GL20C.nglShaderSource(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddressSafe(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int n2, CharSequence ... charSequenceArray) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArrayi(memoryStack, MemoryUtil::memUTF8, charSequenceArray);
            GL20C.nglShaderSource(n2, charSequenceArray.length, l2, l2 - (long)(charSequenceArray.length << 2));
            APIUtil.apiArrayFree(l2, charSequenceArray.length);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            long l2 = APIUtil.apiArrayi(memoryStack, MemoryUtil::memUTF8, charSequence);
            GL20C.nglShaderSource(n2, 1, l2, l2 - 4L);
            APIUtil.apiArrayFree(l2, 1);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glCompileShader(int var0);

    public static native void glLinkProgram(int var0);

    public static native void glUseProgram(int var0);

    public static native void glValidateProgram(int var0);

    public static native void glUniform1f(int var0, float var1);

    public static native void glUniform2f(int var0, float var1, float var2);

    public static native void glUniform3f(int var0, float var1, float var2, float var3);

    public static native void glUniform4f(int var0, float var1, float var2, float var3, float var4);

    public static native void glUniform1i(int var0, int var1);

    public static native void glUniform2i(int var0, int var1, int var2);

    public static native void glUniform3i(int var0, int var1, int var2, int var3);

    public static native void glUniform4i(int var0, int var1, int var2, int var3, int var4);

    public static native void nglUniform1fv(int var0, int var1, long var2);

    public static void glUniform1fv(int n2, FloatBuffer floatBuffer) {
        GL20C.nglUniform1fv(n2, floatBuffer.remaining(), MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniform2fv(int var0, int var1, long var2);

    public static void glUniform2fv(int n2, FloatBuffer floatBuffer) {
        GL20C.nglUniform2fv(n2, floatBuffer.remaining() >> 1, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniform3fv(int var0, int var1, long var2);

    public static void glUniform3fv(int n2, FloatBuffer floatBuffer) {
        GL20C.nglUniform3fv(n2, floatBuffer.remaining() / 3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniform4fv(int var0, int var1, long var2);

    public static void glUniform4fv(int n2, FloatBuffer floatBuffer) {
        GL20C.nglUniform4fv(n2, floatBuffer.remaining() >> 2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniform1iv(int var0, int var1, long var2);

    public static void glUniform1iv(int n2, IntBuffer intBuffer) {
        GL20C.nglUniform1iv(n2, intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglUniform2iv(int var0, int var1, long var2);

    public static void glUniform2iv(int n2, IntBuffer intBuffer) {
        GL20C.nglUniform2iv(n2, intBuffer.remaining() >> 1, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglUniform3iv(int var0, int var1, long var2);

    public static void glUniform3iv(int n2, IntBuffer intBuffer) {
        GL20C.nglUniform3iv(n2, intBuffer.remaining() / 3, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglUniform4iv(int var0, int var1, long var2);

    public static void glUniform4iv(int n2, IntBuffer intBuffer) {
        GL20C.nglUniform4iv(n2, intBuffer.remaining() >> 2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GL20C.nglUniformMatrix2fv(n2, floatBuffer.remaining() >> 2, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GL20C.nglUniformMatrix3fv(n2, floatBuffer.remaining() / 9, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4fv(int n2, boolean bl2, FloatBuffer floatBuffer) {
        GL20C.nglUniformMatrix4fv(n2, floatBuffer.remaining() >> 4, bl2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglGetShaderiv(int var0, int var1, long var2);

    public static void glGetShaderiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GL20C.nglGetShaderiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetShaderi(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GL20C.nglGetShaderiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            int n5 = intBuffer.get(0);
            return n5;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetProgramiv(int var0, int var1, long var2);

    public static void glGetProgramiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GL20C.nglGetProgramiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgrami(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GL20C.nglGetProgramiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            int n5 = intBuffer.get(0);
            return n5;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetShaderInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GL20C.nglGetShaderInfoLog(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GL20C.nglGetShaderInfoLog(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetShaderInfoLog(int n2) {
        return GL20C.glGetShaderInfoLog(n2, GL20C.glGetShaderi(n2, 35716));
    }

    public static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramInfoLog(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GL20C.nglGetProgramInfoLog(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GL20C.nglGetProgramInfoLog(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetProgramInfoLog(int n2) {
        return GL20C.glGetProgramInfoLog(n2, GL20C.glGetProgrami(n2, 35716));
    }

    public static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4);

    public static void glGetAttachedShaders(int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GL20C.nglGetAttachedShaders(n2, intBuffer2.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2));
    }

    public static native int nglGetUniformLocation(int var0, long var1);

    public static int glGetUniformLocation(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GL20C.nglGetUniformLocation(n2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocation(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            int n4 = GL20C.nglGetUniformLocation(n2, l2);
            return n4;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveUniform(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        GL20C.nglGetActiveUniform(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer3 = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n4);
            GL20C.nglGetActiveUniform(n2, n3, n4, MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer3.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static String glGetActiveUniform(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return GL20C.glGetActiveUniform(n2, n3, GL20C.glGetProgrami(n2, 35719), intBuffer, intBuffer2);
    }

    public static native void nglGetUniformfv(int var0, int var1, long var2);

    public static void glGetUniformfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GL20C.nglGetUniformfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformf(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            FloatBuffer floatBuffer = memoryStack.callocFloat(1);
            GL20C.nglGetUniformfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
            float f2 = floatBuffer.get(0);
            return f2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetUniformiv(int var0, int var1, long var2);

    public static void glGetUniformiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GL20C.nglGetUniformiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformi(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GL20C.nglGetUniformiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            int n5 = intBuffer.get(0);
            return n5;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetShaderSource(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        GL20C.nglGetShaderSource(n2, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(n3);
        try {
            IntBuffer intBuffer = memoryStack.ints(0);
            GL20C.nglGetShaderSource(n2, n3, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8(byteBuffer, intBuffer.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(byteBuffer);
            memoryStack.setPointer(n4);
        }
    }

    public static String glGetShaderSource(int n2) {
        return GL20C.glGetShaderSource(n2, GL20C.glGetShaderi(n2, 35720));
    }

    public static native void glVertexAttrib1f(int var0, float var1);

    public static native void glVertexAttrib1s(int var0, short var1);

    public static native void glVertexAttrib1d(int var0, double var1);

    public static native void glVertexAttrib2f(int var0, float var1, float var2);

    public static native void glVertexAttrib2s(int var0, short var1, short var2);

    public static native void glVertexAttrib2d(int var0, double var1, double var3);

    public static native void glVertexAttrib3f(int var0, float var1, float var2, float var3);

    public static native void glVertexAttrib3s(int var0, short var1, short var2, short var3);

    public static native void glVertexAttrib3d(int var0, double var1, double var3, double var5);

    public static native void glVertexAttrib4f(int var0, float var1, float var2, float var3, float var4);

    public static native void glVertexAttrib4s(int var0, short var1, short var2, short var3, short var4);

    public static native void glVertexAttrib4d(int var0, double var1, double var3, double var5, double var7);

    public static native void glVertexAttrib4Nub(int var0, byte var1, byte var2, byte var3, byte var4);

    public static native void nglVertexAttrib1fv(int var0, long var1);

    public static void glVertexAttrib1fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 1);
        }
        GL20C.nglVertexAttrib1fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglVertexAttrib1sv(int var0, long var1);

    public static void glVertexAttrib1sv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 1);
        }
        GL20C.nglVertexAttrib1sv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib1dv(int var0, long var1);

    public static void glVertexAttrib1dv(int n2, DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, 1);
        }
        GL20C.nglVertexAttrib1dv(n2, MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nglVertexAttrib2fv(int var0, long var1);

    public static void glVertexAttrib2fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 2);
        }
        GL20C.nglVertexAttrib2fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglVertexAttrib2sv(int var0, long var1);

    public static void glVertexAttrib2sv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 2);
        }
        GL20C.nglVertexAttrib2sv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib2dv(int var0, long var1);

    public static void glVertexAttrib2dv(int n2, DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, 2);
        }
        GL20C.nglVertexAttrib2dv(n2, MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nglVertexAttrib3fv(int var0, long var1);

    public static void glVertexAttrib3fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 3);
        }
        GL20C.nglVertexAttrib3fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglVertexAttrib3sv(int var0, long var1);

    public static void glVertexAttrib3sv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 3);
        }
        GL20C.nglVertexAttrib3sv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib3dv(int var0, long var1);

    public static void glVertexAttrib3dv(int n2, DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, 3);
        }
        GL20C.nglVertexAttrib3dv(n2, MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nglVertexAttrib4fv(int var0, long var1);

    public static void glVertexAttrib4fv(int n2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        GL20C.nglVertexAttrib4fv(n2, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglVertexAttrib4sv(int var0, long var1);

    public static void glVertexAttrib4sv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 4);
        }
        GL20C.nglVertexAttrib4sv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib4dv(int var0, long var1);

    public static void glVertexAttrib4dv(int n2, DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, 4);
        }
        GL20C.nglVertexAttrib4dv(n2, MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nglVertexAttrib4iv(int var0, long var1);

    public static void glVertexAttrib4iv(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GL20C.nglVertexAttrib4iv(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglVertexAttrib4bv(int var0, long var1);

    public static void glVertexAttrib4bv(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 4);
        }
        GL20C.nglVertexAttrib4bv(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglVertexAttrib4ubv(int var0, long var1);

    public static void glVertexAttrib4ubv(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 4);
        }
        GL20C.nglVertexAttrib4ubv(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglVertexAttrib4usv(int var0, long var1);

    public static void glVertexAttrib4usv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 4);
        }
        GL20C.nglVertexAttrib4usv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib4uiv(int var0, long var1);

    public static void glVertexAttrib4uiv(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GL20C.nglVertexAttrib4uiv(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglVertexAttrib4Nbv(int var0, long var1);

    public static void glVertexAttrib4Nbv(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 4);
        }
        GL20C.nglVertexAttrib4Nbv(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglVertexAttrib4Nsv(int var0, long var1);

    public static void glVertexAttrib4Nsv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 4);
        }
        GL20C.nglVertexAttrib4Nsv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib4Niv(int var0, long var1);

    public static void glVertexAttrib4Niv(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GL20C.nglVertexAttrib4Niv(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglVertexAttrib4Nubv(int var0, long var1);

    public static void glVertexAttrib4Nubv(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, 4);
        }
        GL20C.nglVertexAttrib4Nubv(n2, MemoryUtil.memAddress(byteBuffer));
    }

    public static native void nglVertexAttrib4Nusv(int var0, long var1);

    public static void glVertexAttrib4Nusv(int n2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, 4);
        }
        GL20C.nglVertexAttrib4Nusv(n2, MemoryUtil.memAddress(shortBuffer));
    }

    public static native void nglVertexAttrib4Nuiv(int var0, long var1);

    public static void glVertexAttrib4Nuiv(int n2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 4);
        }
        GL20C.nglVertexAttrib4Nuiv(n2, MemoryUtil.memAddress(intBuffer));
    }

    public static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, ByteBuffer byteBuffer) {
        GL20C.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(byteBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, long l2) {
        GL20C.nglVertexAttribPointer(n2, n3, n4, bl2, n5, l2);
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, ShortBuffer shortBuffer) {
        GL20C.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(shortBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, IntBuffer intBuffer) {
        GL20C.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(intBuffer));
    }

    public static void glVertexAttribPointer(int n2, int n3, int n4, boolean bl2, int n5, FloatBuffer floatBuffer) {
        GL20C.nglVertexAttribPointer(n2, n3, n4, bl2, n5, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void glEnableVertexAttribArray(int var0);

    public static native void glDisableVertexAttribArray(int var0);

    public static native void nglBindAttribLocation(int var0, int var1, long var2);

    public static void glBindAttribLocation(int n2, int n3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        GL20C.nglBindAttribLocation(n2, n3, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindAttribLocation(int n2, int n3, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            GL20C.nglBindAttribLocation(n2, n3, l2);
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveAttrib(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
            Checks.check((Buffer)intBuffer3, 1);
        }
        GL20C.nglGetActiveAttrib(n2, n3, byteBuffer.remaining(), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
            Checks.check((Buffer)intBuffer2, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer3 = memoryStack.ints(0);
            ByteBuffer byteBuffer = memoryStack.malloc(n4);
            GL20C.nglGetActiveAttrib(n2, n3, n4, MemoryUtil.memAddress(intBuffer3), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memASCII(byteBuffer, intBuffer3.get(0));
            return string;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static String glGetActiveAttrib(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        return GL20C.glGetActiveAttrib(n2, n3, GL20C.glGetProgrami(n2, 35722), intBuffer, intBuffer2);
    }

    public static native int nglGetAttribLocation(int var0, long var1);

    public static int glGetAttribLocation(int n2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return GL20C.nglGetAttribLocation(n2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetAttribLocation(int n2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            int n4 = GL20C.nglGetAttribLocation(n2, l2);
            return n4;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nglGetVertexAttribiv(int var0, int var1, long var2);

    public static void glGetVertexAttribiv(int n2, int n3, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        GL20C.nglGetVertexAttribiv(n2, n3, MemoryUtil.memAddress(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexAttribi(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            GL20C.nglGetVertexAttribiv(n2, n3, MemoryUtil.memAddress(intBuffer));
            int n5 = intBuffer.get(0);
            return n5;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglGetVertexAttribfv(int var0, int var1, long var2);

    public static void glGetVertexAttribfv(int n2, int n3, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, 4);
        }
        GL20C.nglGetVertexAttribfv(n2, n3, MemoryUtil.memAddress(floatBuffer));
    }

    public static native void nglGetVertexAttribdv(int var0, int var1, long var2);

    public static void glGetVertexAttribdv(int n2, int n3, DoubleBuffer doubleBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, 4);
        }
        GL20C.nglGetVertexAttribdv(n2, n3, MemoryUtil.memAddress(doubleBuffer));
    }

    public static native void nglGetVertexAttribPointerv(int var0, int var1, long var2);

    public static void glGetVertexAttribPointerv(int n2, int n3, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        GL20C.nglGetVertexAttribPointerv(n2, n3, MemoryUtil.memAddress(pointerBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexAttribPointer(int n2, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            PointerBuffer pointerBuffer = memoryStack.callocPointer(1);
            GL20C.nglGetVertexAttribPointerv(n2, n3, MemoryUtil.memAddress(pointerBuffer));
            long l2 = pointerBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nglDrawBuffers(int var0, long var1);

    public static void glDrawBuffers(IntBuffer intBuffer) {
        GL20C.nglDrawBuffers(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDrawBuffers(int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n2);
            GL20C.nglDrawBuffers(1, MemoryUtil.memAddress(intBuffer));
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void glBlendEquationSeparate(int var0, int var1);

    public static native void glStencilOpSeparate(int var0, int var1, int var2, int var3);

    public static native void glStencilFuncSeparate(int var0, int var1, int var2, int var3);

    public static native void glStencilMaskSeparate(int var0, int var1);

    public static void glShaderSource(int n2, PointerBuffer pointerBuffer, int[] nArray) {
        long l2 = GL.getICD().glShaderSource;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, pointerBuffer.remaining());
        }
        JNI.callPPV(n2, pointerBuffer.remaining(), MemoryUtil.memAddress(pointerBuffer), nArray, l2);
    }

    public static void glUniform1fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glUniform1fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length, fArray, l2);
    }

    public static void glUniform2fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glUniform2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 1, fArray, l2);
    }

    public static void glUniform3fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glUniform3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length / 3, fArray, l2);
    }

    public static void glUniform4fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glUniform4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 2, fArray, l2);
    }

    public static void glUniform1iv(int n2, int[] nArray) {
        long l2 = GL.getICD().glUniform1iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length, nArray, l2);
    }

    public static void glUniform2iv(int n2, int[] nArray) {
        long l2 = GL.getICD().glUniform2iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length >> 1, nArray, l2);
    }

    public static void glUniform3iv(int n2, int[] nArray) {
        long l2 = GL.getICD().glUniform3iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length / 3, nArray, l2);
    }

    public static void glUniform4iv(int n2, int[] nArray) {
        long l2 = GL.getICD().glUniform4iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, nArray.length >> 2, nArray, l2);
    }

    public static void glUniformMatrix2fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GL.getICD().glUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 2, bl2, fArray, l2);
    }

    public static void glUniformMatrix3fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GL.getICD().glUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length / 9, bl2, fArray, l2);
    }

    public static void glUniformMatrix4fv(int n2, boolean bl2, float[] fArray) {
        long l2 = GL.getICD().glUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, fArray.length >> 4, bl2, fArray, l2);
    }

    public static void glGetShaderiv(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetProgramiv(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetShaderInfoLog(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetShaderInfoLog;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetProgramInfoLog(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetProgramInfoLog;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetAttachedShaders(int n2, int[] nArray, int[] nArray2) {
        long l2 = GL.getICD().glGetAttachedShaders;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, nArray2.length, nArray, nArray2, l2);
    }

    public static void glGetActiveUniform(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetActiveUniform;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        JNI.callPPPPV(n2, n3, byteBuffer.remaining(), nArray, nArray2, nArray3, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetUniformfv(int n2, int n3, float[] fArray) {
        long l2 = GL.getICD().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetUniformiv(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetShaderSource(int n2, int[] nArray, ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetShaderSource;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
        }
        JNI.callPPV(n2, byteBuffer.remaining(), nArray, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glVertexAttrib1fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 1);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib1sv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib1sv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 1);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib1dv(int n2, double[] dArray) {
        long l2 = GL.getICD().glVertexAttrib1dv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(dArray, 1);
        }
        JNI.callPV(n2, dArray, l2);
    }

    public static void glVertexAttrib2fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 2);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib2sv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib2sv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 2);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib2dv(int n2, double[] dArray) {
        long l2 = GL.getICD().glVertexAttrib2dv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(dArray, 2);
        }
        JNI.callPV(n2, dArray, l2);
    }

    public static void glVertexAttrib3fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 3);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib3sv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib3sv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 3);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib3dv(int n2, double[] dArray) {
        long l2 = GL.getICD().glVertexAttrib3dv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(dArray, 3);
        }
        JNI.callPV(n2, dArray, l2);
    }

    public static void glVertexAttrib4fv(int n2, float[] fArray) {
        long l2 = GL.getICD().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, fArray, l2);
    }

    public static void glVertexAttrib4sv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib4sv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 4);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib4dv(int n2, double[] dArray) {
        long l2 = GL.getICD().glVertexAttrib4dv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(dArray, 4);
        }
        JNI.callPV(n2, dArray, l2);
    }

    public static void glVertexAttrib4iv(int n2, int[] nArray) {
        long l2 = GL.getICD().glVertexAttrib4iv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glVertexAttrib4usv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib4usv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 4);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib4uiv(int n2, int[] nArray) {
        long l2 = GL.getICD().glVertexAttrib4uiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glVertexAttrib4Nsv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib4Nsv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 4);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib4Niv(int n2, int[] nArray) {
        long l2 = GL.getICD().glVertexAttrib4Niv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glVertexAttrib4Nusv(int n2, short[] sArray) {
        long l2 = GL.getICD().glVertexAttrib4Nusv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(sArray, 4);
        }
        JNI.callPV(n2, sArray, l2);
    }

    public static void glVertexAttrib4Nuiv(int n2, int[] nArray) {
        long l2 = GL.getICD().glVertexAttrib4Nuiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 4);
        }
        JNI.callPV(n2, nArray, l2);
    }

    public static void glGetActiveAttrib(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetActiveAttrib;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, 1);
            Checks.check(nArray2, 1);
            Checks.check(nArray3, 1);
        }
        JNI.callPPPPV(n2, n3, byteBuffer.remaining(), nArray, nArray2, nArray3, MemoryUtil.memAddress(byteBuffer), l2);
    }

    public static void glGetVertexAttribiv(int n2, int n3, int[] nArray) {
        long l2 = GL.getICD().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(nArray, 1);
        }
        JNI.callPV(n2, n3, nArray, l2);
    }

    public static void glGetVertexAttribfv(int n2, int n3, float[] fArray) {
        long l2 = GL.getICD().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(fArray, 4);
        }
        JNI.callPV(n2, n3, fArray, l2);
    }

    public static void glGetVertexAttribdv(int n2, int n3, double[] dArray) {
        long l2 = GL.getICD().glGetVertexAttribdv;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(dArray, 4);
        }
        JNI.callPV(n2, n3, dArray, l2);
    }

    public static void glDrawBuffers(int[] nArray) {
        long l2 = GL.getICD().glDrawBuffers;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(nArray.length, nArray, l2);
    }

    static {
        GL.initialize();
    }
}

