/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.Sockaddr$Buffer;

public class Sockaddr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SA_FAMILY;
    public static final int SA_DATA;

    protected Sockaddr(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected Sockaddr create(long l2, ByteBuffer byteBuffer) {
        return new Sockaddr(l2, byteBuffer);
    }

    public Sockaddr(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), Sockaddr.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short sa_family() {
        return Sockaddr.nsa_family(this.address());
    }

    public ByteBuffer sa_data() {
        return Sockaddr.nsa_data(this.address());
    }

    public byte sa_data(int n2) {
        return Sockaddr.nsa_data(this.address(), n2);
    }

    public Sockaddr sa_family(short s2) {
        Sockaddr.nsa_family(this.address(), s2);
        return this;
    }

    public Sockaddr sa_data(ByteBuffer byteBuffer) {
        Sockaddr.nsa_data(this.address(), byteBuffer);
        return this;
    }

    public Sockaddr sa_data(int n2, byte by2) {
        Sockaddr.nsa_data(this.address(), n2, by2);
        return this;
    }

    public Sockaddr set(short s2, ByteBuffer byteBuffer) {
        this.sa_family(s2);
        this.sa_data(byteBuffer);
        return this;
    }

    public Sockaddr set(Sockaddr sockaddr) {
        MemoryUtil.memCopy(sockaddr.address(), this.address(), SIZEOF);
        return this;
    }

    public static Sockaddr malloc() {
        return new Sockaddr(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static Sockaddr calloc() {
        return new Sockaddr(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static Sockaddr create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new Sockaddr(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static Sockaddr create(long l2) {
        return new Sockaddr(l2, null);
    }

    public static Sockaddr createSafe(long l2) {
        return l2 == 0L ? null : new Sockaddr(l2, null);
    }

    public static Sockaddr$Buffer malloc(int n2) {
        return new Sockaddr$Buffer(MemoryUtil.nmemAllocChecked(Sockaddr.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Sockaddr$Buffer calloc(int n2) {
        return new Sockaddr$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Sockaddr$Buffer create(int n2) {
        ByteBuffer byteBuffer = Sockaddr.__create(n2, SIZEOF);
        return new Sockaddr$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static Sockaddr$Buffer create(long l2, int n2) {
        return new Sockaddr$Buffer(l2, n2);
    }

    public static Sockaddr$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new Sockaddr$Buffer(l2, n2);
    }

    public static Sockaddr malloc(MemoryStack memoryStack) {
        return new Sockaddr(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static Sockaddr calloc(MemoryStack memoryStack) {
        return new Sockaddr(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Sockaddr$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Sockaddr$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Sockaddr$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Sockaddr$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nsa_family(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)SA_FAMILY);
    }

    public static ByteBuffer nsa_data(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)SA_DATA, 14);
    }

    public static byte nsa_data(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)SA_DATA + Checks.check(n2, 14) * 1L);
    }

    public static void nsa_family(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)SA_FAMILY, s2);
    }

    public static void nsa_data(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 14);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)SA_DATA, byteBuffer.remaining() * 1);
    }

    public static void nsa_data(long l2, int n2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)SA_DATA + Checks.check(n2, 14) * 1L, by2);
    }

    static {
        Struct$Layout struct$Layout = Sockaddr.__struct(Sockaddr.__member(2), Sockaddr.__array(1, 14));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        SA_FAMILY = struct$Layout.offsetof(0);
        SA_DATA = struct$Layout.offsetof(1);
    }
}

