/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.StatxTimestamp$Buffer;

public class StatxTimestamp
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TV_SEC;
    public static final int TV_NSEC;
    public static final int __RESERVED;

    protected StatxTimestamp(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected StatxTimestamp create(long l2, ByteBuffer byteBuffer) {
        return new StatxTimestamp(l2, byteBuffer);
    }

    public StatxTimestamp(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), StatxTimestamp.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long tv_sec() {
        return StatxTimestamp.ntv_sec(this.address());
    }

    public int tv_nsec() {
        return StatxTimestamp.ntv_nsec(this.address());
    }

    public StatxTimestamp tv_sec(long l2) {
        StatxTimestamp.ntv_sec(this.address(), l2);
        return this;
    }

    public StatxTimestamp tv_nsec(int n2) {
        StatxTimestamp.ntv_nsec(this.address(), n2);
        return this;
    }

    public StatxTimestamp set(long l2, int n2) {
        this.tv_sec(l2);
        this.tv_nsec(n2);
        return this;
    }

    public StatxTimestamp set(StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), this.address(), SIZEOF);
        return this;
    }

    public static StatxTimestamp malloc() {
        return new StatxTimestamp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StatxTimestamp calloc() {
        return new StatxTimestamp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StatxTimestamp create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new StatxTimestamp(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static StatxTimestamp create(long l2) {
        return new StatxTimestamp(l2, null);
    }

    public static StatxTimestamp createSafe(long l2) {
        return l2 == 0L ? null : new StatxTimestamp(l2, null);
    }

    public static StatxTimestamp$Buffer malloc(int n2) {
        return new StatxTimestamp$Buffer(MemoryUtil.nmemAllocChecked(StatxTimestamp.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static StatxTimestamp$Buffer calloc(int n2) {
        return new StatxTimestamp$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static StatxTimestamp$Buffer create(int n2) {
        ByteBuffer byteBuffer = StatxTimestamp.__create(n2, SIZEOF);
        return new StatxTimestamp$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static StatxTimestamp$Buffer create(long l2, int n2) {
        return new StatxTimestamp$Buffer(l2, n2);
    }

    public static StatxTimestamp$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new StatxTimestamp$Buffer(l2, n2);
    }

    public static StatxTimestamp malloc(MemoryStack memoryStack) {
        return new StatxTimestamp(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StatxTimestamp calloc(MemoryStack memoryStack) {
        return new StatxTimestamp(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static StatxTimestamp$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new StatxTimestamp$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static StatxTimestamp$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new StatxTimestamp$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long ntv_sec(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TV_SEC);
    }

    public static int ntv_nsec(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TV_NSEC);
    }

    public static int n__reserved(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)__RESERVED);
    }

    public static void ntv_sec(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TV_SEC, l3);
    }

    public static void ntv_nsec(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TV_NSEC, n2);
    }

    public static void n__reserved(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)__RESERVED, n2);
    }

    static {
        Struct$Layout struct$Layout = StatxTimestamp.__struct(StatxTimestamp.__member(8), StatxTimestamp.__member(4), StatxTimestamp.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TV_SEC = struct$Layout.offsetof(0);
        TV_NSEC = struct$Layout.offsetof(1);
        __RESERVED = struct$Layout.offsetof(2);
    }
}

