/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingNAPI$Buffer;

public class IOURingNAPI
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUSY_POLL_TO;
    public static final int PREFER_BUSY_POLL;
    public static final int PAD;
    public static final int RESV;

    protected IOURingNAPI(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingNAPI create(long l2, ByteBuffer byteBuffer) {
        return new IOURingNAPI(l2, byteBuffer);
    }

    public IOURingNAPI(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingNAPI.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int busy_poll_to() {
        return IOURingNAPI.nbusy_poll_to(this.address());
    }

    public byte prefer_busy_poll() {
        return IOURingNAPI.nprefer_busy_poll(this.address());
    }

    public IOURingNAPI busy_poll_to(int n2) {
        IOURingNAPI.nbusy_poll_to(this.address(), n2);
        return this;
    }

    public IOURingNAPI prefer_busy_poll(byte by2) {
        IOURingNAPI.nprefer_busy_poll(this.address(), by2);
        return this;
    }

    public IOURingNAPI set(int n2, byte by2) {
        this.busy_poll_to(n2);
        this.prefer_busy_poll(by2);
        return this;
    }

    public IOURingNAPI set(IOURingNAPI iOURingNAPI) {
        MemoryUtil.memCopy(iOURingNAPI.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingNAPI malloc() {
        return new IOURingNAPI(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingNAPI calloc() {
        return new IOURingNAPI(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingNAPI create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingNAPI(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingNAPI create(long l2) {
        return new IOURingNAPI(l2, null);
    }

    public static IOURingNAPI createSafe(long l2) {
        return l2 == 0L ? null : new IOURingNAPI(l2, null);
    }

    public static IOURingNAPI$Buffer malloc(int n2) {
        return new IOURingNAPI$Buffer(MemoryUtil.nmemAllocChecked(IOURingNAPI.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingNAPI$Buffer calloc(int n2) {
        return new IOURingNAPI$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingNAPI$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingNAPI.__create(n2, SIZEOF);
        return new IOURingNAPI$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingNAPI$Buffer create(long l2, int n2) {
        return new IOURingNAPI$Buffer(l2, n2);
    }

    public static IOURingNAPI$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingNAPI$Buffer(l2, n2);
    }

    public static IOURingNAPI malloc(MemoryStack memoryStack) {
        return new IOURingNAPI(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingNAPI calloc(MemoryStack memoryStack) {
        return new IOURingNAPI(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingNAPI$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingNAPI$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingNAPI$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingNAPI$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nbusy_poll_to(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)BUSY_POLL_TO);
    }

    public static byte nprefer_busy_poll(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)PREFER_BUSY_POLL);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 3);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 3) * 1L);
    }

    public static long nresv(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)RESV);
    }

    public static void nbusy_poll_to(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)BUSY_POLL_TO, n2);
    }

    public static void nprefer_busy_poll(long l2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)PREFER_BUSY_POLL, by2);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining() * 1);
    }

    public static void npad(long l2, int n2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 3) * 1L, by2);
    }

    public static void nresv(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)RESV, l3);
    }

    static {
        Struct$Layout struct$Layout = IOURingNAPI.__struct(IOURingNAPI.__member(4), IOURingNAPI.__member(1), IOURingNAPI.__array(1, 3), IOURingNAPI.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        BUSY_POLL_TO = struct$Layout.offsetof(0);
        PREFER_BUSY_POLL = struct$Layout.offsetof(1);
        PAD = struct$Layout.offsetof(2);
        RESV = struct$Layout.offsetof(3);
    }
}

