/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.KernelTimespec;
import org.lwjgl.system.linux.liburing.IOURingSyncCancelReg$Buffer;

public class IOURingSyncCancelReg
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int FD;
    public static final int FLAGS;
    public static final int TIMEOUT;
    public static final int OPCODE;
    public static final int PAD;
    public static final int PAD2;

    protected IOURingSyncCancelReg(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingSyncCancelReg create(long l2, ByteBuffer byteBuffer) {
        return new IOURingSyncCancelReg(l2, byteBuffer);
    }

    public IOURingSyncCancelReg(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingSyncCancelReg.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long addr() {
        return IOURingSyncCancelReg.naddr(this.address());
    }

    public int fd() {
        return IOURingSyncCancelReg.nfd(this.address());
    }

    public int flags() {
        return IOURingSyncCancelReg.nflags(this.address());
    }

    public KernelTimespec timeout() {
        return IOURingSyncCancelReg.ntimeout(this.address());
    }

    public byte opcode() {
        return IOURingSyncCancelReg.nopcode(this.address());
    }

    public IOURingSyncCancelReg addr(long l2) {
        IOURingSyncCancelReg.naddr(this.address(), l2);
        return this;
    }

    public IOURingSyncCancelReg fd(int n2) {
        IOURingSyncCancelReg.nfd(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg flags(int n2) {
        IOURingSyncCancelReg.nflags(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg timeout(KernelTimespec kernelTimespec) {
        IOURingSyncCancelReg.ntimeout(this.address(), kernelTimespec);
        return this;
    }

    public IOURingSyncCancelReg timeout(Consumer consumer) {
        consumer.accept(this.timeout());
        return this;
    }

    public IOURingSyncCancelReg opcode(byte by2) {
        IOURingSyncCancelReg.nopcode(this.address(), by2);
        return this;
    }

    public IOURingSyncCancelReg set(long l2, int n2, int n3, KernelTimespec kernelTimespec, byte by2) {
        this.addr(l2);
        this.fd(n2);
        this.flags(n3);
        this.timeout(kernelTimespec);
        this.opcode(by2);
        return this;
    }

    public IOURingSyncCancelReg set(IOURingSyncCancelReg iOURingSyncCancelReg) {
        MemoryUtil.memCopy(iOURingSyncCancelReg.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSyncCancelReg malloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingSyncCancelReg create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingSyncCancelReg(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingSyncCancelReg create(long l2) {
        return new IOURingSyncCancelReg(l2, null);
    }

    public static IOURingSyncCancelReg createSafe(long l2) {
        return l2 == 0L ? null : new IOURingSyncCancelReg(l2, null);
    }

    public static IOURingSyncCancelReg$Buffer malloc(int n2) {
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.nmemAllocChecked(IOURingSyncCancelReg.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingSyncCancelReg$Buffer calloc(int n2) {
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingSyncCancelReg$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingSyncCancelReg.__create(n2, SIZEOF);
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingSyncCancelReg$Buffer create(long l2, int n2) {
        return new IOURingSyncCancelReg$Buffer(l2, n2);
    }

    public static IOURingSyncCancelReg$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingSyncCancelReg$Buffer(l2, n2);
    }

    public static IOURingSyncCancelReg malloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingSyncCancelReg$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingSyncCancelReg$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingSyncCancelReg$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingSyncCancelReg$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long naddr(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR);
    }

    public static int nfd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FD);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static KernelTimespec ntimeout(long l2) {
        return KernelTimespec.create(l2 + (long)TIMEOUT);
    }

    public static byte nopcode(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OPCODE);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 7);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 7) * 1L);
    }

    public static LongBuffer npad2(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)PAD2, 3);
    }

    public static long npad2(long l2, int n2) {
        return MemoryUtil.memGetLong(l2 + (long)PAD2 + Checks.check(n2, 3) * 8L);
    }

    public static void naddr(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR, l3);
    }

    public static void nfd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FD, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void ntimeout(long l2, KernelTimespec kernelTimespec) {
        MemoryUtil.memCopy(kernelTimespec.address(), l2 + (long)TIMEOUT, KernelTimespec.SIZEOF);
    }

    public static void nopcode(long l2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)OPCODE, by2);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining() * 1);
    }

    public static void npad(long l2, int n2, byte by2) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 7) * 1L, by2);
    }

    public static void npad2(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)PAD2, longBuffer.remaining() * 8);
    }

    public static void npad2(long l2, int n2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)PAD2 + Checks.check(n2, 3) * 8L, l3);
    }

    static {
        Struct$Layout struct$Layout = IOURingSyncCancelReg.__struct(IOURingSyncCancelReg.__member(8), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(KernelTimespec.SIZEOF, KernelTimespec.ALIGNOF), IOURingSyncCancelReg.__member(1), IOURingSyncCancelReg.__array(1, 7), IOURingSyncCancelReg.__array(8, 3));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ADDR = struct$Layout.offsetof(0);
        FD = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        TIMEOUT = struct$Layout.offsetof(3);
        OPCODE = struct$Layout.offsetof(4);
        PAD = struct$Layout.offsetof(5);
        PAD2 = struct$Layout.offsetof(6);
    }
}

