/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.Struct;
import org.lwjgl.system.libc.LibCStdlib;
import org.lwjgl.system.macosx.EnumerationMutationHandlerI;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCMethodDescription$Buffer;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;
import org.lwjgl.system.macosx.ObjCPropertyAttribute$Buffer;
import org.lwjgl.system.macosx.ObjCRuntime$Functions;

public class ObjCRuntime {
    private static final SharedLibrary OBJC = Library.loadNative(ObjCRuntime.class, "org.lwjgl", "objc");
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;

    public static SharedLibrary getLibrary() {
        return OBJC;
    }

    protected ObjCRuntime() {
        throw new UnsupportedOperationException();
    }

    public static long object_copy(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.object_copy;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long object_dispose(long l2) {
        long l3 = ObjCRuntime$Functions.object_dispose;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long object_getClass(long l2) {
        long l3 = ObjCRuntime$Functions.object_getClass;
        return JNI.invokePP(l2, l3);
    }

    public static long object_setClass(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.object_setClass;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobject_getClassName(long l2) {
        long l3 = ObjCRuntime$Functions.object_getClassName;
        return JNI.invokePP(l2, l3);
    }

    public static String object_getClassName(long l2) {
        long l3 = ObjCRuntime.nobject_getClassName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long object_getIndexedIvars(long l2) {
        long l3 = ObjCRuntime$Functions.object_getIndexedIvars;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long object_getIvar(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.object_getIvar;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void object_setIvar(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.object_setIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static long nobject_setInstanceVariable(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.object_setInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    public static long object_setInstanceVariable(long l2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobject_setInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long object_setInstanceVariable(long l2, CharSequence charSequence, ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_setInstanceVariable(l2, l3, MemoryUtil.memAddress(byteBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobject_getInstanceVariable(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.object_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    public static long object_getInstanceVariable(long l2, ByteBuffer byteBuffer, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return ObjCRuntime.nobject_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(pointerBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long object_getInstanceVariable(long l2, CharSequence charSequence, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_getInstanceVariable(l2, l3, MemoryUtil.memAddress(pointerBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getClass;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_getClass(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getClass(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getMetaClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getMetaClass;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_getMetaClass(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getMetaClass(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getMetaClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_lookUpClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_lookUpClass;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_lookUpClass(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_lookUpClass(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_lookUpClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getRequiredClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getRequiredClass;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_getRequiredClass(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getRequiredClass(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getRequiredClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int nobjc_getClassList(long l2, int n2) {
        long l3 = ObjCRuntime$Functions.objc_getClassList;
        return JNI.invokePI(l2, n2, l3);
    }

    public static int objc_getClassList(PointerBuffer pointerBuffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer));
    }

    public static long nobjc_copyClassList(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyClassList;
        return JNI.invokePP(l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyClassList(MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l2, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getName(long l2) {
        long l3 = ObjCRuntime$Functions.class_getName;
        return JNI.invokePP(l2, l3);
    }

    public static String class_getName(long l2) {
        long l3 = ObjCRuntime.nclass_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static boolean class_isMetaClass(long l2) {
        long l3 = ObjCRuntime$Functions.class_isMetaClass;
        return JNI.invokePZ(l2, l3);
    }

    public static long class_getSuperclass(long l2) {
        long l3 = ObjCRuntime$Functions.class_getSuperclass;
        return JNI.invokePP(l2, l3);
    }

    public static int class_getVersion(long l2) {
        long l3 = ObjCRuntime$Functions.class_getVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static void class_setVersion(long l2, int n2) {
        long l3 = ObjCRuntime$Functions.class_setVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, n2, l3);
    }

    public static long class_getInstanceSize(long l2) {
        long l3 = ObjCRuntime$Functions.class_getInstanceSize;
        return JNI.invokePP(l2, l3);
    }

    public static long nclass_getInstanceVariable(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long class_getInstanceVariable(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getInstanceVariable(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getInstanceVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getClassVariable(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getClassVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long class_getClassVariable(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getClassVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getClassVariable(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getClassVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyIvarList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyIvarList;
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyIvarList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyIvarList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long class_getInstanceMethod(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getInstanceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long class_getClassMethod(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getClassMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long class_getMethodImplementation(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getMethodImplementation;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static boolean class_respondsToSelector(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_respondsToSelector;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyMethodList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyMethodList;
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyMethodList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyMethodList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean class_conformsToProtocol(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyProtocolList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyProtocolList;
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyProtocolList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getProperty(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getProperty;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long class_getProperty(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getProperty(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_getProperty(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getProperty(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyPropertyList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyPropertyList;
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer class_copyPropertyList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getIvarLayout(long l2) {
        long l3 = ObjCRuntime$Functions.class_getIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String class_getIvarLayout(long l2) {
        long l3 = ObjCRuntime.nclass_getIvarLayout(l2);
        return MemoryUtil.memASCIISafe(l3);
    }

    public static long nclass_getWeakIvarLayout(long l2) {
        long l3 = ObjCRuntime$Functions.class_getWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String class_getWeakIvarLayout(long l2) {
        long l3 = ObjCRuntime.nclass_getWeakIvarLayout(l2);
        return MemoryUtil.memASCIISafe(l3);
    }

    public static boolean nclass_addMethod(long l2, long l3, long l4, long l5) {
        long l6 = ObjCRuntime$Functions.class_addMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPZ(l2, l3, l4, l5, l6);
    }

    public static boolean class_addMethod(long l2, long l3, long l4, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addMethod(long l2, long l3, long l4, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl2 = ObjCRuntime.nclass_addMethod(l2, l3, l4, l5);
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_replaceMethod(long l2, long l3, long l4, long l5) {
        long l6 = ObjCRuntime$Functions.class_replaceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPP(l2, l3, l4, l5, l6);
    }

    public static long class_replaceMethod(long l2, long l3, long l4, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_replaceMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long class_replaceMethod(long l2, long l3, long l4, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            long l6 = ObjCRuntime.nclass_replaceMethod(l2, l3, l4, l5);
            return l6;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean nclass_addIvar(long l2, long l3, long l4, byte by2, long l5) {
        long l6 = ObjCRuntime$Functions.class_addIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPUPZ(l2, l3, l4, by2, l5, l6);
    }

    public static boolean class_addIvar(long l2, ByteBuffer byteBuffer, long l3, byte by2, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        return ObjCRuntime.nclass_addIvar(l2, MemoryUtil.memAddress(byteBuffer), l3, by2, MemoryUtil.memAddress(byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addIvar(long l2, CharSequence charSequence, long l3, byte by2, CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl2 = ObjCRuntime.nclass_addIvar(l2, l4, l3, by2, l5);
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean class_addProtocol(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static boolean nclass_addProperty(long l2, long l3, long l4, int n2) {
        long l5 = ObjCRuntime$Functions.class_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        return JNI.invokePPPZ(l2, l3, l4, n2, l5);
    }

    public static boolean class_addProperty(long l2, ByteBuffer byteBuffer, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addProperty(l2, MemoryUtil.memAddress(byteBuffer), objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean class_addProperty(long l2, CharSequence charSequence, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            boolean bl2 = ObjCRuntime.nclass_addProperty(l2, l3, objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining());
            return bl2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_replaceProperty(long l2, long l3, long l4, int n2) {
        long l5 = ObjCRuntime$Functions.class_replaceProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, l5);
    }

    public static void class_replaceProperty(long l2, ByteBuffer byteBuffer, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_replaceProperty(l2, MemoryUtil.memAddress(byteBuffer), objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_replaceProperty(long l2, CharSequence charSequence, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_replaceProperty(l2, l3, objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining());
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setIvarLayout(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_setIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setIvarLayout(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_setIvarLayout(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setIvarLayout(l2, l3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setWeakIvarLayout(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_setWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setWeakIvarLayout(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void class_setWeakIvarLayout(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setWeakIvarLayout(l2, l3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long class_createInstance(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_createInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobjc_constructInstance(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_constructInstance;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long objc_constructInstance(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkSafe((Buffer)byteBuffer, ObjCRuntime.class_getInstanceSize(l2));
        }
        return ObjCRuntime.nobjc_constructInstance(l2, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static long objc_destructInstance(long l2) {
        long l3 = ObjCRuntime$Functions.objc_destructInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nobjc_allocateClassPair(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.objc_allocateClassPair;
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    public static long objc_allocateClassPair(long l2, ByteBuffer byteBuffer, long l3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateClassPair(l2, MemoryUtil.memAddress(byteBuffer), l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_allocateClassPair(long l2, CharSequence charSequence, long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            long l5 = ObjCRuntime.nobjc_allocateClassPair(l2, l4, l3);
            return l5;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerClassPair(long l2) {
        long l3 = ObjCRuntime$Functions.objc_registerClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void objc_disposeClassPair(long l2) {
        long l3 = ObjCRuntime$Functions.objc_disposeClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static long method_getName(long l2) {
        long l3 = ObjCRuntime$Functions.method_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long method_getImplementation(long l2) {
        long l3 = ObjCRuntime$Functions.method_getImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nmethod_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime$Functions.method_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String method_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime.nmethod_getTypeEncoding(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static int method_getNumberOfArguments(long l2) {
        long l3 = ObjCRuntime$Functions.method_getNumberOfArguments;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static long nmethod_copyReturnType(long l2) {
        long l3 = ObjCRuntime$Functions.method_copyReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String method_copyReturnType(long l2) {
        long l3 = ObjCRuntime.nmethod_copyReturnType(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nmethod_copyArgumentType(long l2, int n2) {
        long l3 = ObjCRuntime$Functions.method_copyArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, n2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String method_copyArgumentType(long l2, int n2) {
        long l3 = 0L;
        try {
            l3 = ObjCRuntime.nmethod_copyArgumentType(l2, n2);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    public static void nmethod_getReturnType(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.method_getReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static void method_getReturnType(long l2, ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String method_getReturnType(long l2, long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nmethod_getArgumentType(long l2, int n2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.method_getArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, n2, l3, l4, l5);
    }

    public static void method_getArgumentType(long l2, int n2, ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String method_getArgumentType(long l2, int n2, long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static long method_setImplementation(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.method_setImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void method_exchangeImplementations(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.method_exchangeImplementations;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static long nivar_getName(long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String ivar_getName(long l2) {
        long l3 = ObjCRuntime.nivar_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nivar_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String ivar_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime.nivar_getTypeEncoding(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long ivar_getOffset(long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getOffset;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nproperty_getName(long l2) {
        long l3 = ObjCRuntime$Functions.property_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String property_getName(long l2) {
        long l3 = ObjCRuntime.nproperty_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nproperty_getAttributes(long l2) {
        long l3 = ObjCRuntime$Functions.property_getAttributes;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String property_getAttributes(long l2) {
        long l3 = ObjCRuntime.nproperty_getAttributes(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nproperty_copyAttributeList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.property_copyAttributeList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCPropertyAttribute$Buffer property_copyAttributeList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nproperty_copyAttributeList(l2, MemoryUtil.memAddress(intBuffer));
            ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer = ObjCPropertyAttribute.createSafe(l3, intBuffer.get(0));
            return objCPropertyAttribute$Buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nproperty_copyAttributeValue(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.property_copyAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String property_copyAttributeValue(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        long l3 = 0L;
        try {
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String property_copyAttributeValue(long l2, CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        long l3 = 0L;
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, l4);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getProtocol(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getProtocol;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_getProtocol(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_getProtocol(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getProtocol(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyProtocolList(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyProtocolList;
        return JNI.invokePP(l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyProtocolList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyProtocolList(MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l2, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean protocol_conformsToProtocol(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static boolean protocol_isEqual(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nprotocol_getName(long l2) {
        long l3 = ObjCRuntime$Functions.protocol_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String protocol_getName(long l2) {
        long l3 = ObjCRuntime.nprotocol_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, boolean var4, boolean var5, long var6, long var8);

    public static void nprotocol_getMethodDescription(long l2, long l3, boolean bl2, boolean bl3, long l4) {
        long l5 = ObjCRuntime$Functions.protocol_getMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl2, bl3, l5, l4);
    }

    public static ObjCMethodDescription protocol_getMethodDescription(long l2, long l3, boolean bl2, boolean bl3, ObjCMethodDescription objCMethodDescription) {
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl2, bl3, objCMethodDescription.address());
        return objCMethodDescription;
    }

    public static long nprotocol_copyMethodDescriptionList(long l2, boolean bl2, boolean bl3, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyMethodDescriptionList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, bl2, bl3, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCMethodDescription$Buffer protocol_copyMethodDescriptionList(long l2, boolean bl2, boolean bl3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyMethodDescriptionList(l2, bl2, bl3, MemoryUtil.memAddress(intBuffer));
            ObjCMethodDescription$Buffer objCMethodDescription$Buffer = ObjCMethodDescription.createSafe(l3, intBuffer.get(0));
            return objCMethodDescription$Buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_getProperty(long l2, long l3, boolean bl2, boolean bl3) {
        long l4 = ObjCRuntime$Functions.protocol_getProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, bl2, bl3, l4);
    }

    public static long protocol_getProperty(long l2, ByteBuffer byteBuffer, boolean bl2, boolean bl3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nprotocol_getProperty(l2, MemoryUtil.memAddress(byteBuffer), bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long protocol_getProperty(long l2, CharSequence charSequence, boolean bl2, boolean bl3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nprotocol_getProperty(l2, l3, bl2, bl3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyPropertyList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyPropertyList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer protocol_copyPropertyList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyProtocolList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyProtocolList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer protocol_copyProtocolList(long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_allocateProtocol(long l2) {
        long l3 = ObjCRuntime$Functions.objc_allocateProtocol;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_allocateProtocol(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long objc_allocateProtocol(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_allocateProtocol(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerProtocol(long l2) {
        long l3 = ObjCRuntime$Functions.objc_registerProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nprotocol_addMethodDescription(long l2, long l3, long l4, boolean bl2, boolean bl3) {
        long l5 = ObjCRuntime$Functions.protocol_addMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPPV(l2, l3, l4, bl2, bl3, l5);
    }

    public static void protocol_addMethodDescription(long l2, long l3, ByteBuffer byteBuffer, boolean bl2, boolean bl3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addMethodDescription(l2, l3, MemoryUtil.memAddress(byteBuffer), bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void protocol_addMethodDescription(long l2, long l3, CharSequence charSequence, boolean bl2, boolean bl3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addMethodDescription(l2, l3, l4, bl2, bl3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void protocol_addProtocol(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void nprotocol_addProperty(long l2, long l3, long l4, int n2, boolean bl2, boolean bl3) {
        long l5 = ObjCRuntime$Functions.protocol_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, bl2, bl3, l5);
    }

    public static void protocol_addProperty(long l2, ByteBuffer byteBuffer, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer, boolean bl2, boolean bl3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addProperty(l2, MemoryUtil.memAddress(byteBuffer), objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining(), bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void protocol_addProperty(long l2, CharSequence charSequence, ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer, boolean bl2, boolean bl3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addProperty(l2, l3, objCPropertyAttribute$Buffer.address(), objCPropertyAttribute$Buffer.remaining(), bl2, bl3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyImageNames(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyImageNames;
        return JNI.invokePP(l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyImageNames() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyImageNames(MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l2, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getImageName(long l2) {
        long l3 = ObjCRuntime$Functions.class_getImageName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String class_getImageName(long l2) {
        long l3 = ObjCRuntime.nclass_getImageName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nobjc_copyClassNamesForImage(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_copyClassNamesForImage;
        return JNI.invokePPP(l2, l3, l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassNamesForImage(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l2, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PointerBuffer objc_copyClassNamesForImage(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_copyClassNamesForImage(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_getName(long l2) {
        long l3 = ObjCRuntime$Functions.sel_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static String sel_getName(long l2) {
        long l3 = ObjCRuntime.nsel_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nsel_getUid(long l2) {
        long l3 = ObjCRuntime$Functions.sel_getUid;
        return JNI.invokePP(l2, l3);
    }

    public static long sel_getUid(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long sel_getUid(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nsel_getUid(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_registerName(long l2) {
        long l3 = ObjCRuntime$Functions.sel_registerName;
        return JNI.invokePP(l2, l3);
    }

    public static long sel_registerName(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long sel_registerName(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nsel_registerName(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean sel_isEqual(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.sel_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static void objc_enumerationMutation(long l2) {
        long l3 = ObjCRuntime$Functions.objc_enumerationMutation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nobjc_setEnumerationMutationHandler(long l2) {
        long l3 = ObjCRuntime$Functions.objc_setEnumerationMutationHandler;
        JNI.invokePV(l2, l3);
    }

    public static void objc_setEnumerationMutationHandler(EnumerationMutationHandlerI enumerationMutationHandlerI) {
        ObjCRuntime.nobjc_setEnumerationMutationHandler(enumerationMutationHandlerI.address());
    }

    public static long imp_implementationWithBlock(long l2) {
        long l3 = ObjCRuntime$Functions.imp_implementationWithBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long imp_getBlock(long l2) {
        long l3 = ObjCRuntime$Functions.imp_getBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static boolean imp_removeBlock(long l2) {
        long l3 = ObjCRuntime$Functions.imp_removeBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePZ(l2, l3);
    }

    public static long nobjc_loadWeak(long l2) {
        long l3 = ObjCRuntime$Functions.objc_loadWeak;
        return JNI.invokePP(l2, l3);
    }

    public static long objc_loadWeak(PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(pointerBuffer));
    }

    public static long nobjc_storeWeak(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_storeWeak;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long objc_storeWeak(PointerBuffer pointerBuffer, long l2) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(pointerBuffer), l2);
    }

    public static void objc_setAssociatedObject(long l2, long l3, long l4, long l5) {
        long l6 = ObjCRuntime$Functions.objc_setAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPPV(l2, l3, l4, l5, l6);
    }

    public static long objc_getAssociatedObject(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_getAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void objc_removeAssociatedObjects(long l2) {
        long l3 = ObjCRuntime$Functions.objc_removeAssociatedObjects;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return OBJC;
    }
}

