/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.MOUSEINPUT$Buffer;

public class MOUSEINPUT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DX;
    public static final int DY;
    public static final int MOUSEDATA;
    public static final int DWFLAGS;
    public static final int TIME;
    public static final int DWEXTRAINFO;

    protected MOUSEINPUT(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected MOUSEINPUT create(long l2, ByteBuffer byteBuffer) {
        return new MOUSEINPUT(l2, byteBuffer);
    }

    public MOUSEINPUT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), MOUSEINPUT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int dx() {
        return MOUSEINPUT.ndx(this.address());
    }

    public int dy() {
        return MOUSEINPUT.ndy(this.address());
    }

    public int mouseData() {
        return MOUSEINPUT.nmouseData(this.address());
    }

    public int dwFlags() {
        return MOUSEINPUT.ndwFlags(this.address());
    }

    public int time() {
        return MOUSEINPUT.ntime(this.address());
    }

    public long dwExtraInfo() {
        return MOUSEINPUT.ndwExtraInfo(this.address());
    }

    public MOUSEINPUT dx(int n2) {
        MOUSEINPUT.ndx(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dy(int n2) {
        MOUSEINPUT.ndy(this.address(), n2);
        return this;
    }

    public MOUSEINPUT mouseData(int n2) {
        MOUSEINPUT.nmouseData(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dwFlags(int n2) {
        MOUSEINPUT.ndwFlags(this.address(), n2);
        return this;
    }

    public MOUSEINPUT time(int n2) {
        MOUSEINPUT.ntime(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dwExtraInfo(long l2) {
        MOUSEINPUT.ndwExtraInfo(this.address(), l2);
        return this;
    }

    public MOUSEINPUT set(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.dx(n2);
        this.dy(n3);
        this.mouseData(n4);
        this.dwFlags(n5);
        this.time(n6);
        this.dwExtraInfo(l2);
        return this;
    }

    public MOUSEINPUT set(MOUSEINPUT mOUSEINPUT) {
        MemoryUtil.memCopy(mOUSEINPUT.address(), this.address(), SIZEOF);
        return this;
    }

    public static MOUSEINPUT malloc() {
        return new MOUSEINPUT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MOUSEINPUT calloc() {
        return new MOUSEINPUT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MOUSEINPUT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new MOUSEINPUT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static MOUSEINPUT create(long l2) {
        return new MOUSEINPUT(l2, null);
    }

    public static MOUSEINPUT createSafe(long l2) {
        return l2 == 0L ? null : new MOUSEINPUT(l2, null);
    }

    public static MOUSEINPUT$Buffer malloc(int n2) {
        return new MOUSEINPUT$Buffer(MemoryUtil.nmemAllocChecked(MOUSEINPUT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static MOUSEINPUT$Buffer calloc(int n2) {
        return new MOUSEINPUT$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static MOUSEINPUT$Buffer create(int n2) {
        ByteBuffer byteBuffer = MOUSEINPUT.__create(n2, SIZEOF);
        return new MOUSEINPUT$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static MOUSEINPUT$Buffer create(long l2, int n2) {
        return new MOUSEINPUT$Buffer(l2, n2);
    }

    public static MOUSEINPUT$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new MOUSEINPUT$Buffer(l2, n2);
    }

    public static MOUSEINPUT mallocStack() {
        return MOUSEINPUT.malloc(MemoryStack.stackGet());
    }

    public static MOUSEINPUT callocStack() {
        return MOUSEINPUT.calloc(MemoryStack.stackGet());
    }

    public static MOUSEINPUT mallocStack(MemoryStack memoryStack) {
        return MOUSEINPUT.malloc(memoryStack);
    }

    public static MOUSEINPUT callocStack(MemoryStack memoryStack) {
        return MOUSEINPUT.calloc(memoryStack);
    }

    public static MOUSEINPUT$Buffer mallocStack(int n2) {
        return MOUSEINPUT.malloc(n2, MemoryStack.stackGet());
    }

    public static MOUSEINPUT$Buffer callocStack(int n2) {
        return MOUSEINPUT.calloc(n2, MemoryStack.stackGet());
    }

    public static MOUSEINPUT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return MOUSEINPUT.malloc(n2, memoryStack);
    }

    public static MOUSEINPUT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return MOUSEINPUT.calloc(n2, memoryStack);
    }

    public static MOUSEINPUT malloc(MemoryStack memoryStack) {
        return new MOUSEINPUT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MOUSEINPUT calloc(MemoryStack memoryStack) {
        return new MOUSEINPUT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static MOUSEINPUT$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new MOUSEINPUT$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static MOUSEINPUT$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new MOUSEINPUT$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ndx(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DX);
    }

    public static int ndy(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DY);
    }

    public static int nmouseData(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MOUSEDATA);
    }

    public static int ndwFlags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DWFLAGS);
    }

    public static int ntime(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TIME);
    }

    public static long ndwExtraInfo(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DWEXTRAINFO);
    }

    public static void ndx(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DX, n2);
    }

    public static void ndy(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DY, n2);
    }

    public static void nmouseData(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MOUSEDATA, n2);
    }

    public static void ndwFlags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DWFLAGS, n2);
    }

    public static void ntime(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TIME, n2);
    }

    public static void ndwExtraInfo(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DWEXTRAINFO, l3);
    }

    static {
        Struct$Layout struct$Layout = MOUSEINPUT.__struct(MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        DX = struct$Layout.offsetof(0);
        DY = struct$Layout.offsetof(1);
        MOUSEDATA = struct$Layout.offsetof(2);
        DWFLAGS = struct$Layout.offsetof(3);
        TIME = struct$Layout.offsetof(4);
        DWEXTRAINFO = struct$Layout.offsetof(5);
    }
}

