/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import java.util.Arrays;

public class SparseIntArray
implements Cloneable {
    private int[] mKeys;
    private int[] mValues;
    private int mSize;

    public SparseIntArray() {
        this(0);
    }

    public SparseIntArray(int n2) {
        if (n2 == 0) {
            this.mKeys = new int[0];
            this.mValues = new int[0];
        } else {
            this.mKeys = new int[n2];
            this.mValues = new int[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public SparseIntArray clone() {
        SparseIntArray sparseIntArray = null;
        try {
            sparseIntArray = (SparseIntArray)super.clone();
            sparseIntArray.mKeys = (int[])this.mKeys.clone();
            sparseIntArray.mValues = (int[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return sparseIntArray;
    }

    public int get(int n2) {
        return this.get(n2, 0);
    }

    public int get(int n2, int n3) {
        int n4 = SparseIntArray.search(this.mKeys, this.mSize, n2);
        if (n4 < 0) {
            return n3;
        }
        return this.mValues[n4];
    }

    public void delete(int n2) {
        int n3 = SparseIntArray.search(this.mKeys, this.mSize, n2);
        if (n3 >= 0) {
            this.removeAt(n3);
        }
    }

    public void removeAt(int n2) {
        System.arraycopy(this.mKeys, n2 + 1, this.mKeys, n2, this.mSize - (n2 + 1));
        System.arraycopy(this.mValues, n2 + 1, this.mValues, n2, this.mSize - (n2 + 1));
        --this.mSize;
    }

    public void put(int n2, int n3) {
        int n4 = SparseIntArray.search(this.mKeys, this.mSize, n2);
        if (n4 >= 0) {
            this.mValues[n4] = n3;
        } else {
            this.mKeys = SparseIntArray.insert(this.mKeys, this.mSize, n4 ^= 0xFFFFFFFF, n2);
            this.mValues = SparseIntArray.insert(this.mValues, this.mSize, n4, n3);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int n2) {
        if (n2 >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.mKeys[n2];
    }

    public int valueAt(int n2) {
        if (n2 >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.mValues[n2];
    }

    public void setValueAt(int n2, int n3) {
        if (n2 >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.mValues[n2] = n3;
    }

    public int indexOfKey(int n2) {
        return SparseIntArray.search(this.mKeys, this.mSize, n2);
    }

    public int indexOfValue(int n2) {
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int n2, int n3) {
        if (this.mSize != 0 && n2 <= this.mKeys[this.mSize - 1]) {
            this.put(n2, n3);
            return;
        }
        this.mKeys = SparseIntArray.append(this.mKeys, this.mSize, n2);
        this.mValues = SparseIntArray.append(this.mValues, this.mSize, n3);
        ++this.mSize;
    }

    public int[] copyKeys() {
        if (this.size() == 0) {
            return null;
        }
        return Arrays.copyOf(this.mKeys, this.size());
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 28);
        stringBuilder.append('{');
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            int n2 = this.keyAt(i2);
            stringBuilder.append(n2);
            stringBuilder.append('=');
            int n3 = this.valueAt(i2);
            stringBuilder.append(n3);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static int search(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n2 && i2 < nArray.length; ++i2) {
            if (nArray[i2] != n3) continue;
            return i2;
        }
        return -1;
    }

    private static int[] append(int[] nArray, int n2, int n3) {
        if (nArray.length <= n2) {
            int[] nArray2 = nArray;
            nArray = new int[n2 + 16];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        nArray[n2] = n3;
        return nArray;
    }

    private static int[] insert(int[] nArray, int n2, int n3, int n4) {
        int n5;
        if (nArray.length <= n2) {
            int[] nArray2 = nArray;
            nArray = new int[n2 + 16];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
        }
        if ((n5 = n2 - n3) > 0) {
            System.arraycopy(nArray, n3, nArray, n3 + 1, n5);
        }
        nArray[n3] = n4;
        return nArray;
    }
}

