/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.Settings;
import emulator.custom.CustomJarResources;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.microedition.lcdui.Image;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.Loader;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureData;

public final class TextureImpl {
    static int sLastId;
    public final TextureData image;
    private final boolean isMutable;
    int mTexId = -1;

    public TextureImpl() {
        this.image = new TextureData(256, 256);
        this.isMutable = true;
    }

    public TextureImpl(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            this.image = Loader.loadBmpData(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.err.println("Error loading data");
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        this.isMutable = false;
    }

    public TextureImpl(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.image = Loader.loadBmpData(byArray, n2, n3);
        }
        catch (Exception exception) {
            System.err.println("Error loading data");
            exception.printStackTrace();
            throw exception;
        }
        this.isMutable = false;
    }

    public TextureImpl(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        byte[] byArray = CustomJarResources.getBytes(string);
        if (byArray == null) {
            throw new IOException();
        }
        try {
            this.image = Loader.loadBmpData(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.err.println("Error loading data from [" + string + "]");
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
        this.isMutable = false;
    }

    public TextureImpl(Image image, int n2, int n3, int n4, int n5) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n4 <= 0 || n5 <= 0 || n2 + n4 > image.getWidth() || n3 + n5 > image.getHeight()) {
            throw new IllegalArgumentException();
        }
        this.isMutable = false;
        this.image = new TextureData(n4, n5);
        int n6 = n4 * n5;
        int[] nArray = new int[n6];
        image.getRGB(nArray, 0, n4, n2, n3, n4, n5);
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = nArray[i2];
            nArray[i2] = n7 << 8 | n7 >>> 24;
        }
        this.image.getRaster().asIntBuffer().put(nArray);
    }

    public void dispose() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    int getId() {
        if (!GL11.glIsTexture(this.mTexId)) {
            this.generateId();
        } else if (!this.isMutable) {
            return this.mTexId;
        }
        this.loadToGL();
        return this.mTexId;
    }

    public int getWidth() {
        return this.image.width;
    }

    public int getHeight() {
        return this.image.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateId() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        Class<TextureImpl> clazz = TextureImpl.class;
        synchronized (TextureImpl.class) {
            while (intBuffer.get(0) <= sLastId) {
                intBuffer.rewind();
                GL11.glGenTextures(intBuffer);
            }
            sLastId = intBuffer.get(0);
            this.mTexId = intBuffer.get(0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Render.checkGlError("glGenTextures");
            return;
        }
    }

    private void loadToGL() {
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, this.mTexId);
        boolean bl2 = Settings.mascotTextureFilter;
        GL11.glTexParameteri(3553, 10241, bl2 ? 9729 : 9728);
        GL11.glTexParameteri(3553, 10240, bl2 ? 9729 : 9728);
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        GL11.glTexImage2D(3553, 0, 6408, this.image.width, this.image.height, 0, 6408, 5121, this.image.getRaster());
        GL11.glBindTexture(3553, 0);
    }

    protected void finalize() {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

