#include <windows.h>
#include <dsound.h>
#include <stdio.h>
#include "AudioCode.h"
#include "AudioSpec.h"

#define USE_PRINTF

#ifdef USE_PRINTF
	#define dprintf printf
#else
	#define dprintf //
#endif

// TODO: Clean this up a bit...
DWORD last_pos = 0, write_pos = 0, play_pos = 0, temp = 0, next_pos = 0;
DWORD last_play = 0;
DWORD last_write = -1;
LPVOID lpvPtr1, lpvPtr2;
DWORD dwBytes1, dwBytes2;
int AudioInterruptTime = -1;
DWORD lastLength = 0;

LPDIRECTSOUNDBUFFER lpdsbuff;

DWORD buffsize = 0;
DWORD laststatus = 0;
DWORD interruptcnt = 0;

// Fills up a buffer and remixes the audio
void AudioCode::FillBuffer (BYTE *buff, DWORD len) {
	DWORD cnt = 0;
	DWORD x = 0;
	DWORD pastFill = readLoc;
	DWORD pastLoc = (len - remainingBytes)/2;

	if (configForceSync) {
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
			interruptcnt--;
			*AudioInfo.AI_STATUS_REG &= ~0x80000000;
	}
	if (configAIEmulation == true) {
		if (*AudioInfo.AI_STATUS_REG & 0x80000000) {
			//dprintf ("I");
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
			interruptcnt--;
			*AudioInfo.AI_STATUS_REG &= ~0x80000000;
		}
	}

	if (remainingBytes == 0) {
		dprintf ("-");
		memset (buff, 0, len);
		return;
	}
	if (remainingBytes < len) {
		dprintf ("!");
		memset (buff, 0, len); // Save it for another buffer fill
		return;
	} else {
	while ((remainingBytes > 0) && (cnt != len)) { // Optimize this copy routine later
		*(DWORD *)(&buff[cnt]) = *(DWORD *)(&SoundBuffer[readLoc]);
		//cnt++; readLoc++; remainingBytes--;
		cnt+=4; readLoc+=4;remainingBytes-=4;
		if (readLoc == MAXBUFFER)
			readLoc = 0;
	}
	}
	// Check into cnt != len...
	if (cnt != len)
		printf ("%");

	while (cnt != len) {
		buff[cnt] = 0;
		cnt++;
	}
}


DWORD WINAPI AudioThreadProc (AudioCode *ac) {
	DWORD dwStatus;
	//LPDIRECTSOUNDBUFFER  lpdsbuf = ac->lpdsbuf;
	LPDIRECTSOUND        lpds  = ac->lpds;

	lpdsbuff = ac->lpdsbuf;

	while (lpdsbuff == NULL)
		Sleep (10);

	IDirectSoundBuffer_GetStatus(lpdsbuff,&dwStatus);
		if ((dwStatus & DSBSTATUS_PLAYING) == 0) {
			IDirectSoundBuffer_Play(lpdsbuff, 0, 0, 0 );
	}

	SetThreadPriority (ac->handleAudioThread, THREAD_PRIORITY_HIGHEST);

	while (ac->audioIsDone == false) { // While the thread is still alive
		while (last_pos == write_pos) { // Cycle around until a new buffer position is available
			if (lpdsbuff == NULL)
				ExitThread (-1);
			if (write_pos == last_pos) {
				Sleep (1);
			}
			WaitForSingleObject (ac->hMutex, INFINITE);
			if FAILED(lpdsbuff->GetCurrentPosition((unsigned long*)&play_pos, NULL)) {
				MessageBox (NULL, "Error getting audio position...", "AudioLLE Error", MB_OK|MB_ICONSTOP);
				goto _exit_;
			}
			ReleaseMutex (ac->hMutex);
			// *** Cached method ***
			if (play_pos < LOCK_SIZE) write_pos = (LOCK_SIZE * SEGMENTS) - LOCK_SIZE;
			else write_pos = ((play_pos / LOCK_SIZE) * LOCK_SIZE) - LOCK_SIZE;
			// *** JIT ***
			//write_pos = ((play_pos / LOCK_SIZE) * LOCK_SIZE) + (LOCK_SIZE*2);
			//if (write_pos >= TOTAL_SIZE) {
			//	write_pos -= TOTAL_SIZE;
			//}
			//if (play_pos >= (TOTAL_SIZE-LOCK_SIZE)) write_pos = LOCK_SIZE;
			//else write_pos = ((play_pos / LOCK_SIZE) * LOCK_SIZE) + LOCK_SIZE;

//			if (write_pos == last_pos) {
				last_play = play_pos; // Store the last play position
//				Sleep (1);
//			}
		}
		if (next_pos != write_pos) {
			dprintf ("A");
		}
		last_pos = write_pos;
		next_pos = write_pos + LOCK_SIZE;
		if (next_pos >= (LOCK_SIZE*SEGMENTS)) {
			next_pos -= (LOCK_SIZE*SEGMENTS);
		}
		WaitForSingleObject (ac->hMutex, INFINITE);
		if (DS_OK != lpdsbuff->Lock(write_pos, LOCK_SIZE, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0)) {
			MessageBox (NULL, "Error locking sound buffer", "Audio LLE", MB_OK|MB_ICONSTOP);
			goto _exit_;
		}
		ac->FillBuffer ((BYTE *)lpvPtr1, dwBytes1);
		if (dwBytes2)
			ac->FillBuffer ((BYTE *)lpvPtr2, dwBytes2);
		//
		if FAILED(lpdsbuff->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2)) {
			MessageBox(NULL, "Error unlocking sound buffer","Audio LLE", MB_OK|MB_ICONSTOP);
			goto _exit_;
		}
		ReleaseMutex(ac->hMutex);
		//Sleep (10);
	}

_exit_:
	ReleaseMutex(ac->hMutex);
	ac->handleAudioThread = NULL;
	ExitThread (0);
	return 0;
}





//------------------------------------------------------------------------

// Setup and Teardown Functions

// Generates nice alignment with N64 samples...
void AudioCode::SetSegmentSize (DWORD length) {

    DSBUFFERDESC        dsbdesc;
    WAVEFORMATEX        wfm;
    HRESULT             hr;

    if (SampleRate == 0) { return; }
	SegmentSize = length;

	WaitForSingleObject (hMutex, INFINITE);
    memset( &wfm, 0, sizeof( WAVEFORMATEX ) ); 

	wfm.wFormatTag = WAVE_FORMAT_PCM;
	wfm.nChannels = 2;
	wfm.nSamplesPerSec = SampleRate;
	wfm.wBitsPerSample = 16;
	wfm.nBlockAlign = wfm.wBitsPerSample / 8 * wfm.nChannels;
	wfm.nAvgBytesPerSec = wfm.nSamplesPerSec * wfm.nBlockAlign;

    memset( &dsbdesc, 0, sizeof( DSBUFFERDESC ) ); 
    dsbdesc.dwSize = sizeof( DSBUFFERDESC ); 
    //dsbdesc.dwFlags = DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.dwFlags = DSBCAPS_GLOBALFOCUS | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_LOCSOFTWARE;
    dsbdesc.dwBufferBytes = SegmentSize * SEGMENTS;  
    dsbdesc.lpwfxFormat = &wfm; 

	if ( FAILED( hr = IDirectSound_CreateSoundBuffer(lpds, &dsbdesc, &lpdsbuf, NULL ) ) ) {
		__asm int 3;
		return;
	}

	IDirectSoundBuffer_Play(lpdsbuf, 0, 0, DSBPLAY_LOOPING );
	lpdsbuff = this->lpdsbuf;
	ReleaseMutex (hMutex);
}

BOOL AudioCode::Initialize (HWND hwnd) {
	audioIsPlaying = FALSE;

	LPDIRECTSOUNDBUFFER lpdsb;
    DSBUFFERDESC        dsPrimaryBuff;
    WAVEFORMATEX        wfm;
    HRESULT             hr;

	DeInitialize (); // Release just in case...

	dprintf ("Initialize()\n");
	hMutex = CreateMutex(NULL,FALSE,NULL);

	WaitForSingleObject (hMutex, INFINITE);

    if ( FAILED( hr = DirectSoundCreate( NULL, &lpds, NULL ) ) ) {
		__asm int 3;
        return FALSE;
	}

    if ( FAILED( hr = IDirectSound_SetCooperativeLevel(lpds, hwnd, DSSCL_PRIORITY   ))) {
        return FALSE;
	}

	if (lpdsbuf) { 		
		IDirectSoundBuffer_Release(lpdsbuf); 
		lpdsbuf = NULL;
	}
	memset( &dsPrimaryBuff, 0, sizeof( DSBUFFERDESC ) ); 
    
	dsPrimaryBuff.dwSize        = sizeof( DSBUFFERDESC ); 
    dsPrimaryBuff.dwFlags       = DSBCAPS_PRIMARYBUFFER; 
    dsPrimaryBuff.dwBufferBytes = 0;  
    dsPrimaryBuff.lpwfxFormat   = NULL; 
    memset( &wfm, 0, sizeof( WAVEFORMATEX ) ); 

	wfm.wFormatTag = WAVE_FORMAT_PCM;
	wfm.nChannels = 2;
	wfm.nSamplesPerSec = 44100;
	wfm.wBitsPerSample = 16;
	wfm.nBlockAlign = wfm.wBitsPerSample / 8 * wfm.nChannels;
	wfm.nAvgBytesPerSec = wfm.nSamplesPerSec * wfm.nBlockAlign;

	hr = IDirectSound_CreateSoundBuffer(lpds,&dsPrimaryBuff, &lpdsb, NULL);
	
	if (SUCCEEDED ( hr ) ) {
		IDirectSoundBuffer_SetFormat(lpdsb, &wfm );
	    IDirectSoundBuffer_Play(lpdsb, 0, 0, DSBPLAY_LOOPING );
	}

	ReleaseMutex (hMutex);

	SetSegmentSize (LOCK_SIZE);

	dprintf ("Init Success...\n");
	return TRUE;
}

void AudioCode::DeInitialize () {

	dprintf ("DeInitialize()\n");
	StopAudio ();
    if (lpdsbuf) { 
		IDirectSoundBuffer_Stop(lpdsbuf);
		IDirectSoundBuffer_Release(lpdsbuf);
		lpdsbuf = NULL;
	}
    if ( lpds ) {
		IDirectSound_Release(lpds);
		lpds = NULL;
	}
	if (hMutex) { 
		CloseHandle(hMutex); 
		hMutex = NULL;
	}
}

// ---------BLAH--------
#define u32 DWORD

// Buffer Functions for the Audio Code
void AudioCode::SetFrequency (DWORD Frequency) {
	dprintf ("SetFrequency()\n");
	SampleRate = Frequency;
	SegmentSize = 0; // Trash it... we need to redo the Frequency anyway...
	SetSegmentSize (LOCK_SIZE);
	dprintf ("Frequency: %i - SegmentSize: %i\n", Frequency, SegmentSize);
	lastLength = 0;
}

void AudioCode::AiUpdate (BOOL Wait) {

	if (Wait)
		WaitMessage();
	return;

	if (configForceSync && (*AudioInfo.AI_STATUS_REG & 0x80000000)) {
		if (remainingBytes < LOCK_SIZE*2) {
			*AudioInfo.AI_STATUS_REG &= ~0x80000000;
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
			interruptcnt--;
		}
	}
}

DWORD AudioCode::AddBuffer (BYTE *start, DWORD length) {
	DWORD retVal = 0;
	DWORD max = remainingBytes+length;
	interruptcnt++;
	if (lastLength != length) {
		//dprintf ("len: %i\n", length);
		lastLength = length;
	}

	//dprintf ("B");
	if ((length == 0) || (lpdsbuf == NULL)) {
			*AudioInfo.AI_STATUS_REG &= ~0xC0000001;
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
			interruptcnt--;
			//dprintf ("I");
		return 0;
	}

	if (!audioIsPlaying)
		StartAudio ();

	if (max > MAXBUFFER) {
		if (lastLength != length) {
			lastLength = length;
			//dprintf ("\nlast: %i, len: %i, MB: %i, SEG: %i\n", lastLength, length, MAXBUFFER, LOCK_SIZE);
		}
		dprintf (",");
	}
	if (configSyncAudio && (max > MAXBUFFER)) {
		while ((remainingBytes+length) > MAXBUFFER) { // Halve the buffer...
			Sleep(1);
		}
	}
	if (configForceSync) {
		//bool test;
		if (remainingBytes > LOCK_SIZE*2) {
			*AudioInfo.AI_STATUS_REG |= 0xC0000000;
		}
		while (remainingBytes > LOCK_SIZE*2) { // Force buffer sync
			Sleep(1);
		}
	}

	WaitForSingleObject (hMutex, INFINITE);

	for (DWORD x = 0; x < length; x+=4) {
		SoundBuffer[writeLoc++] = start[x+2];
		SoundBuffer[writeLoc++] = start[x+3];
		SoundBuffer[writeLoc++] = start[x];
		SoundBuffer[writeLoc++] = start[x+1];
		//writeLoc+=4; 
		remainingBytes+=4;
		if (writeLoc == MAXBUFFER)
			writeLoc = 0;
	}

	if (configAIEmulation && !configForceSync) {
		if ((remainingBytes+length) > MAXBUFFER) { // Then we should be careful about overflow
			*AudioInfo.AI_STATUS_REG |= 0xC0000000;
		} else {
			*AudioInfo.AI_STATUS_REG &= ~0x80000000;
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
			interruptcnt--;
			//dprintf ("I");
		}
	}

	ReleaseMutex (hMutex);

	if (interruptcnt > 1)
		dprintf ("NO!!!\n");


	return retVal;
}

// Management functions
// TODO: For silent emulation... the Audio should still be "processed" somehow...
void AudioCode::StopAudio () {
	dprintf ("StopAudio()\n");
	if (!audioIsPlaying) return;
	audioIsPlaying = FALSE;
	TerminateThread (this->handleAudioThread, 0);
}

void AudioCode::StartAudio () {
	dprintf ("StartAudio()\n");
	if (audioIsPlaying) return;
	audioIsPlaying = TRUE;
	this->handleAudioThread = CreateThread (NULL, NULL, (LPTHREAD_START_ROUTINE)AudioThreadProc, this, NULL, &this->dwAudioThreadId);
	writeLoc = 0x0000;
	readLoc = 0x0000;
	remainingBytes = 0;
}

DWORD AudioCode::GetReadStatus () {
	if (configForceSync)
		return 0;//remainingBytes;
	if (configAIEmulation == true) {
		if (remainingBytes < (LOCK_SIZE*2)) {
			return 0;
		} else { // This was the problem with SP_DMA_READ Error
			if (remainingBytes > lastLength) return (remainingBytes%lastLength);
			else return remainingBytes;
			//return 0;//remainingBytes;  // TODO: Maybe return last buffer fill size?
		}
	} else {
		return 0;
	}
}
