#include <windows.h>
#include "AudioSpec.h"
#include "AudioCode.h"
#include "audiohle.h"

#define PLUGIN_VERSION "0.55.1 Alpha"

// New Plugin Specification


// Old Plugin Specification


// Dialogs

EXPORT void CALL DllAbout ( HWND hParent ){
	MessageBox (hParent, "No About yet... ", "About Box", MB_OK);
}

EXPORT void CALL DllConfig ( HWND hParent ){
	MessageBox (hParent, "Nothing to config yet... ", "Config Box", MB_OK);
}

EXPORT void CALL DllTest ( HWND hParent ){
	MessageBox (hParent, "Nothing to test yet... ", "Test Box", MB_OK);
}

// Initialization / Deinitalization Functions

// Note: We call CloseDLL just in case the audio plugin was already initialized...
AUDIO_INFO AudioInfo;
AudioCode  snd;
DWORD Dacrate = 0;
void AiCallBack (DWORD Status);

EXPORT BOOL CALL InitiateAudio (AUDIO_INFO Audio_Info){
	CloseDLL ();
	memcpy (&AudioInfo, &Audio_Info, sizeof(AUDIO_INFO));
	snd.Initialize (AudioInfo.hwnd);
	snd.configAIEmulation = true;
	snd.configSyncAudio   = true;
	snd.configForceSync   = false;
	return TRUE;
}

EXPORT void CALL CloseDLL (void){
	ChangeABI (0);
	snd.DeInitialize ();
}

EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo ){
	PluginInfo->MemoryBswaped = TRUE;
	PluginInfo->NormalMemory  = FALSE;
	strcpy (PluginInfo->Name, "Azimer's HLE Audio v");
	strcat (PluginInfo->Name, PLUGIN_VERSION);
	PluginInfo->Type = PLUGIN_TYPE_AUDIO;
	PluginInfo->Version = 0x0101; // Set this to retain backwards compatibility
}

EXPORT void CALL ProcessAList(void){
	HLEStart ();
}

EXPORT void CALL RomClosed (void){
	ChangeABI (0);
	snd.StopAudio ();
	Dacrate = 0;
	snd.Initialize(AudioInfo.hwnd);
}

EXPORT void CALL AiDacrateChanged (int  SystemType) {
	DWORD Frequency;
	if (Dacrate != *AudioInfo.AI_DACRATE_REG) {
		Dacrate = *AudioInfo.AI_DACRATE_REG;
		switch (SystemType) {
			case SYSTEM_NTSC: Frequency = 48681812 / (Dacrate + 1); break;
			case SYSTEM_PAL:  Frequency = 49656530 / (Dacrate + 1); break;
			case SYSTEM_MPAL: Frequency = 48628316 / (Dacrate + 1); break;
		}
		snd.SetFrequency (Frequency);
	}
}

EXPORT void CALL AiLenChanged (void){
	DWORD retVal;
	retVal = snd.AddBuffer (
		(AudioInfo.RDRAM + (*AudioInfo.AI_DRAM_ADDR_REG & 0x00FFFFF8)), 
		*AudioInfo.AI_LEN_REG & 0x3FFF8);
	//if (retVal & SND_IS_FULL)
	//	*AudioInfo.AI_STATUS_REG |= AI_STATUS_FIFO_FULL;
	//*AudioInfo.AI_STATUS_REG |= AI_STATUS_DMA_BUSY;
}

EXPORT DWORD CALL AiReadLength (void){
	*AudioInfo.AI_LEN_REG = snd.GetReadStatus ();
	return *AudioInfo.AI_LEN_REG;
}

// Deprecated Functions

EXPORT void CALL AiUpdate (BOOL Wait){
	if (Wait)
		WaitMessage ();
}
